/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.expeditionconnector.impl;

import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.domain.racelogtracking.DeviceIdentifierStringSerializationHandler;
import com.sap.sailing.domain.tracking.WindTrackerFactory;
import com.sap.sailing.expeditionconnector.ExpeditionDeviceConfiguration;
import com.sap.sailing.expeditionconnector.ExpeditionTrackerFactory;
import com.sap.sailing.expeditionconnector.impl.ExpeditionGpsStringSerializationHandler;
import com.sap.sailing.expeditionconnector.impl.ExpeditionSensorDeviceIdentifierJsonHandler;
import com.sap.sailing.expeditionconnector.impl.ExpeditionSensorStringSerializationHandler;
import com.sap.sailing.expeditionconnector.persistence.DomainObjectFactory;
import com.sap.sailing.expeditionconnector.persistence.ExpeditionGpsDeviceIdentifierJsonHandler;
import com.sap.sailing.expeditionconnector.persistence.MongoObjectFactory;
import com.sap.sailing.expeditionconnector.persistence.PersistenceFactory;
import com.sap.sailing.server.gateway.serialization.racelog.tracking.DeviceIdentifierJsonHandler;
import com.sap.sse.replication.FullyInitializedReplicableTracker;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.util.impl.ThreadFactoryWithPriority;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private static Logger logger = Logger.getLogger(Activator.class.getName());
    private static final String EXPEDITION_UDP_PORT_PROPERTY_NAME = "expedition.udp.port";
    private static Activator instance;
    private Set<ServiceRegistration<?>> registrations = new HashSet();
    private static final int DEFAULT_PORT = 2013;
    private int port;
    private BundleContext context;
    private final ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)new ThreadFactoryWithPriority(5, Boolean.valueOf(true)));

    public Activator() {
        this.port = Integer.valueOf(System.getProperty(EXPEDITION_UDP_PORT_PROPERTY_NAME, "2013"));
        logger.log(Level.INFO, "setting default for expedition.udp.port to " + this.port);
    }

    private Dictionary<String, String> getDict(String type) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("type", type);
        return properties;
    }

    public void start(BundleContext context) throws Exception {
        this.context = context;
        if (instance == null) {
            instance = this;
        }
        if (context.getProperty(EXPEDITION_UDP_PORT_PROPERTY_NAME) != null) {
            this.port = Integer.valueOf(context.getProperty(EXPEDITION_UDP_PORT_PROPERTY_NAME));
            logger.log(Level.INFO, "found expedition.udp.port=" + this.port + " in OSGi context");
        }
        DomainObjectFactory domainObjectFactory = PersistenceFactory.INSTANCE.getDefaultDomainObjectFactory();
        MongoObjectFactory mongoObjectFactory = PersistenceFactory.INSTANCE.getDefaultMongoObjectFactory();
        this.executor.execute(() -> {
            logger.info("Creating ExpeditionTrackerFactory");
            ExpeditionTrackerFactory expeditionTrackerFactory = new ExpeditionTrackerFactory(null, domainObjectFactory, mongoObjectFactory);
            this.registrations.add(context.registerService(ExpeditionTrackerFactory.class, (Object)expeditionTrackerFactory, null));
            this.registrations.add(context.registerService(WindTrackerFactory.class, (Object)expeditionTrackerFactory, null));
            this.registrations.add(context.registerService(DeviceIdentifierJsonHandler.class, (Object)new ExpeditionGpsDeviceIdentifierJsonHandler(), this.getDict("EXPEDITION_GPS")));
            this.registrations.add(context.registerService(DeviceIdentifierStringSerializationHandler.class, (Object)new ExpeditionGpsStringSerializationHandler(), this.getDict("EXPEDITION_GPS")));
            this.registrations.add(context.registerService(DeviceIdentifierJsonHandler.class, (Object)new ExpeditionSensorDeviceIdentifierJsonHandler(), this.getDict("EXPEDITION_SENSOR")));
            this.registrations.add(context.registerService(DeviceIdentifierStringSerializationHandler.class, (Object)new ExpeditionSensorStringSerializationHandler(), this.getDict("EXPEDITION_SENSOR")));
            new Thread(() -> {
                FullyInitializedReplicableTracker securityServiceServiceTracker = FullyInitializedReplicableTracker.createAndOpen((BundleContext)context, SecurityService.class);
                try {
                    SecurityService securityService = (SecurityService)securityServiceServiceTracker.getInitializedService(0L);
                    for (ExpeditionDeviceConfiguration expeditionDeviceConfiguration : expeditionTrackerFactory.getDeviceConfigurations()) {
                        securityService.migrateOwnership((WithQualifiedObjectIdentifier)expeditionDeviceConfiguration);
                    }
                    securityService.assumeOwnershipMigrated(SecuredDomainType.EXPEDITION_DEVICE_CONFIGURATION.getName());
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Exception trying to migrate Expedition Devices implementation", e);
                }
            }, String.valueOf(this.getClass().getName()) + " registering connectivity handler").start();
        });
    }

    public static Activator getInstance() {
        if (instance == null) {
            instance = new Activator();
        }
        return instance;
    }

    public BundleContext getContext() {
        return this.context;
    }

    public void setContext(BundleContext context) {
        this.context = context;
    }

    public void stop(BundleContext context) throws Exception {
        for (ServiceRegistration<?> reg : this.registrations) {
            reg.unregister();
        }
        this.registrations.clear();
        this.context = null;
    }

    public int getExpeditionUDPPort() {
        return this.port;
    }
}

