/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.expeditionconnector;

import com.sap.sailing.declination.Declination;
import com.sap.sailing.declination.DeclinationService;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.domain.common.impl.WindSourceWithAdditionalID;
import com.sap.sailing.domain.tracking.AbstractWindTracker;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.WindTracker;
import com.sap.sailing.expeditionconnector.ExpeditionListener;
import com.sap.sailing.expeditionconnector.ExpeditionMessage;
import com.sap.sailing.expeditionconnector.ExpeditionTrackerFactory;
import com.sap.sailing.expeditionconnector.UDPExpeditionReceiver;
import com.sap.sse.common.impl.DegreeBearingImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExpeditionWindTracker
extends AbstractWindTracker
implements ExpeditionListener,
WindTracker {
    private static final Logger logger = Logger.getLogger(ExpeditionWindTracker.class.getName());
    private final DeclinationService declinationService;
    private final Map<Integer, Position> lastKnownPositionPerBoatID = new HashMap<Integer, Position>();
    private final UDPExpeditionReceiver receiver;
    private final ExpeditionTrackerFactory factory;

    public ExpeditionWindTracker(DynamicTrackedRace race, DeclinationService declinationService, UDPExpeditionReceiver receiver, ExpeditionTrackerFactory factory) {
        super(race);
        this.declinationService = declinationService;
        this.receiver = receiver;
        this.factory = factory;
        receiver.addListener(this, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ExpeditionTrackerFactory expeditionTrackerFactory = this.factory;
        synchronized (expeditionTrackerFactory) {
            this.receiver.removeListener(this);
            this.factory.trackerStopped(this.getTrackedRace().getRace(), this);
        }
    }

    UDPExpeditionReceiver getReceiver() {
        return this.receiver;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " on UDP port " + this.getReceiver().getPort();
    }

    public void received(ExpeditionMessage message) {
        SpeedWithBearing windSpeed;
        if (message.getGPSFix() != null) {
            this.lastKnownPositionPerBoatID.put(message.getBoatID(), message.getGPSFix().getPosition());
        }
        if ((windSpeed = message.getTrueWind()) != null) {
            block9: {
                if (this.declinationService != null) {
                    if (this.lastKnownPositionPerBoatID.get(message.getBoatID()) != null) {
                        try {
                            Declination declination = this.declinationService.getDeclination(message.getTimePoint(), this.lastKnownPositionPerBoatID.get(message.getBoatID()), 500L);
                            if (declination != null) {
                                windSpeed = new KnotSpeedWithBearingImpl(windSpeed.getKnots(), new DegreeBearingImpl(windSpeed.getBearing().getDegrees()).add(declination.getBearingCorrectedTo(message.getTimePoint())));
                                break block9;
                            }
                            logger.warning("Unable to obtain declination for wind bearing correction for time point " + message.getTimePoint() + " and position " + this.lastKnownPositionPerBoatID.get(message.getBoatID()));
                            windSpeed = null;
                        }
                        catch (Exception e) {
                            logger.log(Level.INFO, "Unable to correct wind bearing by declination. Exception while computing declination: " + e.getMessage());
                            logger.throwing(ExpeditionWindTracker.class.getName(), "received", e);
                            windSpeed = null;
                        }
                    } else {
                        windSpeed = null;
                        logger.log(Level.INFO, "Unable to use wind direction because declination correction requested and position not known");
                    }
                }
            }
            if (windSpeed != null && this.lastKnownPositionPerBoatID.get(message.getBoatID()) != null) {
                WindImpl wind = new WindImpl(this.lastKnownPositionPerBoatID.get(message.getBoatID()), message.getTimePoint(), windSpeed);
                String windSourceID = Integer.valueOf(message.getBoatID()).toString();
                this.sendWindToRace((Wind)wind, windSourceID);
            }
        }
    }

    protected void sendWindToRace(Wind wind, String windSourceID) {
        this.getTrackedRace().recordWind(wind, (WindSource)new WindSourceWithAdditionalID(WindSourceType.EXPEDITION, windSourceID));
    }
}

