/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.components;

import com.sap.sse.common.Util;
import com.sap.sse.datamining.components.AdditionalResultDataBuilder;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.components.ProcessorInstruction;
import com.sap.sse.datamining.functions.Function;
import com.sap.sse.datamining.functions.ParameterProvider;
import com.sap.sse.datamining.functions.ParameterizedFunction;
import com.sap.sse.datamining.impl.components.AbstractParallelProcessor;
import com.sap.sse.datamining.impl.components.AbstractProcessorInstruction;
import com.sap.sse.datamining.impl.components.GroupedDataEntry;
import com.sap.sse.datamining.impl.components.ProcessorInstructionPriority;
import com.sap.sse.datamining.shared.GroupKey;
import com.sap.sse.datamining.shared.impl.CompoundGroupKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;

public abstract class AbstractParallelMultiDimensionalNestingGroupingProcessor<DataType>
extends AbstractParallelProcessor<DataType, GroupedDataEntry<DataType>> {
    private Iterable<ParameterizedFunction<?>> parameterizedDimensions;

    public AbstractParallelMultiDimensionalNestingGroupingProcessor(Class<DataType> dataType, ExecutorService executor, Collection<Processor<GroupedDataEntry<DataType>, ?>> resultReceivers, Iterable<ParameterizedFunction<?>> parameterizedDimensions) {
        super(dataType, GroupedDataEntry.class, executor, resultReceivers);
        this.verifyThatDimensionsAreDimensions(parameterizedDimensions);
        this.parameterizedDimensions = parameterizedDimensions;
    }

    private void verifyThatDimensionsAreDimensions(Iterable<ParameterizedFunction<?>> parameterizedDimensions) {
        if (parameterizedDimensions == null) {
            throw new IllegalArgumentException("The given dimensions mustn't be null.");
        }
        int size = 0;
        for (ParameterizedFunction<?> possibleParameterizedDimension : parameterizedDimensions) {
            ++size;
            if (possibleParameterizedDimension.getFunction().isDimension()) continue;
            throw new IllegalArgumentException("The given function " + possibleParameterizedDimension.getFunction().toString() + " is no dimension.");
        }
        if (size == 0) {
            throw new IllegalArgumentException("The given dimensions are empty.");
        }
    }

    @Override
    protected ProcessorInstruction<GroupedDataEntry<DataType>> createInstruction(final DataType element) {
        return new AbstractProcessorInstruction<GroupedDataEntry<DataType>>(this, ProcessorInstructionPriority.Grouping){

            @Override
            public GroupedDataEntry<DataType> computeResult() {
                return new GroupedDataEntry<Object>(AbstractParallelMultiDimensionalNestingGroupingProcessor.this.createGroupKeyFor(element), element);
            }
        };
    }

    private GroupKey createGroupKeyFor(DataType input) {
        if (Util.size(this.parameterizedDimensions) == 1) {
            ParameterizedFunction parameterizedDimension = (ParameterizedFunction)Util.get(this.parameterizedDimensions, (int)0);
            return this.createGroupKeyFor(input, parameterizedDimension.getFunction(), parameterizedDimension.getParameterProvider());
        }
        ArrayList<GroupKey> keys = new ArrayList<GroupKey>();
        for (ParameterizedFunction<?> parameterizedDimension : this.parameterizedDimensions) {
            if (this.isAborted()) break;
            keys.add(this.createGroupKeyFor(input, parameterizedDimension.getFunction(), parameterizedDimension.getParameterProvider()));
        }
        return new CompoundGroupKey(keys);
    }

    protected abstract GroupKey createGroupKeyFor(DataType var1, Function<?> var2, ParameterProvider var3);

    @Override
    protected void setAdditionalData(AdditionalResultDataBuilder additionalDataBuilder) {
    }
}

