/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.aicore.impl;

import com.sap.sse.aicore.AICore;
import com.sap.sse.aicore.ChatSession;
import com.sap.sse.aicore.Credentials;
import com.sap.sse.aicore.Deployment;
import com.sap.sse.common.Util;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;

public class ChatSessionImpl
implements ChatSession {
    private static final Logger logger = Logger.getLogger(ChatSessionImpl.class.getName());
    private static final String TEMPERATURE = "temperature";
    private static final String TOP_P = "top_p";
    private static final String MAX_TOKENS = "max_tokens";
    private static final String MAX_COMPLETION_TOKENS = "max_completion_tokens";
    private static final String PRESENCE_PENALTY = "presence_penalty";
    private static final String FREQUENCY_PENALTY = "frequency_penalty";
    private static final String CONTENT = "content";
    private static final String MESSAGE = "message";
    private static final String CHOICES = "choices";
    private static final String USER_PROMPT = "user";
    private static final String SYSTEM_PROPMPT = "system";
    private static final String MESSAGES = "messages";
    private static final String API_VERSION = "2025-04-01-preview";
    private static final String CHAT_PATH_TEMPLATE = "/v2/inference/deployments/%s/chat/completions?api-version=2025-04-01-preview";
    private final List<String> systemPrompts;
    private final List<String> userPrompts;
    private final AICore aiCore;
    private final Deployment deployment;
    private Double temperature;
    private Double top_p;
    private Integer maxTokens;
    private Integer maxCompletionTokens;
    private Double presencePenalty;
    private Double frequencyPenalty;

    public ChatSessionImpl(AICore aiCore, Deployment deployment) {
        this.aiCore = aiCore;
        this.deployment = deployment;
        this.systemPrompts = new ArrayList<String>();
        this.userPrompts = new ArrayList<String>();
    }

    public ChatSessionImpl(Credentials credentials, String modelName) throws UnsupportedOperationException, ClientProtocolException, URISyntaxException, IOException, ParseException {
        this(AICore.create(credentials), modelName);
    }

    public ChatSessionImpl(AICore aiCore, String modelName) throws UnsupportedOperationException, ClientProtocolException, URISyntaxException, IOException, ParseException {
        this(aiCore, aiCore.getDeploymentByModelName(modelName).get());
    }

    @Override
    public Double getTemperature() {
        return this.temperature;
    }

    @Override
    public ChatSession setTemperature(Double temperature) {
        this.temperature = temperature;
        return this;
    }

    @Override
    public Double getTop_p() {
        return this.top_p;
    }

    @Override
    public ChatSession setTop_p(Double top_p) {
        this.top_p = top_p;
        return this;
    }

    @Override
    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    @Override
    public ChatSession setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
        return this;
    }

    @Override
    public Integer getMaxCompletionTokens() {
        return this.maxCompletionTokens;
    }

    @Override
    public ChatSession setMaxCompletionTokens(Integer maxCompletionTokens) {
        this.maxCompletionTokens = maxCompletionTokens;
        return this;
    }

    @Override
    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    @Override
    public ChatSession setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
        return this;
    }

    @Override
    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    @Override
    public ChatSession setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
        return this;
    }

    @Override
    public ChatSession addSystemPrompt(String prompt) {
        this.systemPrompts.add(prompt);
        return this;
    }

    @Override
    public ChatSession addPrompt(String prompt) {
        this.userPrompts.add(prompt);
        return this;
    }

    private String getChatPath() {
        return String.format(CHAT_PATH_TEMPLATE, this.deployment.getId());
    }

    private void addPromptMessages(Iterable<String> prompts, String role, JSONArray messagesToAddTo) {
        for (String prompt : prompts) {
            JSONObject message = new JSONObject();
            message.put((Object)"role", (Object)role);
            message.put((Object)CONTENT, (Object)prompt);
            messagesToAddTo.add((Object)message);
        }
    }

    @Override
    public void submit(Consumer<String> callback, Optional<Consumer<Exception>> exceptionHandler) {
        try {
            HttpPost postRequest = this.createAndParameterizePostRequest();
            this.aiCore.getJSONResponse((HttpUriRequest)postRequest, chatResponse -> {
                try {
                    callback.accept(this.getChoicesFromResponse((JSONObject)chatResponse));
                }
                catch (Exception e) {
                    this.forwardToExceptionHandlerOrLog(exceptionHandler, e);
                }
            }, exceptionHandler);
        }
        catch (Exception e) {
            this.forwardToExceptionHandlerOrLog(exceptionHandler, e);
        }
    }

    private Object forwardToExceptionHandlerOrLog(Optional<Consumer<Exception>> exceptionHandler, Exception e) {
        return exceptionHandler.map(handler -> {
            handler.accept(e);
            return null;
        }).orElseGet(() -> {
            logger.log(Level.SEVERE, "Exception trying to submit prompt", e);
            return null;
        });
    }

    @Override
    public String submit() throws UnsupportedOperationException, ClientProtocolException, URISyntaxException, IOException, ParseException {
        HttpPost postRequest = this.createAndParameterizePostRequest();
        JSONObject chatResponse = this.aiCore.getJSONResponse((HttpUriRequest)postRequest);
        return this.getChoicesFromResponse(chatResponse);
    }

    private String getChoicesFromResponse(JSONObject chatResponse) {
        ArrayList<String> results = new ArrayList<String>();
        for (Object choice : (JSONArray)chatResponse.get((Object)CHOICES)) {
            JSONObject choiseJson = (JSONObject)choice;
            JSONObject message = (JSONObject)choiseJson.get((Object)MESSAGE);
            String content = message.get((Object)CONTENT).toString();
            results.add(content);
        }
        return Util.joinStrings((String)"\n", results);
    }

    private HttpPost createAndParameterizePostRequest() throws UnsupportedOperationException, ClientProtocolException, URISyntaxException, IOException, ParseException, UnsupportedCharsetException {
        HttpPost postRequest = this.aiCore.getHttpPostRequest(this.getChatPath());
        JSONObject toSubmit = new JSONObject();
        JSONArray messages = new JSONArray();
        toSubmit.put((Object)MESSAGES, (Object)messages);
        this.addPromptMessages(this.systemPrompts, SYSTEM_PROPMPT, messages);
        this.addPromptMessages(this.userPrompts, USER_PROMPT, messages);
        if (this.getFrequencyPenalty() != null) {
            toSubmit.put((Object)FREQUENCY_PENALTY, (Object)this.getFrequencyPenalty());
        }
        if (this.getMaxCompletionTokens() != null) {
            toSubmit.put((Object)MAX_COMPLETION_TOKENS, (Object)this.getMaxCompletionTokens());
        }
        if (this.getMaxTokens() != null) {
            toSubmit.put((Object)MAX_TOKENS, (Object)this.getMaxTokens());
        }
        if (this.getTemperature() != null) {
            toSubmit.put((Object)TEMPERATURE, (Object)this.getTemperature());
        }
        if (this.getTop_p() != null) {
            toSubmit.put((Object)TOP_P, (Object)this.getTop_p());
        }
        if (this.getPresencePenalty() != null) {
            toSubmit.put((Object)PRESENCE_PENALTY, (Object)this.getPresencePenalty());
        }
        postRequest.setEntity((HttpEntity)new StringEntity(toSubmit.toJSONString(), ContentType.APPLICATION_JSON));
        return postRequest;
    }
}

