/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.tracking.impl;

import com.sap.sailing.domain.common.tracking.DoubleVectorFix;
import com.sap.sse.common.TimePoint;
import java.util.Arrays;
import java.util.BitSet;

public class DoubleVectorFixImpl
implements DoubleVectorFix {
    private static final long serialVersionUID = -425848879310273855L;
    private final double[] fixData;
    private final TimePoint timePoint;
    private final BitSet validComponents;

    public DoubleVectorFixImpl(TimePoint timePoint, Double[] fixData) {
        int usedSize = this.getLastUsedDouble(fixData);
        this.timePoint = timePoint;
        this.fixData = new double[usedSize];
        this.validComponents = new BitSet(usedSize);
        int i = 0;
        while (i < usedSize) {
            if (fixData[i] != null) {
                this.validComponents.set(i);
                this.fixData[i] = fixData[i];
            }
            ++i;
        }
    }

    private int getLastUsedDouble(Double[] fixData) {
        int i = fixData.length - 1;
        while (i >= 0) {
            if (fixData[i] != null) {
                return i + 1;
            }
            --i;
        }
        return 0;
    }

    public TimePoint getTimePoint() {
        return this.timePoint;
    }

    @Override
    public Double get(int index) {
        return index < this.fixData.length && this.validComponents.get(index) ? Double.valueOf(this.fixData[index]) : null;
    }

    @Override
    public Double[] get() {
        Double[] result = new Double[this.fixData.length];
        int i = 0;
        while (i < this.fixData.length) {
            result[i] = this.validComponents.get(i) ? Double.valueOf(this.fixData[i]) : null;
            ++i;
        }
        return result;
    }

    @Override
    public boolean hasValidData() {
        return !this.validComponents.isEmpty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.fixData);
        result = 31 * result + (this.timePoint == null ? 0 : this.timePoint.hashCode());
        result = 31 * result + (this.validComponents == null ? 0 : this.validComponents.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DoubleVectorFixImpl other = (DoubleVectorFixImpl)obj;
        if (!Arrays.equals(this.fixData, other.fixData)) {
            return false;
        }
        if (this.timePoint == null ? other.timePoint != null : !this.timePoint.equals(other.timePoint)) {
            return false;
        }
        return !(this.validComponents == null ? other.validComponents != null : !this.validComponents.equals(other.validComponents));
    }
}

