/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.tracking.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.AbstractSpeedWithAbstractBearingImpl;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.AbstractTimePoint;

public abstract class AbstractCompactWindImpl
extends AbstractSpeedWithAbstractBearingImpl
implements Wind {
    private static final long serialVersionUID = -5059956032663387929L;
    private static final byte POSITION_IS_NULL = 1;
    private static final byte BEARING_IS_NULL = 2;
    private static final byte TIME_POINT_IS_NULL = 4;
    private final byte flags;
    private final long timePointAsMillis;

    public AbstractCompactWindImpl(Wind wind) {
        boolean timePointIsNull;
        boolean positionIsNull;
        boolean bearingIsNull = wind.getBearing() == null;
        boolean bl = positionIsNull = wind.getPosition() == null;
        if (wind.getTimePoint() == null) {
            timePointIsNull = true;
            this.timePointAsMillis = 0L;
        } else {
            timePointIsNull = false;
            this.timePointAsMillis = wind.getTimePoint().asMillis();
        }
        this.flags = (byte)((bearingIsNull ? 2 : 0) | (positionIsNull ? 1 : 0) | (timePointIsNull ? 4 : 0));
    }

    @Override
    public Position getPosition() {
        if ((this.flags & 1) != 0) {
            return null;
        }
        return this.getCompactPosition();
    }

    protected abstract Position getCompactPosition();

    public TimePoint getTimePoint() {
        if ((this.flags & 4) != 0) {
            return null;
        }
        return new CompactTimePoint();
    }

    @Override
    public Bearing getBearing() {
        if ((this.flags & 2) != 0) {
            return null;
        }
        return this.getCompactBearing();
    }

    protected abstract Bearing getCompactBearing();

    @Override
    public abstract double getKnots();

    @Override
    public Bearing getFrom() {
        if (this.getBearing() == null) {
            return null;
        }
        return this.getBearing().reverse();
    }

    @Override
    public int hashCode() {
        return WindImpl.hashCode(this.getPosition().getLatDeg(), this.getPosition().getLngDeg(), (this.flags & 4) != 0 ? 0L : this.timePointAsMillis);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Wind)) {
            return false;
        }
        Wind other = (Wind)obj;
        return Util.equalsWithNull((Object)this.getPosition(), (Object)other.getPosition()) && Util.equalsWithNull((Object)this.getTimePoint(), (Object)other.getTimePoint());
    }

    @Override
    public String toString() {
        return this.getTimePoint() + "@" + this.getPosition() + ": " + this.getKnots() + "kn from " + this.getFrom();
    }

    private class CompactTimePoint
    extends AbstractTimePoint
    implements TimePoint {
        private static final long serialVersionUID = -2470922642359937437L;

        private CompactTimePoint() {
        }

        public long asMillis() {
            return AbstractCompactWindImpl.this.timePointAsMillis;
        }
    }
}

