/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.impl;

import com.sap.sailing.domain.common.WindSpeedStepping;
import java.util.Arrays;

public class WindSpeedSteppingImpl
implements WindSpeedStepping {
    private static final long serialVersionUID = 2215693490331489508L;
    protected double[] levels;

    protected WindSpeedSteppingImpl() {
    }

    public WindSpeedSteppingImpl(double[] levels) {
        this.levels = levels;
    }

    public int getNumberOfLevels() {
        return this.levels.length;
    }

    @Override
    public int getLevelIndexForValue(double speed) {
        int i = 0;
        while (i < this.levels.length - 1) {
            if (speed < this.levels[i] + (this.levels[i + 1] - this.levels[i]) / 2.0) {
                return i;
            }
            ++i;
        }
        return this.levels.length - 1;
    }

    @Override
    public double[] getRawStepping() {
        return this.levels;
    }

    @Override
    public Double getSteppedValueForValue(double speed) {
        int levelIndex = this.getLevelIndexForValue(speed);
        Double result = -1.0;
        if (levelIndex >= 0) {
            result = this.levels[levelIndex];
        }
        return result;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.levels);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WindSpeedSteppingImpl other = (WindSpeedSteppingImpl)obj;
        return Arrays.equals(this.levels, other.levels);
    }

    @Override
    public int getLevelIndexFloorForValue(double speed) {
        int result = -1;
        int i = 0;
        while (i < this.levels.length - 1) {
            if (speed >= this.levels[i]) {
                result = i;
            }
            ++i;
        }
        return result;
    }

    @Override
    public double getDistanceToLevelFloor(double speed) {
        double result = 0.0;
        int floor = this.getLevelIndexFloorForValue(speed);
        result = floor == -1 ? 0.0 : speed - this.levels[floor];
        return result;
    }

    @Override
    public int getLevelIndexCeilingForValue(double speed) {
        int floor = this.getLevelIndexFloorForValue(speed);
        if (floor == -1) {
            int n = -1;
        }
        int result = this.levels[floor] == speed ? floor : floor + 1;
        return result;
    }
}

