/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.impl;

import com.sap.sailing.domain.common.PolarSheetGenerationSettings;
import com.sap.sailing.domain.common.impl.WindSpeedSteppingWithMaxDistance;
import java.util.ArrayList;

public class PolarSheetGenerationSettingsImpl
extends PolarSheetGenerationSettings {
    private static final long serialVersionUID = 2731616509404813790L;
    private Integer minimumDataCountPerGraph;
    private double minimumWindConfidence;
    private Integer minimumDataCountPerAngle;
    private Integer numberOfHistogramColumns;
    private double minimumConfidenceMeasure;
    private boolean useOnlyWindGaugesForWindSpeed;
    private boolean shouldRemoveOutliers;
    private double outlierDetectionNeighboorhoodRadius;
    private double outlierMinimumNeighboorhoodPct;
    private boolean useOnlyEstimationForWindDirection;
    private WindSpeedSteppingWithMaxDistance windStepping;
    private boolean splitByWindGauges;
    private double pctOfLeadingCompetitorsToInclude;

    public static PolarSheetGenerationSettings createStandardPolarSettings() {
        double[] levels = new double[]{4.0, 6.0, 8.0, 10.0, 12.0, 14.0, 16.0, 20.0, 25.0, 30.0};
        WindSpeedSteppingWithMaxDistance windStepping = new WindSpeedSteppingWithMaxDistance(levels, 2.5);
        return new PolarSheetGenerationSettingsImpl(50, 0.01, 20, 20, 0.1, true, true, 2.0, 0.05, true, windStepping, false, 1.0);
    }

    public static PolarSheetGenerationSettings createBackendPolarSettings() {
        ArrayList<Double> levelList = new ArrayList<Double>();
        double levelValue = 0.5;
        while (levelValue < 35.0) {
            levelList.add(levelValue);
            levelValue += 0.5;
        }
        double[] levels = new double[levelList.size()];
        int i = 0;
        for (Double level : levelList) {
            levels[i++] = level;
        }
        WindSpeedSteppingWithMaxDistance windStepping = new WindSpeedSteppingWithMaxDistance(levels, 0.5);
        return new PolarSheetGenerationSettingsImpl(50, 0.1, 20, 20, 0.1, true, true, 2.0, 0.05, true, windStepping, false, 0.1);
    }

    PolarSheetGenerationSettingsImpl() {
    }

    public PolarSheetGenerationSettingsImpl(Integer minimumDataCountPerGraph, double minimumWindConfidence, Integer minimumDataCountPerAngle, Integer numberOfHistogramColumns, double minimumConfidenceMeasure, boolean useOnlyWindGaugesForWindSpeed, boolean shouldRemoveOutliers, double outlierDetectionNeighboorhoodRadius, double outlierMinimumNeighboorhoodPct, boolean useOnlyEstimationForWindDirection, WindSpeedSteppingWithMaxDistance windStepping, boolean splitByWindGauges, double pctOfLeadingCompetitorsToInclude) {
        this.minimumDataCountPerGraph = minimumDataCountPerGraph;
        this.minimumWindConfidence = minimumWindConfidence;
        this.minimumDataCountPerAngle = minimumDataCountPerAngle;
        this.numberOfHistogramColumns = numberOfHistogramColumns;
        this.minimumConfidenceMeasure = minimumConfidenceMeasure;
        this.useOnlyWindGaugesForWindSpeed = useOnlyWindGaugesForWindSpeed;
        this.shouldRemoveOutliers = shouldRemoveOutliers;
        this.outlierDetectionNeighboorhoodRadius = outlierDetectionNeighboorhoodRadius;
        this.outlierMinimumNeighboorhoodPct = outlierMinimumNeighboorhoodPct;
        this.useOnlyEstimationForWindDirection = useOnlyEstimationForWindDirection;
        this.windStepping = windStepping;
        this.splitByWindGauges = splitByWindGauges;
        this.pctOfLeadingCompetitorsToInclude = pctOfLeadingCompetitorsToInclude;
    }

    @Override
    public Integer getMinimumDataCountPerGraph() {
        return this.minimumDataCountPerGraph;
    }

    @Override
    public double getMinimumWindConfidence() {
        return this.minimumWindConfidence;
    }

    @Override
    public Integer getMinimumDataCountPerAngle() {
        return this.minimumDataCountPerAngle;
    }

    @Override
    public int getNumberOfHistogramColumns() {
        return this.numberOfHistogramColumns;
    }

    @Override
    public double getMinimumConfidenceMeasure() {
        return this.minimumConfidenceMeasure;
    }

    @Override
    public boolean useOnlyWindGaugesForWindSpeed() {
        return this.useOnlyWindGaugesForWindSpeed;
    }

    @Override
    public boolean shouldRemoveOutliers() {
        return this.shouldRemoveOutliers;
    }

    @Override
    public double getOutlierDetectionNeighborhoodRadius() {
        return this.outlierDetectionNeighboorhoodRadius;
    }

    @Override
    public double getOutlierMinimumNeighborhoodPct() {
        return this.outlierMinimumNeighboorhoodPct;
    }

    @Override
    public boolean useOnlyEstimatedForWindDirection() {
        return this.useOnlyEstimationForWindDirection;
    }

    @Override
    public WindSpeedSteppingWithMaxDistance getWindSpeedStepping() {
        return this.windStepping;
    }

    @Override
    public boolean splitByWindgauges() {
        return this.splitByWindGauges;
    }

    @Override
    public boolean areDefault() {
        return ((Object)((Object)PolarSheetGenerationSettingsImpl.createStandardPolarSettings())).equals((Object)this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.minimumConfidenceMeasure);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.minimumDataCountPerAngle == null ? 0 : this.minimumDataCountPerAngle.hashCode());
        result = 31 * result + (this.minimumDataCountPerGraph == null ? 0 : this.minimumDataCountPerGraph.hashCode());
        temp = Double.doubleToLongBits(this.minimumWindConfidence);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.numberOfHistogramColumns == null ? 0 : this.numberOfHistogramColumns.hashCode());
        temp = Double.doubleToLongBits(this.outlierDetectionNeighboorhoodRadius);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.outlierMinimumNeighboorhoodPct);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.shouldRemoveOutliers ? 1231 : 1237);
        result = 31 * result + (this.splitByWindGauges ? 1231 : 1237);
        result = 31 * result + (this.useOnlyEstimationForWindDirection ? 1231 : 1237);
        result = 31 * result + (this.useOnlyWindGaugesForWindSpeed ? 1231 : 1237);
        result = 31 * result + (this.windStepping == null ? 0 : this.windStepping.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PolarSheetGenerationSettingsImpl other = (PolarSheetGenerationSettingsImpl)((Object)obj);
        if (Double.doubleToLongBits(this.minimumConfidenceMeasure) != Double.doubleToLongBits(other.minimumConfidenceMeasure)) {
            return false;
        }
        if (this.minimumDataCountPerAngle == null ? other.minimumDataCountPerAngle != null : !this.minimumDataCountPerAngle.equals(other.minimumDataCountPerAngle)) {
            return false;
        }
        if (this.minimumDataCountPerGraph == null ? other.minimumDataCountPerGraph != null : !this.minimumDataCountPerGraph.equals(other.minimumDataCountPerGraph)) {
            return false;
        }
        if (Double.doubleToLongBits(this.minimumWindConfidence) != Double.doubleToLongBits(other.minimumWindConfidence)) {
            return false;
        }
        if (this.numberOfHistogramColumns == null ? other.numberOfHistogramColumns != null : !this.numberOfHistogramColumns.equals(other.numberOfHistogramColumns)) {
            return false;
        }
        if (Double.doubleToLongBits(this.outlierDetectionNeighboorhoodRadius) != Double.doubleToLongBits(other.outlierDetectionNeighboorhoodRadius)) {
            return false;
        }
        if (Double.doubleToLongBits(this.outlierMinimumNeighboorhoodPct) != Double.doubleToLongBits(other.outlierMinimumNeighboorhoodPct)) {
            return false;
        }
        if (this.shouldRemoveOutliers != other.shouldRemoveOutliers) {
            return false;
        }
        if (this.splitByWindGauges != other.splitByWindGauges) {
            return false;
        }
        if (this.useOnlyEstimationForWindDirection != other.useOnlyEstimationForWindDirection) {
            return false;
        }
        if (this.useOnlyWindGaugesForWindSpeed != other.useOnlyWindGaugesForWindSpeed) {
            return false;
        }
        return !(this.windStepping == null ? other.windStepping != null : !this.windStepping.equals(other.windStepping));
    }

    @Override
    public double getPctOfLeadingCompetitorsToInclude() {
        return this.pctOfLeadingCompetitorsToInclude;
    }
}

