/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.confidence.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.confidence.Weigher;
import com.sap.sse.common.Distance;

public class HyperbolicDistanceWeigher
implements Weigher<Position> {
    private static final long serialVersionUID = 5521299690322077224L;
    private final Distance halfConfidence;

    public HyperbolicDistanceWeigher(Distance halfConfidence) {
        this.halfConfidence = halfConfidence;
    }

    @Override
    public double getConfidence(Position fix, Position request) {
        double c;
        double x = fix.getQuickApproximateNauticalMileDistance(request);
        double y = c = this.halfConfidence.getNauticalMiles();
        return c / (x + y);
    }
}

