/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common;

import java.util.ArrayList;

public enum CourseDesignerMode {
    UNKNOWN("Unknown", false),
    BY_NAME("By-Name Course Designer", false),
    BY_MAP("By-Map Course Designer", true),
    BY_MARKS("By-Marks Course Designer", true),
    ADMIN_CONSOLE("Administration Console", true);

    private final String displayName;
    private final boolean waypointSequenceValid;

    private CourseDesignerMode(String displayName, boolean waypointSequenceValid) {
        this.displayName = displayName;
        this.waypointSequenceValid = waypointSequenceValid;
    }

    public String toString() {
        return this.displayName;
    }

    public boolean isWaypointSequenceValid() {
        return this.waypointSequenceValid;
    }

    public static CourseDesignerMode[] validValues() {
        ArrayList<CourseDesignerMode> validValues = new ArrayList<CourseDesignerMode>();
        CourseDesignerMode[] courseDesignerModeArray = CourseDesignerMode.values();
        int n = courseDesignerModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CourseDesignerMode type = courseDesignerModeArray[n2];
            if (type != UNKNOWN && type != ADMIN_CONSOLE) {
                validValues.add(type);
            }
            ++n2;
        }
        return validValues.toArray(new CourseDesignerMode[0]);
    }
}

