/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common;

import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.domain.common.impl.NauticalMileDistance;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.SecondsDurationImpl;

public abstract class AbstractSpeedImpl
implements Speed {
    private static final long serialVersionUID = 4910662213901175982L;

    public double getBeaufort() {
        return Math.exp(Math.log(this.getMetersPerSecond() / 0.836) * 2.0 / 3.0);
    }

    public Distance travel(TimePoint t1, TimePoint t2) {
        return this.travel(t1.until(t2));
    }

    public Distance travel(Duration duration) {
        return new NauticalMileDistance(duration.asHours() * this.getKnots());
    }

    public Duration getDuration(Distance distance) {
        return distance == null ? null : new SecondsDurationImpl(distance.getMeters() / this.getMetersPerSecond());
    }

    public double getMetersPerSecond() {
        return this.getKnots() * 1852.0 / 3600.0;
    }

    public double getKilometersPerHour() {
        return this.getKnots() * 1852.0 / 1000.0;
    }

    public double getStatuteMilesPerHour() {
        return this.getMetersPerSecond() * 2.2369;
    }

    public int compareTo(Speed speed) {
        double metersPerSecond = this.getMetersPerSecond();
        double otherMetersPerSecond = speed.getMetersPerSecond();
        return Double.compare(metersPerSecond, otherMetersPerSecond);
    }

    public String toString() {
        return this.getKnots() + "kn";
    }

    public int hashCode() {
        return 31 * (int)this.getMetersPerSecond();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Speed)) {
            return false;
        }
        return this.getMetersPerSecond() == ((Speed)object).getMetersPerSecond();
    }

    public double getKnots() {
        return this.getKilometersPerHour() * 1000.0 / 1852.0;
    }

    public double divide(Speed speed) {
        return this.getKnots() / speed.getKnots();
    }

    public Speed scale(double d) {
        return new KnotSpeedImpl(this.getKnots() * d);
    }
}

