/*
 * Decompiled with CFR 0.152.
 */
package org.moxieapps.gwt.highcharts.client;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Document;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;
import org.moxieapps.gwt.highcharts.client.Animation;
import org.moxieapps.gwt.highcharts.client.AxisTitle;
import org.moxieapps.gwt.highcharts.client.BaseChart;
import org.moxieapps.gwt.highcharts.client.Configurable;
import org.moxieapps.gwt.highcharts.client.DateTimeLabelFormats;
import org.moxieapps.gwt.highcharts.client.Extremes;
import org.moxieapps.gwt.highcharts.client.PlotBand;
import org.moxieapps.gwt.highcharts.client.PlotLine;
import org.moxieapps.gwt.highcharts.client.events.AxisSetExtremesEventHandler;

public abstract class Axis<T extends Axis>
extends Configurable<T> {
    private BaseChart chart;
    private String id;
    private AxisSetExtremesEventHandler axisSetExtremesEventHandler;
    private Number max;
    private Number min;

    Axis(BaseChart chart) {
        this.chart = chart;
        this.id = Document.get().createUniqueId();
        this.setOption("id", this.id);
    }

    public T setAxisSetExtremesEventHandler(AxisSetExtremesEventHandler axisSetExtremesEventHandler) {
        this.axisSetExtremesEventHandler = axisSetExtremesEventHandler;
        return this.getThis();
    }

    public AxisSetExtremesEventHandler getAxisSetExtremesEventHandler() {
        return this.axisSetExtremesEventHandler;
    }

    public PlotLine createPlotLine() {
        return new PlotLine(this);
    }

    public PlotBand createPlotBand() {
        return new PlotBand(this);
    }

    public T setAllowDecimals(boolean allowDecimals) {
        this.setOption("allowDecimals", allowDecimals);
        return this.update(this);
    }

    public T setAlternateGridColor(String alternateGridColor) {
        this.setOption("alternateGridColor", alternateGridColor);
        return this.update(this);
    }

    public T setDateTimeLabelFormats(DateTimeLabelFormats dateTimeLabelFormats) {
        this.setOption("dateTimeLabelFormats", dateTimeLabelFormats != null ? dateTimeLabelFormats.getOptions() : null);
        return this.update(this);
    }

    public T setEndOnTick(boolean endOnTick) {
        this.setOption("endOnTick", endOnTick);
        return this.update(this);
    }

    public T setExtremes(Number min, Number max) {
        return this.setExtremes(min, max, true, true);
    }

    public T setExtremes(Number min, Number max, boolean redraw, boolean animation) {
        return this.setExtremes(min, max, redraw, animation ? new Animation() : null);
    }

    public T setExtremes(Number min, Number max, boolean redraw, Animation animation) {
        if (this.chart.isRendered()) {
            JavaScriptObject nativeAxis = this.getNativeAxis();
            if (nativeAxis != null) {
                if (animation == null || animation.getOptions() == null) {
                    boolean animationFlag = animation != null;
                    Axis.nativeSetExtremes(nativeAxis, min.doubleValue(), max.doubleValue(), redraw, animationFlag);
                } else {
                    JavaScriptObject animationOptions = animation.getOptions().getJavaScriptObject();
                    Axis.nativeSetExtremes(nativeAxis, min.doubleValue(), max.doubleValue(), redraw, animationOptions);
                }
            }
        } else {
            ((Axis)this.setMin(min)).setMax(max);
        }
        return this.getThis();
    }

    public Extremes getExtremes() {
        JavaScriptObject nativeExtremes;
        JavaScriptObject nativeAxis;
        Extremes extremes = null;
        if (this.chart.isRendered() && (nativeAxis = this.getNativeAxis()) != null && (nativeExtremes = Axis.nativeGetExtremes(nativeAxis)) != null) {
            JSONObject jsonExtremes = new JSONObject(nativeExtremes);
            extremes = new Extremes(this.getNumberFromJSONObject(jsonExtremes, "dataMin"), this.getNumberFromJSONObject(jsonExtremes, "dataMax"), this.getNumberFromJSONObject(jsonExtremes, "min"), this.getNumberFromJSONObject(jsonExtremes, "max"));
        }
        if (extremes == null) {
            extremes = new Extremes(null, null, this.min, this.max);
        }
        return extremes;
    }

    public JavaScriptObject getNativeAxis() {
        if (this.chart != null) {
            return this.chart.get(this.id);
        }
        return null;
    }

    String getId() {
        return this.id;
    }

    private Number getNumberFromJSONObject(JSONObject jsonObject, String key) {
        JSONValue jsonValue = jsonObject.get(key);
        if (jsonValue != null && jsonValue.isNumber() != null) {
            return jsonValue.isNumber().doubleValue();
        }
        return null;
    }

    public T setGridLineColor(String gridLineColor) {
        this.setOption("gridLineColor", gridLineColor);
        return this.update(this);
    }

    public T setGridLineDashStyle(PlotLine.DashStyle gridLineDashStyle) {
        this.setOption("gridLineDashStyle", gridLineDashStyle != null ? gridLineDashStyle.toString() : null);
        return this.update(this);
    }

    public T setGridLineWidth(Number gridLineWidth) {
        this.setOption("gridLineWidth", gridLineWidth);
        return this.update(this);
    }

    public T setLineColor(String lineColor) {
        this.setOption("lineColor", lineColor);
        return this.update(this);
    }

    public T setLineWidth(Number lineWidth) {
        this.setOption("lineWidth", lineWidth);
        return this.update(this);
    }

    public T setLinkedTo(Number linkedTo) {
        this.setOption("linkedTo", linkedTo);
        return this.update(this);
    }

    public T setMax(Number max) {
        this.max = max;
        this.setOption("max", max);
        return this.update(this);
    }

    public T setMaxPadding(Number maxPadding) {
        this.setOption("maxPadding", maxPadding);
        return this.update(this);
    }

    public T setMaxZoom(Number maxZoom) {
        this.setOption("maxZoom", maxZoom);
        return this.update(this);
    }

    public T setMin(Number min) {
        this.min = min;
        this.setOption("min", min);
        return this.update(this);
    }

    public T setMinorGridLineColor(String minorGridLineColor) {
        this.setOption("minorGridLineColor", minorGridLineColor);
        return this.update(this);
    }

    public T setMinorGridLineDashStyle(PlotLine.DashStyle minorGridLineDashStyle) {
        this.setOption("minorGridLineDashStyle", minorGridLineDashStyle != null ? minorGridLineDashStyle.toString() : null);
        return this.update(this);
    }

    public T setMinorGridLineWidth(Number minorGridLineWidth) {
        this.setOption("minorGridLineWidth", minorGridLineWidth);
        return this.update(this);
    }

    public T setMinorTickColor(String minorTickColor) {
        this.setOption("minorTickColor", minorTickColor);
        return this.update(this);
    }

    public T setMinorTickInterval(Number minorTickInterval) {
        this.setOption("minorTickInterval", minorTickInterval);
        return this.update(this);
    }

    public T setMinorTickIntervalAuto() {
        this.setOption("minorTickInterval", "auto");
        return this.update(this);
    }

    public T setMinorTickLength(Number minorTickLength) {
        this.setOption("minorTickLength", minorTickLength);
        return this.update(this);
    }

    public T setMinorTickPosition(TickPosition minorTickPosition) {
        this.setOption("minorTickPosition", minorTickPosition != null ? minorTickPosition.toString() : null);
        return this.update(this);
    }

    public T setMinorTickWidth(Number minorTickWidth) {
        this.setOption("minorTickWidth", minorTickWidth);
        return this.update(this);
    }

    public T setMinPadding(Number minPadding) {
        this.setOption("minPadding", minPadding);
        return this.update(this);
    }

    public T setOffset(Number offset) {
        this.setOption("offset", offset);
        return this.update(this);
    }

    public T setOpposite(boolean opposite) {
        this.setOption("opposite", opposite);
        return this.update(this);
    }

    public T setPlotLines(PlotLine ... plotLines) {
        this.setOption("plotLines", plotLines);
        return this.update(this);
    }

    public T setPlotBands(PlotBand ... plotBands) {
        this.setOption("plotBands", plotBands);
        return this.update(this);
    }

    public T setReversed(boolean reversed) {
        this.setOption("reversed", reversed);
        return this.update(this);
    }

    public T setShowEmpty(boolean showEmpty) {
        this.setOption("showEmpty", showEmpty);
        return this.update(this);
    }

    public T setShowFirstLabel(boolean showFirstLabel) {
        this.setOption("showFirstLabel", showFirstLabel);
        return this.update(this);
    }

    public T setShowLastLabel(boolean showLastLabel) {
        this.setOption("showLastLabel", showLastLabel);
        return this.update(this);
    }

    public T setStartOfWeek(WeekDay startOfWeek) {
        this.setOption("startOfWeek", startOfWeek != null ? (Number)startOfWeek.toNumber() : (Number)null);
        return this.update(this);
    }

    public T setStartOnTick(boolean startOnTick) {
        this.setOption("startOnTick", startOnTick);
        return this.update(this);
    }

    public T setTickColor(String tickColor) {
        this.setOption("tickColor", tickColor);
        return this.update(this);
    }

    public T setTickInterval(Number tickInterval) {
        this.setOption("tickInterval", tickInterval);
        return this.update(this);
    }

    public T setTickLength(Number tickLength) {
        this.setOption("tickLength", tickLength);
        return this.update(this);
    }

    public T setTickPixelInterval(Number tickPixelInterval) {
        this.setOption("tickPixelInterval", tickPixelInterval);
        return this.update(this);
    }

    public T setTickPosition(TickPosition tickPosition) {
        this.setOption("tickPosition", tickPosition != null ? tickPosition.toString() : null);
        return this.update(this);
    }

    public T setTickWidth(Number tickWidth) {
        this.setOption("tickWidth", tickWidth);
        return this.update(this);
    }

    public T setAxisTitleText(String title) {
        this.setAxisTitleText(title, true);
        return this.update(this);
    }

    public T setAxisTitleText(String title, boolean redraw) {
        if (this.getNativeAxis() != null) {
            this.setAxisTitle(new AxisTitle().setText(title), redraw);
        } else {
            this.setOption("/title/text", title);
        }
        return this.getThis();
    }

    public T setAxisTitle(AxisTitle title) {
        return this.setAxisTitle(title, true);
    }

    public T setAxisTitle(AxisTitle title, boolean redraw) {
        this.setOption("/title", title != null ? title.getOptions() : null);
        return this.update(this);
    }

    public T setType(Type type) {
        this.setOption("type", type != null ? type.toString() : null);
        return this.update(this);
    }

    public T addPlotLines(PlotLine ... plotLines) {
        if (this.getNativeAxis() != null) {
            PlotLine[] plotLineArray = plotLines;
            int n = plotLines.length;
            int n2 = 0;
            while (n2 < n) {
                PlotLine plotLine = plotLineArray[n2];
                this.nativeAddPlotLine(this.getNativeAxis(), plotLine.getOptions().getJavaScriptObject());
                ++n2;
            }
        } else {
            this.setPlotLines(plotLines);
        }
        return this.getThis();
    }

    public T addPlotBands(PlotBand ... plotBands) {
        this.setPlotBands(plotBands);
        return this.getThis();
    }

    public T removePlotLine(PlotLine plotLine) {
        if (this.getNativeAxis() != null) {
            this.nativeRemovePlotLine(this.getNativeAxis(), plotLine.getId());
        }
        return this.getThis();
    }

    public T removePlotBand(PlotBand plotBand) {
        if (this.getNativeAxis() != null) {
            this.nativeRemovePlotBand(this.getNativeAxis(), plotBand.getId());
        }
        return this.getThis();
    }

    public T update(Axis axisOptions) {
        return this.update(axisOptions, false);
    }

    public T update(Axis axisOptions, boolean redraw) {
        JavaScriptObject nativeAxis = this.getNativeAxis();
        if (nativeAxis != null) {
            this.nativeUpdateAxis(nativeAxis, this.convertAxisToJavaScriptObject(axisOptions), redraw);
        }
        return this.getThis();
    }

    private JavaScriptObject convertAxisToJavaScriptObject(Axis axis) {
        JSONObject options = axis.getOptions() != null ? axis.getOptions() : new JSONObject();
        return options.getJavaScriptObject();
    }

    private T getThis() {
        Axis instance = this;
        return (T)instance;
    }

    private static native void nativeSetExtremes(JavaScriptObject var0, double var1, double var3, boolean var5, boolean var6);

    private static native void nativeSetExtremes(JavaScriptObject var0, double var1, double var3, boolean var5, JavaScriptObject var6);

    private static native JavaScriptObject nativeGetExtremes(JavaScriptObject var0);

    private native void nativeAddPlotLine(JavaScriptObject var1, JavaScriptObject var2);

    private native void nativeAddPlotBand(JavaScriptObject var1, JavaScriptObject var2);

    private native void nativeRemovePlotLine(JavaScriptObject var1, String var2);

    private native void nativeRemovePlotBand(JavaScriptObject var1, String var2);

    private native void nativeUpdateAxis(JavaScriptObject var1, JavaScriptObject var2, boolean var3);

    public static enum TickPosition {
        INSIDE("inside"),
        OUTSIDE("outside");

        private final String optionvalue;

        private TickPosition(String optionValue) {
            this.optionvalue = optionValue;
        }

        public String toString() {
            return this.optionvalue;
        }
    }

    public static enum Type {
        CATEGORY("category"),
        LINEAR("linear"),
        LOGARITHMIC("logarithmic"),
        DATE_TIME("datetime");

        private final String optionValue;

        private Type(String optionValue) {
            this.optionValue = optionValue;
        }

        public String toString() {
            return this.optionValue;
        }
    }

    public static enum WeekDay {
        SUNDAY(0),
        MONDAY(1),
        TUESDAY(2),
        WEDNESDAY(3),
        THURSDAY(4),
        FRIDAY(5),
        SATURDAY(6);

        private final Number optionvalue;

        private WeekDay(Number optionValue) {
            this.optionvalue = optionValue;
        }

        public Number toNumber() {
            return this.optionvalue;
        }
    }
}

