/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.windimport.nmea;

import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.impl.WindSourceWithAdditionalID;
import com.sap.sailing.nmeaconnector.NmeaFactory;
import com.sap.sailing.server.gateway.windimport.AbstractWindImporter;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class NmeaWindImporter
extends AbstractWindImporter {
    private static final Logger logger = Logger.getLogger(NmeaWindImporter.class.getName());

    @Override
    protected WindSource getDefaultWindSource(AbstractWindImporter.UploadRequest uploadRequest) {
        logger.info("Importing NMEA wind data from " + uploadRequest.files);
        String sourceName = uploadRequest.files != null && !uploadRequest.files.isEmpty() ? uploadRequest.files.toString() : "NMEA Wind Import";
        WindSourceWithAdditionalID windSource = new WindSourceWithAdditionalID(WindSourceType.WEB, String.valueOf(sourceName) + "@" + MillisecondsTimePoint.now());
        return windSource;
    }

    @Override
    protected Map<WindSource, Iterable<Wind>> importWind(WindSource defaultWindSource, Map<InputStream, Util.Pair<String, Charset>> inputStreamsAndFilenamesAndCharsets) throws IOException, InterruptedException {
        Iterable<Object> windFixes;
        if (inputStreamsAndFilenamesAndCharsets != null && inputStreamsAndFilenamesAndCharsets.size() == 1) {
            Util.Pair<String, Charset> filenameAndCharset = inputStreamsAndFilenamesAndCharsets.values().iterator().next();
            logger.info("Reading NMEA wind data from " + filenameAndCharset);
            windFixes = this.readWind((String)filenameAndCharset.getA(), inputStreamsAndFilenamesAndCharsets.keySet().iterator().next(), (Charset)filenameAndCharset.getB());
        } else {
            LinkedList windList = new LinkedList();
            for (Map.Entry<InputStream, Util.Pair<String, Charset>> inputStreamAndFileName : inputStreamsAndFilenamesAndCharsets.entrySet()) {
                logger.info("Reading NMEA wind data from " + inputStreamAndFileName.getValue());
                Util.addAll(this.readWind((String)inputStreamAndFileName.getValue().getA(), inputStreamAndFileName.getKey(), (Charset)inputStreamAndFileName.getValue().getB()), windList);
            }
            windFixes = windList;
        }
        HashMap<WindSource, Iterable<Wind>> result = new HashMap<WindSource, Iterable<Wind>>();
        result.put(defaultWindSource, windFixes);
        return result;
    }

    private Iterable<Wind> readWind(String filename, InputStream inputStream, Charset charset) throws InterruptedException, IOException {
        LinkedList result;
        if (filename.toLowerCase().endsWith("zip")) {
            ZipEntry entry;
            logger.info("NMEA file " + filename + " is a ZIP file");
            LinkedList windList = new LinkedList();
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            while ((entry = zipInputStream.getNextEntry()) != null) {
                if (!entry.getName().toLowerCase().endsWith(".txt")) continue;
                logger.info("Reading NMEA wind data from " + filename + "'s ZIP entry " + entry.getName());
                Util.addAll((Iterable)NmeaFactory.INSTANCE.readWind((InputStream)zipInputStream), windList);
            }
            result = windList;
        } else {
            result = NmeaFactory.INSTANCE.readWind(inputStream);
        }
        return result;
    }
}

