/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.trackfiles.impl;

import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifier;
import com.sap.sailing.domain.trackimport.GPSFixImporter;
import com.sap.sailing.server.gateway.trackfiles.impl.ImportResult;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.common.NoCorrespondingServiceRegisteredException;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Timed;
import com.sap.sse.common.TransformationException;
import com.sap.sse.common.TypeBasedServiceFinderFactory;
import com.sap.sse.common.Util;
import com.sap.sse.util.FileItemHelper;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.fileupload.FileItem;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class TrackFilesImporter {
    private static final Logger logger = Logger.getLogger(TrackFilesImporter.class.getName());
    private final RacingEventService service;
    private final TypeBasedServiceFinderFactory serviceFinderFactory;
    private final BundleContext context;

    public TrackFilesImporter(RacingEventService service, TypeBasedServiceFinderFactory serviceFinderFactory, BundleContext context) {
        this.service = service;
        this.serviceFinderFactory = serviceFinderFactory;
        this.context = context;
    }

    public void importFixes(ImportResult jsonResult, String prefImporterType, List<Util.Pair<String, FileItem>> files) throws IOException {
        GPSFixImporter preferredImporter = null;
        if (prefImporterType != null && !prefImporterType.isEmpty()) {
            preferredImporter = (GPSFixImporter)this.serviceFinderFactory.createServiceFinder(GPSFixImporter.class).findService(prefImporterType);
        }
        this.importFilesWithPreferredImporter(files, jsonResult, preferredImporter);
    }

    void importFilesWithPreferredImporter(Iterable<Util.Pair<String, FileItem>> files, ImportResult jsonResult, GPSFixImporter preferredImporter) throws IOException {
        for (Util.Pair<String, FileItem> pair : files) {
            String fileName = (String)pair.getA();
            FileItem fileItem = (FileItem)pair.getB();
            String fileExt = null;
            if (fileName.contains(".")) {
                fileExt = fileName.substring(fileName.lastIndexOf(".") + 1);
            }
            LinkedHashSet<GPSFixImporter> importersToTry = new LinkedHashSet<GPSFixImporter>();
            if (preferredImporter != null) {
                importersToTry.add(preferredImporter);
            }
            importersToTry.addAll(this.getGPSFixImporters(fileExt));
            importersToTry.addAll(this.getGPSFixImporters(null));
            logger.log(Level.INFO, "System knows " + importersToTry.size() + " importers: " + importersToTry.stream().map(i -> i.getType()).collect(Collectors.joining(", ")));
            AtomicBoolean succeeded = new AtomicBoolean(false);
            for (GPSFixImporter importer : importersToTry) {
                HashSet deviceIds;
                block18: {
                    deviceIds = new HashSet();
                    logger.log(Level.INFO, "Trying to import file " + fileName + " with importer " + importer.getType());
                    Throwable throwable = null;
                    Iterator iterator = null;
                    try (BufferedInputStream in = new BufferedInputStream(fileItem.getInputStream());){
                        try {
                            boolean ok = importer.importFixes((InputStream)in, FileItemHelper.getCharset((FileItem)fileItem), new GPSFixImporter.Callback(){

                                public void addFix(GPSFix fix, TrackFileImportDeviceIdentifier device) {
                                    TrackFilesImporter.this.storeFix(fix, (DeviceIdentifier)device);
                                    deviceIds.add(device);
                                }

                                public void addFixes(Iterable<GPSFix> fixes, TrackFileImportDeviceIdentifier device) {
                                    TrackFilesImporter.this.storeFixes(fixes, (DeviceIdentifier)device);
                                    deviceIds.add(device);
                                }
                            }, true, fileName);
                            if (ok) {
                                succeeded.set(ok);
                                break block18;
                            }
                            logger.log(Level.FINE, "Importer " + importer.getType() + " did not succesfully import fixes");
                        }
                        catch (Exception e) {
                            logger.log(Level.INFO, "Failed with " + e.getClass().getSimpleName() + " while importing file using " + importer.getType());
                            if (importer == preferredImporter) {
                                jsonResult.add(importer.getClass().getName(), fileName, e);
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                for (TrackFileImportDeviceIdentifier device : deviceIds) {
                    this.additionalDataExtractor(jsonResult, device);
                }
                if (!succeeded.get()) continue;
                logger.log(Level.INFO, "Successfully imported file " + fileName + " using " + importer.getType());
                break;
            }
            if (succeeded.get()) continue;
            jsonResult.noImporterSucceeded(fileName);
        }
    }

    protected void additionalDataExtractor(ImportResult jsonResult, TrackFileImportDeviceIdentifier device) throws TransformationException {
        TimeRange range = this.service.getSensorFixStore().getTimeRangeCoveredByFixes((DeviceIdentifier)device);
        long amount = this.service.getSensorFixStore().getNumberOfFixes((DeviceIdentifier)device);
        jsonResult.addTrackData(new ImportResult.TrackImportDTO(device.getId(), range, amount));
    }

    void storeFix(GPSFix fix, DeviceIdentifier deviceIdentifier) {
        try {
            this.service.getSensorFixStore().storeFix(deviceIdentifier, (Timed)fix);
        }
        catch (NoCorrespondingServiceRegisteredException e) {
            logger.log(Level.WARNING, "Could not store fix for " + deviceIdentifier);
        }
    }

    <FixT extends Timed> void storeFixes(Iterable<FixT> fixes, DeviceIdentifier deviceIdentifier) {
        try {
            this.service.getSensorFixStore().storeFixes(deviceIdentifier, fixes, false, false);
        }
        catch (NoCorrespondingServiceRegisteredException e) {
            logger.log(Level.WARNING, "Could not store fix for " + deviceIdentifier);
        }
    }

    Collection<GPSFixImporter> getGPSFixImporters(String fileExtension) {
        ArrayList<GPSFixImporter> result = new ArrayList<GPSFixImporter>();
        try {
            Filter filter = null;
            if (fileExtension != null) {
                filter = this.context.createFilter(String.format("(%s=%s)", "fileExt", fileExtension));
            }
            Collection refs = this.context.getServiceReferences(GPSFixImporter.class, filter == null ? null : filter.toString());
            for (ServiceReference ref : refs) {
                result.add((GPSFixImporter)this.context.getService(ref));
            }
        }
        catch (InvalidSyntaxException e) {
            logger.log(Level.WARNING, "Could not create OSGi filter for file extension");
        }
        return result;
    }
}

