/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.jaxrs.api;

import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.RegattaNameAndRaceName;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.impl.WindSourceWithAdditionalID;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.DynamicTrackedRegatta;
import com.sap.sailing.server.gateway.deserialization.impl.Helpers;
import com.sap.sailing.server.gateway.deserialization.impl.PositionJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.WindJsonDeserializer;
import com.sap.sailing.shared.server.gateway.jaxrs.AbstractSailingServerResource;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import java.util.ArrayList;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

@Path(value="/v1/wind")
public class WindResource
extends AbstractSailingServerResource {
    private final JsonDeserializer<Wind> deserializer = new WindJsonDeserializer((JsonDeserializer)new PositionJsonDeserializer());
    private static final String REGATTA_NAME_FIELD = "regattaName";
    private static final String RACE_NAME_FIELD = "raceName";

    @PUT
    @Consumes(value={"application/json"})
    @Path(value="putWind")
    public Response putWind(String json) throws ParseException, JsonDeserializationException {
        Object requestBody = JSONValue.parseWithException((String)json);
        JSONObject requestObject = Helpers.toJSONObjectSafe((Object)requestBody);
        JSONArray windDatas = (JSONArray)requestObject.get((Object)"windData");
        JSONArray regattaNamesAndRaceNames = (JSONArray)requestObject.get((Object)"regattaNamesAndRaceNames");
        WindSourceType windSourceType = WindSourceType.valueOf((String)((String)requestObject.get((Object)"windSourceType")));
        JSONArray answer = new JSONArray();
        String windSourceId = (String)requestObject.get((Object)"windSourceId");
        for (RaceIdentifierAndTrackedRace raceIdentifierAndTrackedRace : this.getRaces(regattaNamesAndRaceNames)) {
            JSONObject answerForRace = new JSONObject();
            answerForRace.put((Object)"regattaNameAndRaceName", (Object)this.serialize(raceIdentifierAndTrackedRace.getRaceIdentifier()));
            if (windSourceType == WindSourceType.EXPEDITION || windSourceType == WindSourceType.WEB) {
                DynamicTrackedRace trackedRace = raceIdentifierAndTrackedRace.getTrackedRace();
                WindSourceWithAdditionalID windsource = new WindSourceWithAdditionalID(windSourceType, windSourceId);
                if (trackedRace != null) {
                    JSONArray subAnswer = new JSONArray();
                    int i = 0;
                    while (i < windDatas.size()) {
                        JSONObject windData = Helpers.toJSONObjectSafe((Object)windDatas.get(i));
                        Wind data = (Wind)this.deserializer.deserialize(windData);
                        boolean success = trackedRace.recordWind(data, (WindSource)windsource);
                        subAnswer.add(i, (Object)success);
                        ++i;
                    }
                    answerForRace.put((Object)"answer", (Object)subAnswer);
                } else {
                    answerForRace.put((Object)"answer", (Object)"Could not resolve traced race");
                }
            } else {
                answerForRace.put((Object)"answer", (Object)"Only Windsourcetypes expedition or web are allowed");
            }
            answer.add((Object)answerForRace);
        }
        return Response.ok((Object)this.streamingOutput(answer)).build();
    }

    private JSONObject serialize(RegattaAndRaceIdentifier raceIdentifier) {
        JSONObject result = new JSONObject();
        result.put((Object)REGATTA_NAME_FIELD, (Object)raceIdentifier.getRegattaName());
        result.put((Object)RACE_NAME_FIELD, (Object)raceIdentifier.getRaceName());
        return result;
    }

    private Iterable<RaceIdentifierAndTrackedRace> getRaces(JSONArray regattaNamesAndRaceNames) throws JsonDeserializationException {
        ArrayList<RaceIdentifierAndTrackedRace> result = new ArrayList<RaceIdentifierAndTrackedRace>();
        if (regattaNamesAndRaceNames != null) {
            for (Object regattaNameAndRaceName : regattaNamesAndRaceNames) {
                DynamicTrackedRace trackedRace;
                JSONObject regattaNameAndRaceNameObject = Helpers.toJSONObjectSafe(regattaNameAndRaceName);
                String regattaName = (String)regattaNameAndRaceNameObject.get((Object)REGATTA_NAME_FIELD);
                String raceName = (String)regattaNameAndRaceNameObject.get((Object)RACE_NAME_FIELD);
                RegattaNameAndRaceName identifier = new RegattaNameAndRaceName(regattaName, raceName);
                if (!this.getSecurityService().hasCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)identifier) || (trackedRace = this.getService().getTrackedRace((RegattaAndRaceIdentifier)identifier)) == null) continue;
                result.add(new RaceIdentifierAndTrackedRace((RegattaAndRaceIdentifier)identifier, trackedRace));
            }
        } else {
            for (Regatta regatta : this.getService().getAllRegattas()) {
                DynamicTrackedRegatta trackedRegatta = this.getService().getTrackedRegatta(regatta);
                if (trackedRegatta == null) continue;
                trackedRegatta.lockTrackedRacesForRead();
                try {
                    for (DynamicTrackedRace trackedRace : trackedRegatta.getTrackedRaces()) {
                        if (!this.getSecurityService().hasCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)trackedRace.getRaceIdentifier())) continue;
                        result.add(new RaceIdentifierAndTrackedRace(trackedRace.getRaceIdentifier(), trackedRace));
                    }
                }
                finally {
                    trackedRegatta.unlockTrackedRacesAfterRead();
                }
            }
        }
        return result;
    }

    private static class RaceIdentifierAndTrackedRace {
        private final RegattaAndRaceIdentifier raceIdentifier;
        private final DynamicTrackedRace trackedRace;

        public RaceIdentifierAndTrackedRace(RegattaAndRaceIdentifier raceIdentifier, DynamicTrackedRace trackedRace) {
            this.raceIdentifier = raceIdentifier;
            this.trackedRace = trackedRace;
        }

        public RegattaAndRaceIdentifier getRaceIdentifier() {
            return this.raceIdentifier;
        }

        public DynamicTrackedRace getTrackedRace() {
            return this.trackedRace;
        }
    }
}

