/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.util.impl;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class ThreadFactoryWithPriority
implements ThreadFactory {
    private ThreadFactory defaultFactory = Executors.defaultThreadFactory();
    private final int priority;
    private final Boolean daemon;
    private final String name;

    public ThreadFactoryWithPriority(int priority, Boolean daemon) {
        this(null, priority, daemon);
    }

    public ThreadFactoryWithPriority(String name, int priority, Boolean daemon) {
        this.name = name;
        this.priority = priority;
        this.daemon = daemon;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread result = this.defaultFactory.newThread(r);
        result.setPriority(this.priority);
        if (this.daemon != null) {
            result.setDaemon(this.daemon);
        }
        if (this.name != null) {
            result.setName(String.valueOf(this.name) + " " + result.getName());
        }
        return result;
    }
}

