/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.util;

import com.sap.sse.common.Duration;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.entity.ContentType;

public class HttpUrlConnectionHelper {
    private static final int HTTP_MAX_REDIRECTS = 5;

    public static URLConnection redirectConnection(URL url, Duration timeout, Consumer<URLConnection> preConnectionModifier) throws MalformedURLException, IOException {
        return HttpUrlConnectionHelper.redirectConnection(url, timeout, null, preConnectionModifier, null, Optional.empty());
    }

    public static URLConnection redirectConnectionWithBearerToken(URL url, String optionalBearerToken) throws MalformedURLException, IOException {
        return HttpUrlConnectionHelper.redirectConnectionWithBearerToken(url, Duration.ONE_MINUTE.times(10L), null, optionalBearerToken, null, Optional.empty());
    }

    public static URLConnection redirectConnectionWithBearerToken(URL url, String optionalRequestMethod, String optionalBearerToken) throws MalformedURLException, IOException {
        return HttpUrlConnectionHelper.redirectConnectionWithBearerToken(url, Duration.ONE_MINUTE.times(10L), optionalRequestMethod, optionalBearerToken, null, Optional.empty());
    }

    public static URLConnection redirectConnectionWithBearerToken(URL url, Duration timeout, String optionalRequestMethod, String optionalBearerToken, String optionalContentType, Consumer<URLConnection> preConnectionModifier, Consumer<URLConnection> postConnectModifier, Optional<OutputStreamConsumer> optionalOutputStreamConsumer) throws MalformedURLException, IOException {
        return HttpUrlConnectionHelper.redirectConnection(url, timeout, optionalRequestMethod, t -> {
            if (optionalBearerToken != null && !optionalBearerToken.isEmpty()) {
                t.setRequestProperty("Authorization", "Bearer " + optionalBearerToken);
            }
            if (optionalContentType != null && !optionalContentType.isEmpty()) {
                t.setRequestProperty("Content-Type", optionalContentType);
            }
            if (preConnectionModifier != null) {
                preConnectionModifier.accept((URLConnection)t);
            }
        }, postConnectModifier, optionalOutputStreamConsumer);
    }

    public static URLConnection redirectConnectionWithBearerToken(URL url, Duration timeout, String optionalRequestMethod, String optionalBearerToken, String optionalContentType, Optional<OutputStreamConsumer> optionalOutputStreamConsumer) throws MalformedURLException, IOException {
        return HttpUrlConnectionHelper.redirectConnection(url, timeout, optionalRequestMethod, t -> {
            if (optionalBearerToken != null && !optionalBearerToken.isEmpty()) {
                t.setRequestProperty("Authorization", "Bearer " + optionalBearerToken);
            }
            if (optionalContentType != null && !optionalContentType.isEmpty()) {
                t.setRequestProperty("Content-Type", optionalContentType);
            }
        }, null, optionalOutputStreamConsumer);
    }

    public static URLConnection redirectConnectionWithBearerToken(URL url, Duration timeout, String optionalRequestMethod, String optionalBearerToken) throws MalformedURLException, IOException {
        return HttpUrlConnectionHelper.redirectConnectionWithBearerToken(url, timeout, optionalRequestMethod, optionalBearerToken, null, Optional.empty());
    }

    public static URLConnection redirectConnectionWithBearerToken(URL url, Duration timeout, String optionalBearerToken) throws MalformedURLException, IOException {
        return HttpUrlConnectionHelper.redirectConnectionWithBearerToken(url, timeout, null, optionalBearerToken, null, Optional.empty());
    }

    public static URLConnection redirectConnection(URL url, Duration timeout, String optionalRequestMethod, Consumer<URLConnection> preConnectionModifier, Consumer<URLConnection> postConnectModifier, Optional<OutputStreamConsumer> optionalOutputStreamConsumer) throws MalformedURLException, IOException {
        URLConnection urlConnection = null;
        URL nextUrl = url;
        int counterOfRedirects = 0;
        while (counterOfRedirects <= 5) {
            urlConnection = nextUrl.openConnection();
            urlConnection.setRequestProperty("User-Agent", "Mozilla/5.0...");
            if (preConnectionModifier != null) {
                preConnectionModifier.accept(urlConnection);
            }
            urlConnection.setDoOutput(true);
            if (optionalRequestMethod != null) {
                ((HttpURLConnection)urlConnection).setRequestMethod(optionalRequestMethod);
            }
            urlConnection.setReadTimeout((int)timeout.asMillis());
            if (postConnectModifier != null) {
                postConnectModifier.accept(urlConnection);
            }
            if (!(urlConnection instanceof HttpURLConnection)) break;
            HttpURLConnection connection = (HttpURLConnection)urlConnection;
            connection.setInstanceFollowRedirects(false);
            if (optionalRequestMethod != null && (optionalRequestMethod.equals("POST") || optionalRequestMethod.equals("PUT")) && optionalOutputStreamConsumer.isPresent()) {
                OutputStream outputStream = connection.getOutputStream();
                optionalOutputStreamConsumer.get().accept(outputStream);
            }
            if (connection.getResponseCode() != 301 && connection.getResponseCode() != 302) break;
            String location = connection.getHeaderField("Location");
            nextUrl = new URL(nextUrl, location);
            connection.disconnect();
            ++counterOfRedirects;
        }
        return urlConnection;
    }

    public static URLConnection redirectConnection(URL url) throws MalformedURLException, IOException {
        return HttpUrlConnectionHelper.redirectConnection(url, Duration.ONE_MINUTE.times(10L), null);
    }

    public static URLConnection redirectConnection(URL url, String optionalRequestMethod) throws MalformedURLException, IOException {
        return HttpUrlConnectionHelper.redirectConnection(url, Duration.ONE_MINUTE.times(10L), optionalRequestMethod, null, null, Optional.empty());
    }

    public static Charset getCharsetFromConnectionOrDefault(URLConnection connection, String defaultCharsetName) {
        Charset cs;
        try {
            String contentType = connection.getContentType();
            Charset charsetFromConnection = contentType == null ? null : ContentType.parse((String)contentType).getCharset();
            cs = charsetFromConnection == null ? Charset.forName(defaultCharsetName) : charsetFromConnection;
        }
        catch (UnsupportedCharsetException | ParseException e) {
            cs = Charset.forName(defaultCharsetName);
        }
        return cs;
    }

    public static Charset getCharsetFromHttpEntity(HttpEntity entity, String defaultCharsetName) {
        ContentType contentType = ContentType.getOrDefault((HttpEntity)entity);
        Charset charsetFromContentType = contentType.getCharset();
        return charsetFromContentType == null ? Charset.forName(defaultCharsetName) : charsetFromContentType;
    }

    @FunctionalInterface
    public static interface OutputStreamConsumer {
        public void accept(OutputStream var1) throws IOException;
    }
}

