/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.trackfiles.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.common.trackfiles.TrackFilesFormat;
import com.sap.sailing.domain.trackimport.FormatNotSupportedException;
import com.sap.sailing.domain.tracking.Maneuver;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.server.trackfiles.impl.AbstractDataRetriever;
import com.sap.sailing.server.trackfiles.impl.IterableLocker;
import com.sap.sailing.server.trackfiles.impl.ManeuverToGpxPosition;
import com.sap.sailing.server.trackfiles.impl.NameReader;
import com.sap.sailing.server.trackfiles.impl.NoIterableLocker;
import com.sap.sailing.server.trackfiles.impl.TrackReader;
import com.sap.sailing.server.trackfiles.impl.TrackReaderRetriever;
import com.sap.sse.common.TimePoint;
import java.io.IOException;
import java.util.Collection;
import slash.navigation.gpx.GpxRoute;

public class ManueverDataRetriever
extends AbstractDataRetriever {
    @Override
    public Collection<GpxRoute> getRoutes(TrackFilesFormat format, final TrackedRace race, boolean dataBeforeAfter, boolean rawFixes) throws FormatNotSupportedException, IOException {
        final TimePoint start = race.getStartOfRace() == null ? race.getStartOfTracking() : race.getStartOfRace();
        final TimePoint end = race.getEndOfRace() == null ? race.getEndOfTracking() : race.getEndOfRace();
        TrackReaderRetriever<Competitor, Maneuver> retriever = new TrackReaderRetriever<Competitor, Maneuver>(){

            @Override
            public TrackReader<Competitor, Maneuver> retrieveTrackReader(Competitor e) {
                return new TrackReader<Competitor, Maneuver>(){

                    @Override
                    public Iterable<Maneuver> getRawTrack(Competitor e) {
                        return race.getManeuvers(e, start, end, false);
                    }

                    @Override
                    public Iterable<Maneuver> getTrack(Competitor e) {
                        return race.getManeuvers(e, start, end, false);
                    }

                    @Override
                    public IterableLocker getLocker() {
                        return new NoIterableLocker();
                    }
                };
            }
        };
        return this.getRoutes(race, dataBeforeAfter, rawFixes, ManeuverToGpxPosition.INSTANCE, race.getRace().getCompetitors(), new NameReader<Competitor>(){

            @Override
            public String getName(Competitor s) {
                return s.getName();
            }
        }, retriever);
    }
}

