/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.grib.impl;

import com.sap.sailing.grib.impl.VariableSpecification;
import java.util.Arrays;
import java.util.Optional;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.VariableSimpleIF;

public class Grib2VariableSpecification
implements VariableSpecification {
    private final int[] disciplineCategoryNumberAndMoreOptionalSpecifiers;

    public Grib2VariableSpecification(int[] disciplineCategoryNumberAndMoreOptionalSpecifiers) {
        this.disciplineCategoryNumberAndMoreOptionalSpecifiers = disciplineCategoryNumberAndMoreOptionalSpecifiers;
    }

    @Override
    public boolean matches(VariableSimpleIF variable) {
        Optional<int[]> grib2ParameterInfo = Grib2VariableSpecification.getGrib2VariableId(variable);
        boolean result = grib2ParameterInfo.isPresent() && grib2ParameterInfo.get().length >= this.disciplineCategoryNumberAndMoreOptionalSpecifiers.length ? Arrays.equals(Arrays.copyOf(grib2ParameterInfo.get(), this.disciplineCategoryNumberAndMoreOptionalSpecifiers.length), this.disciplineCategoryNumberAndMoreOptionalSpecifiers) : false;
        return result;
    }

    private static Optional<int[]> getGrib2VariableId(VariableSimpleIF variable) {
        Optional<Object> result;
        Attribute idVariable = variable.findAttributeIgnoreCase("Grib2_Parameter");
        if (idVariable != null) {
            Array grib2ParameterDisciplineCategoryAndNumber = idVariable.getValues();
            if (grib2ParameterDisciplineCategoryAndNumber == null) {
                result = Optional.empty();
            } else {
                int[] resultArray = new int[(int)grib2ParameterDisciplineCategoryAndNumber.getSize()];
                int i = 0;
                while (i < resultArray.length) {
                    resultArray[i] = grib2ParameterDisciplineCategoryAndNumber.getInt(i);
                    ++i;
                }
                result = Optional.of(resultArray);
            }
        } else {
            result = Optional.empty();
        }
        return result;
    }

    public String toString() {
        return "Grib2VariableSpecification [disciplineCategoryNumberAndMoreOptionalSpecifiers=" + Arrays.toString(this.disciplineCategoryNumberAndMoreOptionalSpecifiers) + "]";
    }
}

