/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.polars.mining;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.SpeedWithBearingWithConfidence;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.Tack;
import com.sap.sailing.domain.common.polars.NotEnoughDataHasBeenAddedException;
import com.sap.sailing.domain.polars.PolarsChangedListener;
import com.sap.sailing.polars.mining.AngleAndSpeedRegression;
import com.sap.sailing.polars.mining.GPSFixMovingWithPolarContext;
import com.sap.sailing.polars.mining.LegTypePolarClusterKey;
import com.sap.sailing.polars.mining.PolarDataDimensionCollectionFactory;
import com.sap.sse.common.Speed;
import com.sap.sse.datamining.components.AdditionalResultDataBuilder;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.factories.GroupKeyFactory;
import com.sap.sse.datamining.impl.components.GroupedDataEntry;
import com.sap.sse.datamining.shared.GroupKey;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import org.apache.commons.math.analysis.polynomials.PolynomialFunction;

public class CubicRegressionPerCourseProcessor
implements Processor<GroupedDataEntry<GPSFixMovingWithPolarContext>, Void>,
Serializable {
    private static final long serialVersionUID = 3059764273262382648L;
    private static final Logger logger = Logger.getLogger(CubicRegressionPerCourseProcessor.class.getName());
    private final Map<GroupKey, AngleAndSpeedRegression> regressions = new HashMap<GroupKey, AngleAndSpeedRegression>();
    private transient ConcurrentMap<BoatClass, Set<PolarsChangedListener>> listeners;

    public boolean canProcessElements() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processElement(GroupedDataEntry<GPSFixMovingWithPolarContext> element) {
        GPSFixMovingWithPolarContext fix = (GPSFixMovingWithPolarContext)element.getDataEntry();
        if (fix.getLegType() == LegType.UPWIND || fix.getLegType() == LegType.DOWNWIND) {
            AngleAndSpeedRegression regression;
            GroupKey key = element.getKey();
            Map<GroupKey, AngleAndSpeedRegression> map = this.regressions;
            synchronized (map) {
                regression = this.regressions.get(key);
                if (regression == null) {
                    regression = new AngleAndSpeedRegression();
                    this.regressions.put(key, regression);
                }
            }
            regression.addData(fix.getWind(), fix.getAbsoluteAngleToTheWind(), fix.getBoatSpeed());
            Set listenersForBoatClass = (Set)this.listeners.get(fix.getBoatClass());
            if (listenersForBoatClass != null) {
                for (PolarsChangedListener listener : listenersForBoatClass) {
                    listener.polarsChanged();
                }
            }
        }
    }

    public SpeedWithBearingWithConfidence<Void> getAverageSpeedAndCourseOverGround(BoatClass boatClass, Speed windSpeed, LegType legType) throws NotEnoughDataHasBeenAddedException {
        GroupKey key = this.createGroupKey(boatClass, legType);
        SpeedWithBearingWithConfidence<Void> estimatedSpeedAndAngle = null;
        if (!this.regressions.containsKey(key)) {
            throw new NotEnoughDataHasBeenAddedException("Not enough data has been added to Per Course Regressions");
        }
        estimatedSpeedAndAngle = this.regressions.get(key).estimateSpeedAndAngle(windSpeed);
        return estimatedSpeedAndAngle;
    }

    public Set<SpeedWithBearingWithConfidence<Void>> estimateTrueWindSpeedAndAngleCandidates(BoatClass boatClass, Speed speedOverGround, LegType legType, Tack tack) {
        GroupKey key = this.createGroupKey(boatClass, legType);
        Set<SpeedWithBearingWithConfidence<Void>> result = new HashSet<SpeedWithBearingWithConfidence<Void>>();
        if (this.regressions.containsKey(key)) {
            try {
                result = this.regressions.get(key).estimateTrueWindSpeedAndAngleCandidates(speedOverGround, legType, tack);
            }
            catch (NotEnoughDataHasBeenAddedException notEnoughDataHasBeenAddedException) {
                // empty catch block
            }
        }
        return result;
    }

    private GroupKey createGroupKey(final BoatClass boatClass, final LegType legType) {
        GroupKey compoundKey;
        LegTypePolarClusterKey key = new LegTypePolarClusterKey(){

            @Override
            public BoatClass getBoatClass() {
                return boatClass;
            }

            @Override
            public LegType getLegType() {
                return legType;
            }
        };
        try {
            compoundKey = GroupKeyFactory.createNestingCompoundKeyFor((Object)key, PolarDataDimensionCollectionFactory.getCubicRegressionPerCourseClusterKeyDimensions());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return compoundKey;
    }

    public PolynomialFunction getSpeedRegressionFunction(BoatClass boatClass, LegType legType) throws NotEnoughDataHasBeenAddedException {
        GroupKey key = this.createGroupKey(boatClass, legType);
        if (!this.regressions.containsKey(key)) {
            throw new NotEnoughDataHasBeenAddedException();
        }
        PolynomialFunction polynomialFunction = this.regressions.get(key).getSpeedRegressionFunction();
        return polynomialFunction;
    }

    public PolynomialFunction getAngleRegressionFunction(BoatClass boatClass, LegType legType) throws NotEnoughDataHasBeenAddedException {
        GroupKey key = this.createGroupKey(boatClass, legType);
        if (!this.regressions.containsKey(key)) {
            throw new NotEnoughDataHasBeenAddedException();
        }
        PolynomialFunction polynomialFunction = this.regressions.get(key).getAngleRegressionFunction();
        return polynomialFunction;
    }

    public void onFailure(Throwable failure) {
        failure.printStackTrace();
        logger.severe("Polar Data Mining Pipe failed. Cause: " + failure.getMessage());
        throw new RuntimeException("Polar Data Miner failed.", failure);
    }

    public void setListeners(ConcurrentMap<BoatClass, Set<PolarsChangedListener>> listeners) {
        this.listeners = listeners;
    }

    public Class<GroupedDataEntry<GPSFixMovingWithPolarContext>> getInputType() {
        return null;
    }

    public Class<Void> getResultType() {
        return null;
    }

    public void finish() throws InterruptedException {
    }

    public boolean isFinished() {
        return false;
    }

    public void abort() {
    }

    public boolean isAborted() {
        return false;
    }

    public AdditionalResultDataBuilder getAdditionalResultData(AdditionalResultDataBuilder additionalDataBuilder) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<GroupKey, AngleAndSpeedRegression> getRegressions() {
        Map<GroupKey, AngleAndSpeedRegression> map = this.regressions;
        synchronized (map) {
            return Collections.unmodifiableMap(this.regressions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRegressions(Map<GroupKey, AngleAndSpeedRegression> regressionsToUpdate) {
        Map<GroupKey, AngleAndSpeedRegression> map = this.regressions;
        synchronized (map) {
            this.regressions.putAll(regressionsToUpdate);
        }
    }
}

