/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.settings;

import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONBoolean;
import com.google.gwt.json.client.JSONNull;
import com.google.gwt.json.client.JSONNumber;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import com.sap.sse.common.settings.serializer.AbstractSettingsToJsonSerializer;
import java.util.ArrayList;

public class SettingsToJsonSerializerGWT
extends AbstractSettingsToJsonSerializer<JSONObject, JSONArray> {
    public String jsonObjectToString(JSONObject jsonObject) {
        return jsonObject.toString();
    }

    public JSONObject parseStringToJsonObject(String jsonString) {
        JSONObject jsonObject;
        JSONValue jsonValue = JSONParser.parseStrict((String)jsonString);
        if (jsonValue != null && (jsonObject = jsonValue.isObject()) != null) {
            return jsonObject;
        }
        return null;
    }

    protected JSONObject newOBJECT() {
        return new JSONObject();
    }

    protected void set(JSONObject jsonObject, String property, Object value) {
        jsonObject.put(property, this.toJsonValue(value));
    }

    private JSONValue toJsonValue(Object value) {
        if (value == null) {
            return JSONNull.getInstance();
        }
        if (value instanceof JSONArray) {
            return (JSONArray)value;
        }
        if (value instanceof JSONObject) {
            return (JSONObject)value;
        }
        if (value instanceof String) {
            return new JSONString((String)value);
        }
        if (value instanceof Number) {
            return new JSONNumber(((Number)value).doubleValue());
        }
        if (value instanceof Boolean) {
            return JSONBoolean.getInstance((boolean)((Boolean)value));
        }
        throw new IllegalStateException("Non JSON-compatible value found!");
    }

    private Object fromJsonValue(JSONValue jsonValue) {
        if (jsonValue.isNull() != null) {
            return null;
        }
        if (jsonValue.isBoolean() != null) {
            return jsonValue.isBoolean().booleanValue();
        }
        if (jsonValue.isString() != null) {
            return jsonValue.isString().stringValue();
        }
        if (jsonValue.isNumber() != null) {
            return jsonValue.isNumber().doubleValue();
        }
        if (jsonValue.isObject() != null) {
            return jsonValue.isObject();
        }
        if (jsonValue.isArray() != null) {
            return jsonValue.isArray();
        }
        throw new IllegalStateException("Unexpected JSONValue found!");
    }

    protected Object get(JSONObject jsonObject, String property) {
        return this.fromJsonValue(jsonObject.get(property));
    }

    protected boolean hasProperty(JSONObject jsonObject, String property) {
        return jsonObject.containsKey(property);
    }

    protected JSONArray ToJsonArray(Iterable<Object> values) {
        JSONArray jsonArray = new JSONArray();
        for (Object value : values) {
            JSONValue jsonValue = this.toJsonValue(value);
            if (jsonValue == null) continue;
            jsonArray.set(jsonArray.size(), jsonValue);
        }
        return jsonArray;
    }

    protected Iterable<Object> fromJsonArray(JSONArray jsonArray) {
        ArrayList<Object> result = new ArrayList<Object>(jsonArray.size());
        int i = 0;
        while (i < jsonArray.size()) {
            result.add(this.fromJsonValue(jsonArray.get(i)));
            ++i;
        }
        return result;
    }

    public boolean isArray(Object jsonValue) {
        return jsonValue instanceof JSONArray;
    }
}

