/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.linker;

import com.google.gwt.core.ext.LinkerContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.linker.AbstractLinker;
import com.google.gwt.core.ext.linker.Artifact;
import com.google.gwt.core.ext.linker.ArtifactSet;
import com.google.gwt.core.ext.linker.EmittedArtifact;
import com.google.gwt.core.ext.linker.LinkerOrder;
import com.google.gwt.core.ext.linker.impl.SelectionInformation;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.io.IOUtils;

@LinkerOrder(value=LinkerOrder.Order.POST)
public abstract class ManifestLinker
extends AbstractLinker {
    private static final String MANIFEST = "appcache.manifest";
    private static final String MANIFESTTEMPLATE = "cache.manifest.template";

    public String getDescription() {
        return ManifestLinker.class.getName();
    }

    public ArtifactSet link(TreeLogger logger, LinkerContext context, ArtifactSet artifacts, boolean onePermutation) throws UnableToCompleteException {
        ArtifactSet result = new ArtifactSet((Collection)artifacts);
        if (onePermutation) {
            return result;
        }
        if (result.find(SelectionInformation.class).isEmpty()) {
            logger.log(TreeLogger.INFO, "Warning: Clobbering appcache.manifest to allow debugging. Recompile before deploying your app!");
            artifacts = null;
        } else {
            result.add(this.emitLandingPageCacheManifest(context, logger, artifacts));
        }
        return result;
    }

    private Artifact<?> emitLandingPageCacheManifest(LinkerContext context, TreeLogger logger, ArtifactSet artifacts) throws UnableToCompleteException {
        StringBuilder publicSourcesSb = new StringBuilder();
        StringBuilder staticResoucesSb = new StringBuilder();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                EmittedArtifact ea;
                String pathName;
                if (!(artifact instanceof EmittedArtifact) || (pathName = (ea = (EmittedArtifact)artifact).getPartialPath()).endsWith("symbolMap") || pathName.endsWith(".xml.gz") || pathName.endsWith("rpc.log") || pathName.endsWith("gwt.rpc") || pathName.endsWith("manifest.txt") || pathName.startsWith("rpcPolicyManifest")) continue;
                publicSourcesSb.append(String.valueOf(pathName) + "\n");
            }
            String[] cacheExtraFiles = this.getCacheExtraFiles();
            int i = 0;
            while (i < cacheExtraFiles.length) {
                staticResoucesSb.append(cacheExtraFiles[i]);
                staticResoucesSb.append("\n");
                ++i;
            }
        }
        String cacheManifestString = this.createCache(logger, context, publicSourcesSb, staticResoucesSb);
        return this.emitString(logger, cacheManifestString, MANIFEST);
    }

    protected String createCache(TreeLogger logger, LinkerContext context, StringBuilder publicSourcesSb, StringBuilder staticResoucesSb) throws UnableToCompleteException {
        try {
            String manifest = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(this.appCacheManifestTemplate()));
            manifest = manifest.replace("$UNIQUEID$", String.valueOf(new Date().getTime()) + "." + Math.random()).toString();
            manifest = manifest.replace("$STATICAPPFILES$", staticResoucesSb.toString());
            manifest = manifest.replace("$GENAPPFILES$", publicSourcesSb.toString());
            return manifest;
        }
        catch (IOException e) {
            throw new UnableToCompleteException();
        }
    }

    private String[] getCacheExtraFiles() {
        String[] cacheExtraFiles = this.staticCachedFiles();
        return cacheExtraFiles == null ? new String[]{} : Arrays.copyOf(cacheExtraFiles, cacheExtraFiles.length);
    }

    protected abstract String[] staticCachedFiles();

    protected String appCacheManifestTemplate() {
        return MANIFESTTEMPLATE;
    }
}

