/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.shared.components;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Composite;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractCompositeComponent<SettingsType extends Settings>
extends Composite
implements Component<SettingsType> {
    private Component<?> parentComponent;
    private ComponentContext<?> componentContext;
    private Set<VisibilityListener> visibilityListeners;

    public AbstractCompositeComponent(Component<?> parent, ComponentContext<?> componentContext) {
        this.componentContext = componentContext;
        this.visibilityListeners = new HashSet<VisibilityListener>();
        this.parentComponent = parent;
        if (this.parentComponent == null) {
            GWT.log((String)("No parent for component, validate if correct " + this.getClass().getName()));
        }
        if (componentContext == null) {
            GWT.log((String)("No context for component, validate if correct " + this.getClass().getName()));
        }
    }

    public void addVisibilityListener(VisibilityListener listener) {
        this.visibilityListeners.add(listener);
    }

    public void removeVisibilityListener(VisibilityListener listener) {
        this.visibilityListeners.remove(listener);
    }

    @Override
    public void setVisible(boolean visible) {
        boolean oldVisible = this.isVisible();
        super.setVisible(visible);
        if (oldVisible != visible) {
            this.notifyVisibilityListeners(visible);
        }
    }

    private void notifyVisibilityListeners(boolean visible) {
        for (VisibilityListener listener : this.visibilityListeners) {
            listener.visibilityChanged(visible);
        }
    }

    @Override
    public Component<?> getParentComponent() {
        return this.parentComponent;
    }

    @Override
    public ComponentContext<?> getComponentContext() {
        return this.componentContext;
    }

    public static interface VisibilityListener {
        public void visibilityChanged(boolean var1);
    }
}

