/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.player;

import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.player.TimeRangeModel;
import com.sap.sse.gwt.client.player.TimeRangeWithZoomProvider;
import com.sap.sse.gwt.client.player.TimeZoomChangeListener;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class TimeRangeWithZoomModel
extends TimeRangeModel
implements TimeRangeWithZoomProvider {
    private Date zoomStartTimepoint;
    private Date zoomEndTimepoint;
    private boolean isTimeZoomed = false;
    private final Set<TimeZoomChangeListener> listeners = new HashSet<TimeZoomChangeListener>();

    @Override
    public void addTimeZoomChangeListener(TimeZoomChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeTimeZoomChangeListener(TimeZoomChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setTimeZoom(Date zoomStartTimepoint, Date zoomEndTimepoint, TimeZoomChangeListener ... listenersNotToNotify) {
        this.zoomStartTimepoint = zoomStartTimepoint;
        this.zoomEndTimepoint = zoomEndTimepoint;
        this.isTimeZoomed = true;
        for (TimeZoomChangeListener listener : this.listeners) {
            if (listenersNotToNotify != null && Arrays.asList(listenersNotToNotify).contains(listener)) continue;
            listener.onTimeZoomChanged(zoomStartTimepoint, zoomEndTimepoint);
        }
    }

    @Override
    public void resetTimeZoom(TimeZoomChangeListener ... listenersNotToNotify) {
        this.isTimeZoomed = false;
        this.zoomStartTimepoint = null;
        this.zoomEndTimepoint = null;
        for (TimeZoomChangeListener listener : this.listeners) {
            if (listenersNotToNotify != null && Arrays.asList(listenersNotToNotify).contains(listener)) continue;
            listener.onTimeZoomReset();
        }
    }

    @Override
    public Util.Pair<Date, Date> getTimeZoom() {
        return new Util.Pair((Object)this.zoomStartTimepoint, (Object)this.zoomEndTimepoint);
    }

    @Override
    public boolean isZoomed() {
        return this.isTimeZoomed;
    }

    @Override
    public String toString() {
        return "TimeRangeWithZoomModel [fromTime=" + this.fromTime + ", toTime=" + this.toTime + ", zoomStartTimepoint=" + this.zoomStartTimepoint + ", zoomEndTimepoint=" + this.zoomEndTimepoint + ", isTimeZoomed=" + this.isTimeZoomed + "]";
    }
}

