/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.media;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.Util;
import com.sap.sse.common.media.TakedownNoticeRequestContext;
import com.sap.sse.gwt.client.Notification;
import com.sap.sse.gwt.client.StringMessages;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.media.TakedownNoticeRequestDialog;
import com.sap.sse.gwt.client.media.TakedownNoticeService;
import com.sap.sse.gwt.common.CommonSharedResources;

public class MediaMenuIcon
extends Composite {
    private static final CommonSharedResources.CommonMainCss MAIN_CSS = CommonSharedResources.INSTANCE.mainCss();
    private static MediaMenuIconUiBinder uiBinder = (MediaMenuIconUiBinder)GWT.create(MediaMenuIconUiBinder.class);
    @UiField
    HTML imageMenuButton;
    private final TakedownNoticeService takedownNoticeService;
    private final String contextDescriptionMessageKey;
    private String contextDescriptionMessageParameter;
    private String contentUrl;

    public MediaMenuIcon(TakedownNoticeService takedownNoticeService, String contextDescriptionMessageKey) {
        MAIN_CSS.ensureInjected();
        this.takedownNoticeService = takedownNoticeService;
        this.contextDescriptionMessageKey = contextDescriptionMessageKey;
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.imageMenuButton.addClickHandler(this::onClick);
    }

    public void setFontSize(String htmlFontSizeSpecification) {
        if (Util.hasLength((String)htmlFontSizeSpecification)) {
            String valueString = htmlFontSizeSpecification.replaceFirst("[a-zA-Z]+$", "");
            String unitString = htmlFontSizeSpecification.replaceFirst("^[0-9.]*", "");
            double value = Double.valueOf(valueString);
            Style.Unit unit = Util.hasLength((String)unitString) ? Style.Unit.valueOf((String)unitString.toUpperCase()) : Style.Unit.PX;
            this.imageMenuButton.getElement().getStyle().setFontSize(value, unit);
        } else {
            GWT.log((String)("Warning: unknown font size specification for MediaMenuIcon: " + htmlFontSizeSpecification));
        }
    }

    public void setZIndex(String zIndexSpecification) {
        if (Util.hasLength((String)zIndexSpecification)) {
            this.imageMenuButton.getElement().getStyle().setZIndex(Integer.parseInt(zIndexSpecification));
        }
    }

    public void setData(String contextDescriptionMessageParameter, String contentUrl) {
        this.contextDescriptionMessageParameter = contextDescriptionMessageParameter;
        this.contentUrl = contentUrl;
    }

    private void onClick(ClickEvent e) {
        e.stopPropagation();
        e.preventDefault();
        if (this.takedownNoticeService.isEmailAddressOfCurrentUserValidated()) {
            TakedownNoticeRequestDialog dialog = new TakedownNoticeRequestDialog(this.contextDescriptionMessageKey, this.contextDescriptionMessageParameter, this.contentUrl, this.takedownNoticeService.getCurrentUserName(), StringMessages.INSTANCE, new DataEntryDialog.DialogCallback<TakedownNoticeRequestContext>(){

                @Override
                public void ok(TakedownNoticeRequestContext editedObject) {
                    MediaMenuIcon.this.takedownNoticeService.fileTakedownNotice(editedObject);
                }

                @Override
                public void cancel() {
                }
            });
            dialog.show();
        } else {
            Notification.notify(StringMessages.INSTANCE.mustBeLoggedInAndWithValidatedEmail(), Notification.NotificationType.ERROR);
        }
    }

    static interface MediaMenuIconUiBinder
    extends UiBinder<Widget, MediaMenuIcon> {
    }
}

