/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.celltable;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.SafeHtmlHeader;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.ListDataProvider;
import com.sap.sse.common.InvertibleComparator;
import com.sap.sse.common.SortingOrder;
import com.sap.sse.common.impl.InvertibleComparatorAdapter;
import com.sap.sse.gwt.client.celltable.AbstractSortableColumnWithMinMax;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import com.sap.sse.gwt.client.celltable.Flushable;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.controls.BetterCheckboxCell;

public class SelectionCheckboxColumn<T>
extends AbstractSortableColumnWithMinMax<T, Boolean> {
    private final BetterCheckboxCell cell;
    private final String checkboxColumnCellCSSClass;
    private final DefaultSelectionEventManager.EventTranslator<T> selectionEventTranslator;
    private final RefreshableMultiSelectionModel<T> selectionModel;
    private final ListDataProvider<T> listDataProvider;
    private final Flushable display;

    public SelectionCheckboxColumn(String selectedCheckboxCSSClass, String deselectedCheckboxCSSClass, String checkboxColumnCellCSSClass, EntityIdentityComparator<T> entityIdentityComparator, ListDataProvider<T> listDataProvider, Flushable display) {
        this(new BetterCheckboxCell(selectedCheckboxCSSClass, deselectedCheckboxCSSClass), checkboxColumnCellCSSClass, entityIdentityComparator, listDataProvider, display);
    }

    private SelectionCheckboxColumn(BetterCheckboxCell checkboxCell, String checkboxColumnCellCSSClass, EntityIdentityComparator<T> entityIdentityComparator, ListDataProvider<T> listDataProvider, Flushable display) {
        super(checkboxCell, SortingOrder.DESCENDING);
        this.display = display;
        this.listDataProvider = listDataProvider;
        this.cell = checkboxCell;
        this.checkboxColumnCellCSSClass = checkboxColumnCellCSSClass;
        this.selectionEventTranslator = this.createSelectionEventTranslator();
        this.selectionModel = this.createSelectionModel(entityIdentityComparator);
    }

    public CellPreviewEvent.Handler<T> getSelectionManager() {
        return DefaultSelectionEventManager.createCustomManager(this.getSelectionEventTranslator());
    }

    protected ListDataProvider<T> getListDataProvider() {
        return this.listDataProvider;
    }

    public RefreshableMultiSelectionModel<T> getSelectionModel() {
        return this.selectionModel;
    }

    private RefreshableMultiSelectionModel<T> createSelectionModel(EntityIdentityComparator<T> entityIdentityComparator) {
        return new RefreshableMultiSelectionModel<T>(entityIdentityComparator, this.listDataProvider){

            public void clear() {
                super.clear();
                SelectionCheckboxColumn.this.display.flush();
            }

            @Override
            public void setSelected(T item, boolean selected) {
                boolean wasSelected = this.isSelected(item);
                super.setSelected(item, selected);
                if (wasSelected != selected) {
                    SelectionCheckboxColumn.this.display.flush();
                }
            }
        };
    }

    public DefaultSelectionEventManager.EventTranslator<T> getSelectionEventTranslator() {
        return this.selectionEventTranslator;
    }

    public Boolean getValue(T row) {
        return this.getSelectionModel().isSelected(row);
    }

    @Override
    public Header<?> getHeader() {
        return new SafeHtmlHeader(new SafeHtmlBuilder().appendEscaped("\u2713").toSafeHtml());
    }

    public String getCellStyleNames(Cell.Context context, T object) {
        String basicStyles = super.getCellStyleNames(context, object);
        return basicStyles == null ? this.checkboxColumnCellCSSClass : String.valueOf(basicStyles) + " " + this.checkboxColumnCellCSSClass;
    }

    public BetterCheckboxCell getCell() {
        return this.cell;
    }

    @Override
    public InvertibleComparator<T> getComparator() {
        return new InvertibleComparatorAdapter<T>(){

            public int compare(T a, T b) {
                return ((Boolean)SelectionCheckboxColumn.this.getValue(a)).booleanValue() ? (((Boolean)SelectionCheckboxColumn.this.getValue(b)).booleanValue() ? 0 : 1) : (((Boolean)SelectionCheckboxColumn.this.getValue(b)).booleanValue() ? -1 : 0);
            }
        };
    }

    @Override
    public void updateMinMax() {
    }

    private DefaultSelectionEventManager.EventTranslator<T> createSelectionEventTranslator() {
        return new DefaultSelectionEventManager.EventTranslator<T>(){

            public boolean clearCurrentSelection(CellPreviewEvent<T> event) {
                boolean ctrlOrMeta;
                NativeEvent nativeEvent = event.getNativeEvent();
                boolean bl = ctrlOrMeta = nativeEvent.getCtrlKey() || nativeEvent.getMetaKey();
                return !this.isSelectionCheckboxColumn(event) && !ctrlOrMeta;
            }

            private boolean isSelectionCheckboxColumn(CellPreviewEvent<T> event) {
                Column<?, ?> column = this.getColumn(event);
                return column == SelectionCheckboxColumn.this;
            }

            private Column<?, ?> getColumn(CellPreviewEvent<T> event) {
                CellTable table = (CellTable)event.getDisplay();
                return table.getColumn(event.getContext().getColumn());
            }

            public DefaultSelectionEventManager.SelectAction translateSelectionEvent(CellPreviewEvent<T> event) {
                DefaultSelectionEventManager.SelectAction result = "click".equals(event.getNativeEvent().getType()) && this.isSelectionCheckboxColumn(event) ? DefaultSelectionEventManager.SelectAction.TOGGLE : DefaultSelectionEventManager.SelectAction.DEFAULT;
                return result;
            }
        };
    }
}

