/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.celltable;

import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SingleSelectionModel;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import com.sap.sse.gwt.client.celltable.EntityIdentityWrapper;
import com.sap.sse.gwt.client.celltable.HasDataAdapter;
import com.sap.sse.gwt.client.celltable.RefreshableSelectionModel;
import java.util.List;

public class RefreshableSingleSelectionModel<T>
extends SingleSelectionModel<T>
implements RefreshableSelectionModel<T> {
    private final EntityIdentityComparator<T> comp;
    private boolean dontcheckSelectionState = false;

    public RefreshableSingleSelectionModel(final EntityIdentityComparator<T> comp, ListDataProvider<T> listDataProvider) {
        super(comp == null ? null : new ProvidesKey<T>(){

            public Object getKey(T item) {
                return new EntityIdentityWrapper(item, comp);
            }
        });
        this.comp = comp;
        listDataProvider.addDataDisplay(new HasDataAdapter<T>(this, listDataProvider));
    }

    @Override
    public EntityIdentityComparator<T> getEntityIdentityComparator() {
        return this.comp;
    }

    public void setSelected(T item, boolean selected) {
        if (this.getEntityIdentityComparator() == null || this.dontcheckSelectionState || item == null || this.getSelectedObject() == null) {
            super.setSelected(item, selected);
        } else {
            if (this.getEntityIdentityComparator().representSameEntity(this.getSelectedObject(), item)) {
                super.setSelected(this.getSelectedObject(), false);
            }
            super.setSelected(item, selected);
        }
    }

    @Override
    public boolean itemIsSelectedButNotVisible(List<T> visibleItemList) {
        return !visibleItemList.contains(this.getSelectedObject());
    }

    @Override
    public void refreshSelectionModel(Iterable<T> newObjects) {
        if (!this.dontcheckSelectionState) {
            try {
                this.dontcheckSelectionState = true;
                Object selected = this.getSelectedObject();
                if (selected != null) {
                    this.clear();
                    for (T it : newObjects) {
                        boolean isEqual;
                        boolean bl = isEqual = this.getEntityIdentityComparator() == null ? selected.equals(it) : this.getEntityIdentityComparator().representSameEntity(selected, it);
                        if (!isEqual) continue;
                        this.setSelected(it, true);
                        break;
                    }
                }
                SelectionChangeEvent.fire((SelectionChangeEvent.HasSelectionChangedHandlers)this);
            }
            finally {
                this.dontcheckSelectionState = false;
            }
        }
    }
}

