/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.hypothesis;

import smile.math.Math;
import smile.math.special.Beta;

public class TTest {
    public double df;
    public double t;
    public double pvalue;

    private TTest(double t, double df, double pvalue) {
        this.t = t;
        this.df = df;
        this.pvalue = pvalue;
    }

    public static TTest test(double[] x, double mean) {
        int n = x.length;
        double mu = Math.mean(x);
        double var = Math.var(x);
        int df = n - 1;
        double t = (mu - mean) / Math.sqrt(var / (double)n);
        double p = Beta.regularizedIncompleteBetaFunction(0.5 * (double)df, 0.5, (double)df / ((double)df + t * t));
        return new TTest(t, df, p);
    }

    public static TTest test(double[] x, double[] y) {
        return TTest.test(x, y, false);
    }

    public static TTest test(double[] x, double[] y, boolean equalVariance) {
        if (equalVariance) {
            int n1 = x.length;
            int n2 = y.length;
            double mu1 = Math.mean(x);
            double var1 = Math.var(x);
            double mu2 = Math.mean(y);
            double var2 = Math.var(y);
            int df = n1 + n2 - 2;
            double svar = ((double)(n1 - 1) * var1 + (double)(n2 - 1) * var2) / (double)df;
            double t = (mu1 - mu2) / Math.sqrt(svar * (1.0 / (double)n1 + 1.0 / (double)n2));
            double p = Beta.regularizedIncompleteBetaFunction(0.5 * (double)df, 0.5, (double)df / ((double)df + t * t));
            return new TTest(t, df, p);
        }
        int n1 = x.length;
        int n2 = y.length;
        double mu1 = Math.mean(x);
        double var1 = Math.var(x);
        double mu2 = Math.mean(y);
        double var2 = Math.var(y);
        double df = Math.sqr(var1 / (double)n1 + var2 / (double)n2) / (Math.sqr(var1 / (double)n1) / (double)(n1 - 1) + Math.sqr(var2 / (double)n2) / (double)(n2 - 1));
        double t = (mu1 - mu2) / Math.sqrt(var1 / (double)n1 + var2 / (double)n2);
        double p = Beta.regularizedIncompleteBetaFunction(0.5 * df, 0.5, df / (df + t * t));
        return new TTest(t, df, p);
    }

    public static TTest pairedTest(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Input vectors have different size");
        }
        double mu1 = Math.mean(x);
        double var1 = Math.var(x);
        double mu2 = Math.mean(y);
        double var2 = Math.var(y);
        int n = x.length;
        int df = n - 1;
        double cov = 0.0;
        for (int j = 0; j < n; ++j) {
            cov += (x[j] - mu1) * (y[j] - mu2);
        }
        double sd = Math.sqrt((var1 + var2 - 2.0 * (cov /= (double)df)) / (double)n);
        double t = (mu1 - mu2) / sd;
        double p = Beta.regularizedIncompleteBetaFunction(0.5 * (double)df, 0.5, (double)df / ((double)df + t * t));
        return new TTest(t, df, p);
    }

    public static TTest test(double r, int df) {
        double TINY = 1.0E-20;
        double t = r * Math.sqrt((double)df / ((1.0 - r + 1.0E-20) * (1.0 + r + 1.0E-20)));
        double p = Beta.regularizedIncompleteBetaFunction(0.5 * (double)df, 0.5, (double)df / ((double)df + t * t));
        return new TTest(t, df, p);
    }
}

