/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.resultimport.impl;

import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.common.RegattaScoreCorrections;
import com.sap.sailing.resultimport.CompetitorEntry;
import java.util.logging.Logger;

public class ScoreCorrectionForCompetitorInRaceImpl
implements RegattaScoreCorrections.ScoreCorrectionForCompetitorInRace {
    private static final Logger logger = Logger.getLogger(ScoreCorrectionForCompetitorInRaceImpl.class.getName());
    private final String competitorName;
    private final String sailID;
    private final double points;
    private final MaxPointsReason maxPointsReason;
    private final boolean discarded;

    public ScoreCorrectionForCompetitorInRaceImpl(String sailID, String competitorName, CompetitorEntry competitorEntry) {
        this.sailID = sailID;
        this.competitorName = competitorName;
        if (competitorEntry == null) {
            this.points = 0.0;
            this.maxPointsReason = null;
            this.discarded = false;
        } else {
            this.discarded = competitorEntry.isDiscarded();
            this.points = competitorEntry.getScore() == null ? 0.0 : competitorEntry.getScore();
            MaxPointsReason mpe = null;
            if (competitorEntry.getMaxPointsReason() != null && competitorEntry.getMaxPointsReason().length() > 0) {
                try {
                    mpe = MaxPointsReason.valueOf((String)competitorEntry.getMaxPointsReason().toUpperCase());
                }
                catch (IllegalArgumentException iae) {
                    logger.info("Don't understand rank " + competitorEntry.getMaxPointsReason());
                    mpe = null;
                }
            }
            this.maxPointsReason = mpe;
        }
    }

    public String getSailID() {
        return this.sailID;
    }

    public String getCompetitorName() {
        return this.competitorName;
    }

    public Double getPoints() {
        return this.points;
    }

    public MaxPointsReason getMaxPointsReason() {
        return this.maxPointsReason;
    }

    public Boolean isDiscarded() {
        return this.discarded;
    }
}

