/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common.impl;

import com.sap.sse.common.Util;
import com.sap.sse.common.impl.AbstractColor;

public class RGBColor
extends AbstractColor {
    private static final long serialVersionUID = -4091876840771631308L;
    private final int red;
    private final int green;
    private final int blue;

    public RGBColor(int red, int green, int blue) {
        this.red = this.ensureValidRange(red);
        this.green = this.ensureValidRange(green);
        this.blue = this.ensureValidRange(blue);
    }

    public RGBColor(String htmlColor) {
        int b;
        int g;
        int r;
        if (htmlColor.startsWith("#")) {
            htmlColor = htmlColor.substring(1);
        }
        if (htmlColor.endsWith(";")) {
            htmlColor = htmlColor.substring(0, htmlColor.length() - 1);
        }
        switch (htmlColor.length()) {
            case 6: {
                r = Integer.parseInt(htmlColor.substring(0, 2), 16);
                g = Integer.parseInt(htmlColor.substring(2, 4), 16);
                b = Integer.parseInt(htmlColor.substring(4, 6), 16);
                break;
            }
            case 3: {
                int r0 = Integer.parseInt(htmlColor.substring(0, 1), 16);
                r = 16 * r0 + r0;
                int g0 = Integer.parseInt(htmlColor.substring(1, 2), 16);
                g = 16 * g0 + g0;
                int b0 = Integer.parseInt(htmlColor.substring(2, 3), 16);
                b = 16 * b0 + b0;
                break;
            }
            case 1: {
                g = b = Integer.parseInt(htmlColor.substring(0, 1), 16);
                r = b;
                break;
            }
            default: {
                throw new IllegalArgumentException(htmlColor);
            }
        }
        this.red = this.ensureValidRange(r);
        this.green = this.ensureValidRange(g);
        this.blue = this.ensureValidRange(b);
    }

    private int ensureValidRange(int value) {
        int result = value;
        if (value < 0) {
            result = 0;
        } else if (value > 255) {
            result = 255;
        }
        return result;
    }

    @Override
    public Util.Triple<Integer, Integer, Integer> getAsRGB() {
        return new Util.Triple<Integer, Integer, Integer>(this.red, this.green, this.blue);
    }

    @Override
    public Util.Triple<Float, Float, Float> getAsHSV() {
        float hue;
        int cmin;
        int cmax;
        int n = cmax = this.red > this.green ? this.red : this.green;
        if (this.blue > cmax) {
            cmax = this.blue;
        }
        int n2 = cmin = this.red < this.green ? this.red : this.green;
        if (this.blue < cmin) {
            cmin = this.blue;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - this.red) / (float)(cmax - cmin);
            float greenc = (float)(cmax - this.green) / (float)(cmax - cmin);
            float bluec = (float)(cmax - this.blue) / (float)(cmax - cmin);
            hue = this.red == cmax ? bluec - greenc : (this.green == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        Util.Triple<Float, Float, Float> HSVColor2 = new Util.Triple<Float, Float, Float>(Float.valueOf(hue * 360.0f), Float.valueOf(saturation), Float.valueOf(brightness));
        return HSVColor2;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.blue;
        result = 31 * result + this.green;
        result = 31 * result + this.red;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RGBColor other = (RGBColor)obj;
        if (this.blue != other.blue) {
            return false;
        }
        if (this.green != other.green) {
            return false;
        }
        return this.red == other.red;
    }

    public String toString() {
        return this.getAsHtml();
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }
}

