/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common;

import com.sap.sse.common.ValueRangeFlexibleBoundariesChangedListener;
import java.util.HashSet;
import java.util.Set;

public class ValueRangeFlexibleBoundaries {
    private double minLeft;
    private double maxLeft;
    private double minRight;
    private double maxRight;
    private double min;
    private double max;
    private final double percentage;
    private final double minimumHalfBoundaryWidth;
    private double halfBoundaryWidth;
    private final Set<ValueRangeFlexibleBoundariesChangedListener> valueRangeChangedListeners;

    public ValueRangeFlexibleBoundaries(double initialMin, double initialMax, double percentage, double minimumHalfBoundaryWidth) {
        this.percentage = percentage;
        this.minimumHalfBoundaryWidth = minimumHalfBoundaryWidth;
        this.valueRangeChangedListeners = new HashSet<ValueRangeFlexibleBoundariesChangedListener>();
        this.min = initialMin;
        this.max = initialMax;
        this.update();
    }

    private void update() {
        this.halfBoundaryWidth = Math.max((this.max - this.min) * this.percentage, this.minimumHalfBoundaryWidth);
        this.minLeft = this.min - this.halfBoundaryWidth;
        this.maxLeft = this.min + this.halfBoundaryWidth;
        this.minRight = this.max - this.halfBoundaryWidth;
        this.maxRight = this.max + this.halfBoundaryWidth;
        this.notifyListeners();
    }

    public void setMinMax(double minValue, double maxValue) {
        if (minValue > maxValue) {
            throw new IllegalArgumentException("minValue " + minValue + " is greater than maxValue " + maxValue);
        }
        this.min = minValue;
        this.max = maxValue;
        if (!this.isValueInRightRange(maxValue) || !this.isValueInLeftRange(minValue)) {
            this.update();
        }
        assert (this.minLeft <= minValue);
        assert (minValue <= this.maxLeft);
        assert (this.minRight <= maxValue);
        assert (maxValue <= this.maxRight);
    }

    private boolean isValueInLeftRange(double value) {
        return value >= this.minLeft && value <= this.maxLeft;
    }

    private boolean isValueInRightRange(double value) {
        return value >= this.minRight && value <= this.maxRight;
    }

    public double getMinLeft() {
        return this.minLeft;
    }

    public double getMaxRight() {
        return this.maxRight;
    }

    public void addListener(ValueRangeFlexibleBoundariesChangedListener listener) {
        this.valueRangeChangedListeners.add(listener);
    }

    public void removeListener(ValueRangeFlexibleBoundariesChangedListener listener) {
        this.valueRangeChangedListeners.remove(listener);
    }

    public void notifyListeners() {
        for (ValueRangeFlexibleBoundariesChangedListener listener : this.valueRangeChangedListeners) {
            listener.onValueRangeBoundariesChanged();
        }
    }
}

