/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.ServiceManager;
import org.redisson.misc.AsyncSemaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionsHolder<T extends RedisConnection> {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Queue<T> allConnections = new ConcurrentLinkedQueue<T>();
    private final Queue<T> freeConnections = new ConcurrentLinkedQueue<T>();
    private final AsyncSemaphore freeConnectionsCounter;
    private final RedisClient client;
    private final Function<RedisClient, CompletionStage<T>> connectionCallback;
    private final ServiceManager serviceManager;
    private final boolean changeUsage;

    public ConnectionsHolder(RedisClient client, int poolMaxSize, Function<RedisClient, CompletionStage<T>> connectionCallback, ServiceManager serviceManager, boolean changeUsage) {
        this.freeConnectionsCounter = new AsyncSemaphore(poolMaxSize);
        this.client = client;
        this.connectionCallback = connectionCallback;
        this.serviceManager = serviceManager;
        this.changeUsage = changeUsage;
    }

    public <R extends RedisConnection> boolean remove(R connection) {
        if (this.freeConnections.remove(connection)) {
            return this.allConnections.remove(connection);
        }
        return false;
    }

    public Queue<T> getFreeConnections() {
        return this.freeConnections;
    }

    public AsyncSemaphore getFreeConnectionsCounter() {
        return this.freeConnectionsCounter;
    }

    protected CompletableFuture<Void> acquireConnection() {
        return this.freeConnectionsCounter.acquire();
    }

    private void releaseConnection() {
        this.freeConnectionsCounter.release();
    }

    private void addConnection(T conn) {
        ((RedisConnection)conn).setLastUsageTime(System.nanoTime());
        this.freeConnections.add(conn);
    }

    private T pollConnection(RedisCommand<?> command) {
        RedisConnection c = (RedisConnection)this.freeConnections.poll();
        if (c != null) {
            c.incUsage();
        }
        return (T)c;
    }

    private void releaseConnection(T connection) {
        if (((RedisConnection)connection).isClosed()) {
            return;
        }
        if (this.client != null && this.client != ((RedisConnection)connection).getRedisClient()) {
            ((RedisConnection)connection).closeAsync();
            return;
        }
        ((RedisConnection)connection).setLastUsageTime(System.nanoTime());
        this.freeConnections.add(connection);
        ((RedisConnection)connection).decUsage();
    }

    public Queue<T> getAllConnections() {
        return this.allConnections;
    }

    public CompletableFuture<Void> initConnections(int minimumIdleSize) {
        if (minimumIdleSize == 0) {
            return CompletableFuture.completedFuture(null);
        }
        CompletionStage<Void> f = this.createConnection(minimumIdleSize, 1);
        int i = 2;
        while (i <= minimumIdleSize) {
            int k = i++;
            f = f.thenCompose(r -> this.createConnection(minimumIdleSize, k));
        }
        return f.thenAccept(r -> this.log.info("{} connections initialized for {}", (Object)minimumIdleSize, (Object)this.client.getAddr()));
    }

    private CompletableFuture<Void> createConnection(int minimumIdleSize, int index) {
        CompletableFuture<Void> f = this.acquireConnection();
        return f.thenCompose(r -> {
            CompletableFuture promise = new CompletableFuture();
            this.createConnection(promise);
            return promise.handle((conn, e) -> {
                if (e == null) {
                    if (this.changeUsage) {
                        conn.decUsage();
                    }
                    this.addConnection(conn);
                }
                this.releaseConnection();
                if (e != null) {
                    for (RedisConnection connection : this.getAllConnections()) {
                        if (connection.isClosed()) continue;
                        connection.closeAsync();
                    }
                    this.getAllConnections().clear();
                    int totalInitializedConnections = index - 1;
                    String errorMsg = totalInitializedConnections == 0 ? "Unable to connect to Redis server: " + this.client.getAddr() : "Unable to init enough connections amount! Only " + totalInitializedConnections + " of " + minimumIdleSize + " were initialized. Redis server: " + this.client.getAddr();
                    RedisConnectionException cause = new RedisConnectionException(errorMsg, (Throwable)e);
                    throw new CompletionException(cause);
                }
                return null;
            });
        });
    }

    private void createConnection(CompletableFuture<T> promise) {
        CompletionStage<RedisConnection> connFuture = this.connectionCallback.apply(this.client);
        connFuture.whenComplete((conn, e) -> {
            if (e != null) {
                this.releaseConnection();
                promise.completeExceptionally((Throwable)e);
                return;
            }
            this.log.debug("new connection created: {}", conn);
            this.allConnections.add(conn);
            if (this.changeUsage) {
                promise.thenApply(c -> c.incUsage());
            }
            this.connectedSuccessful(promise, conn);
        });
    }

    private void connectedSuccessful(CompletableFuture<T> promise, T conn) {
        if (!promise.complete(conn)) {
            this.releaseConnection(conn);
            this.releaseConnection();
        }
    }

    public CompletableFuture<T> acquireConnection(RedisCommand<?> command) {
        CompletableFuture result = new CompletableFuture();
        CompletableFuture<Void> f = this.acquireConnection();
        f.thenAccept(r -> this.connectTo(result, command));
        result.whenComplete((r, e) -> {
            if (e != null) {
                f.completeExceptionally((Throwable)e);
            }
        });
        return result;
    }

    private void connectTo(CompletableFuture<T> promise, RedisCommand<?> command) {
        if (promise.isDone()) {
            this.serviceManager.getGroup().submit(() -> this.releaseConnection());
            return;
        }
        T conn = this.pollConnection(command);
        if (conn != null) {
            this.connectedSuccessful(promise, conn);
            return;
        }
        this.createConnection(promise);
    }

    public String toString() {
        return "ConnectionsHolder{allConnections=" + this.allConnections.size() + ", freeConnections=" + this.freeConnections.size() + ", freeConnectionsCounter=" + this.freeConnectionsCounter + '}';
    }

    public void releaseConnection(ClientConnectionsEntry entry, T connection) {
        if (entry.isFreezed() && entry.getFreezeReason() != ClientConnectionsEntry.FreezeReason.SYSTEM) {
            ((RedisConnection)connection).closeAsync();
            this.getAllConnections().remove(connection);
        } else {
            this.releaseConnection(connection);
        }
        this.releaseConnection();
    }
}

