/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client.presentation;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.Util;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.datamining.shared.dto.StatisticQueryDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.QueryResultDTO;
import com.sap.sse.datamining.ui.client.AbstractDataMiningComponent;
import com.sap.sse.datamining.ui.client.CompositeResultsPresenter;
import com.sap.sse.datamining.ui.client.ResultsPresenter;
import com.sap.sse.datamining.ui.client.presentation.MultiResultsPresenter;
import com.sap.sse.datamining.ui.client.presentation.ResultsChart;
import com.sap.sse.datamining.ui.client.resources.DataMiningResources;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.controls.ScrolledTabLayoutPanel;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class TabbedResultsPresenter
extends AbstractDataMiningComponent<Settings>
implements CompositeResultsPresenter<Settings> {
    protected static final DataMiningResources resources = (DataMiningResources)GWT.create(DataMiningResources.class);
    private static final String IdPrefix = "Tab";
    private final AtomicInteger idCounter = new AtomicInteger();
    private final ScrolledTabLayoutPanel tabPanel = new ScrolledTabLayoutPanel(30.0, Style.Unit.PX, resources.arrowLeftIcon(), resources.arrowRightIcon());
    private final Map<String, CloseablePresenterTab> tabsMappedById;
    private final ResultsChart.DrillDownCallback drillDownCallback;
    private final Map<String, ResultsPresenterFactory<?>> registeredPresenterFactories;
    private final ResultsPresenterFactory<MultiResultsPresenter> defaultFactory;
    private final Set<CompositeResultsPresenter.CurrentPresenterChangedListener> currentPresenterChangedListeners;
    private final Set<CompositeResultsPresenter.PresenterRemovedListener> presenterRemovedListeners;

    public TabbedResultsPresenter(Component<?> parent, ComponentContext<?> context, ResultsChart.DrillDownCallback drillDownCallback) {
        super(parent, context);
        this.tabPanel.setAnimationDuration(0);
        this.tabsMappedById = new HashMap<String, CloseablePresenterTab>();
        this.drillDownCallback = drillDownCallback;
        this.registeredPresenterFactories = new HashMap();
        this.defaultFactory = new ResultsPresenterFactory<MultiResultsPresenter>(MultiResultsPresenter.class, () -> new MultiResultsPresenter(this, this.getComponentContext(), drillDownCallback));
        this.currentPresenterChangedListeners = new HashSet<CompositeResultsPresenter.CurrentPresenterChangedListener>();
        this.presenterRemovedListeners = new HashSet<CompositeResultsPresenter.PresenterRemovedListener>();
        this.addNewTab();
        this.addTabAndFocus(new MultiResultsPresenter(this, context, drillDownCallback));
        this.tabPanel.addSelectionHandler(event -> {
            String presenterId = ((CloseablePresenterTab)this.tabPanel.getTabWidget(((Integer)event.getSelectedItem()).intValue())).getId();
            for (CompositeResultsPresenter.CurrentPresenterChangedListener listener : this.currentPresenterChangedListeners) {
                listener.currentPresenterChanged(presenterId);
            }
        });
    }

    private void addNewTab() {
        Label widget = new Label("This should never be shown");
        FlowPanel header = new FlowPanel();
        header.addStyleName("resultsPresenterTabHeader");
        header.add((Widget)new Image(resources.plusIcon()));
        this.tabPanel.add((Widget)widget, (Widget)header);
        this.tabPanel.addBeforeSelectionHandler(event -> {
            if ((Integer)event.getItem() == this.tabPanel.getWidgetCount() - 1) {
                event.cancel();
                this.addTabAndFocus(new MultiResultsPresenter(this, this.getComponentContext(), this.drillDownCallback));
            }
        });
    }

    @Override
    public String getCurrentPresenterId() {
        return this.getSelectedTab().getId();
    }

    @Override
    public int getCurrentPresenterIndex() {
        return this.tabPanel.getSelectedIndex();
    }

    @Override
    public Iterable<String> getPresenterIds() {
        HashSet<String> idSet = new HashSet<String>(this.tabsMappedById.keySet());
        return Collections.unmodifiableSet(idSet);
    }

    @Override
    public boolean containsPresenter(String presenterId) {
        return this.tabsMappedById.containsKey(presenterId);
    }

    @Override
    public int getPresenterIndex(String presenterId) {
        CloseablePresenterTab tab = this.getTab(presenterId);
        return tab != null ? this.tabPanel.getWidgetIndex((Widget)tab) : -1;
    }

    @Override
    public QueryResultDTO<?> getResult(String presenterId) {
        CloseablePresenterTab tab = this.getTab(presenterId);
        return tab != null ? tab.getPresenter().getCurrentResult() : null;
    }

    @Override
    public StatisticQueryDefinitionDTO getQueryDefinition(String presenterId) {
        CloseablePresenterTab tab = this.getTab(presenterId);
        return tab != null ? tab.getPresenter().getCurrentQueryDefinition() : null;
    }

    @Override
    public void showResult(String presenterId, StatisticQueryDefinitionDTO queryDefinition, QueryResultDTO<?> result) {
        CloseablePresenterTab presenterTab = this.getTab(presenterId);
        if (presenterTab != null) {
            if (result != null) {
                ResultsPresenter<?> presenter = presenterTab.getPresenter();
                ResultsPresenterFactory<MultiResultsPresenter> factory = this.registeredPresenterFactories.getOrDefault(result.getResultType(), this.defaultFactory);
                if (presenter.getClass() != factory.getProducedType()) {
                    CloseablePresenterTab newPresenterTab = this.addTabAndFocus(factory.createPresenter());
                    this.removeTab(presenterTab);
                    presenterTab = newPresenterTab;
                }
                presenterTab.setText(result.getResultSignifier());
            } else {
                presenterTab.setText(this.getDataMiningStringMessages().empty());
            }
            presenterTab.getPresenter().showResult(queryDefinition, result);
        }
    }

    @Override
    public void showResults(Iterable<Util.Pair<StatisticQueryDefinitionDTO, QueryResultDTO<?>>> results) {
        new ArrayList<String>(this.tabsMappedById.keySet()).stream().map(this.tabsMappedById::get).forEach(this::removeTabNotNotifyingListeners);
        for (Util.Pair<StatisticQueryDefinitionDTO, QueryResultDTO<?>> entry : results) {
            StatisticQueryDefinitionDTO queryDefinition = (StatisticQueryDefinitionDTO)entry.getA();
            QueryResultDTO result = (QueryResultDTO)entry.getB();
            ResultsPresenterFactory<MultiResultsPresenter> factory = this.registeredPresenterFactories.getOrDefault(result.getResultType(), this.defaultFactory);
            CloseablePresenterTab presenterTab = this.addTabAndFocus(factory.createPresenter());
            presenterTab.setText(result.getResultSignifier());
            presenterTab.getPresenter().showResult(queryDefinition, result);
        }
        for (CloseablePresenterTab tab : this.tabsMappedById.values()) {
            if (this.tabPanel.getWidgetIndex(tab.getPresenter().getEntryWidget()) != 0) continue;
            this.removeTab(tab);
            break;
        }
        this.tabPanel.selectTab(0, true);
    }

    @Override
    public void showError(String presenterId, StatisticQueryDefinitionDTO queryDefinition, String error) {
        CloseablePresenterTab tab = this.getTab(presenterId);
        if (tab != null) {
            tab.setText(this.getDataMiningStringMessages().error());
            tab.getPresenter().showError(queryDefinition, error);
        }
    }

    @Override
    public void showError(String presenterId, StatisticQueryDefinitionDTO queryDefinition, String mainError, Iterable<String> detailedErrors) {
        CloseablePresenterTab tab = this.getTab(presenterId);
        if (tab != null) {
            tab.setText(this.getDataMiningStringMessages().error());
            tab.getPresenter().showError(mainError, detailedErrors, queryDefinition);
        }
    }

    @Override
    public void showBusyIndicator(String presenterId) {
        CloseablePresenterTab tab = this.getTab(presenterId);
        if (tab != null) {
            tab.setText(this.getDataMiningStringMessages().runningQuery());
            tab.getPresenter().showBusyIndicator();
        }
    }

    @Override
    public void addCurrentPresenterChangedListener(CompositeResultsPresenter.CurrentPresenterChangedListener listener) {
        this.currentPresenterChangedListeners.add(listener);
    }

    @Override
    public void removeCurrentPresenterChangedListener(CompositeResultsPresenter.CurrentPresenterChangedListener listener) {
        this.currentPresenterChangedListeners.remove(listener);
    }

    @Override
    public void addPresenterRemovedListener(CompositeResultsPresenter.PresenterRemovedListener listener) {
        this.presenterRemovedListeners.add(listener);
    }

    @Override
    public void removePresenterRemovedListener(CompositeResultsPresenter.PresenterRemovedListener listener) {
        this.presenterRemovedListeners.remove(listener);
    }

    public void registerResultsPresenter(Class<?> resultType, ResultsPresenterFactory<?> presenterFactory) throws IllegalStateException {
        String className = resultType.getName();
        if (this.registeredPresenterFactories.containsKey(className)) {
            throw new IllegalStateException("Multiple registration for result type key: " + resultType.toString() + "not allowed.");
        }
        this.registeredPresenterFactories.put(className, presenterFactory);
    }

    protected CloseablePresenterTab getSelectedTab() {
        return (CloseablePresenterTab)this.tabPanel.getTabWidget(this.tabPanel.getSelectedIndex());
    }

    protected CloseablePresenterTab getTab(String id) {
        return this.tabsMappedById.get(id);
    }

    protected CloseablePresenterTab addTabAndFocus(ResultsPresenter<?> presenter) {
        String tabId = IdPrefix + this.idCounter.getAndIncrement();
        CloseablePresenterTab presenterTab = new CloseablePresenterTab(tabId, presenter);
        this.tabsMappedById.put(tabId, presenterTab);
        this.tabPanel.insert(presenter.getEntryWidget(), (Widget)presenterTab, this.tabPanel.getWidgetCount() - 1);
        int presenterIndex = this.tabPanel.getWidgetIndex(presenter.getEntryWidget());
        this.tabPanel.selectTab(presenterIndex);
        this.tabPanel.scrollToTab(presenterIndex);
        return presenterTab;
    }

    protected void removeTabNotNotifyingListeners(CloseablePresenterTab tab) {
        this.removeTab(tab, false);
    }

    protected void removeTab(CloseablePresenterTab tab) {
        this.removeTab(tab, true);
    }

    protected void removeTab(CloseablePresenterTab tab, boolean notifyListeners) {
        String presenterId = tab.getId();
        int index = this.getPresenterIndex(presenterId);
        tab.removeFromParent();
        this.tabsMappedById.remove(presenterId);
        if (notifyListeners) {
            this.presenterRemovedListeners.forEach(l -> l.onPresenterRemoved(presenterId, index, tab.getPresenter().getCurrentQueryDefinition()));
        }
    }

    public String getLocalizedShortName() {
        return this.getDataMiningStringMessages().tabbedResultsPresenter();
    }

    public Widget getEntryWidget() {
        return this.tabPanel;
    }

    public boolean isVisible() {
        return this.tabPanel.isVisible();
    }

    public void setVisible(boolean visibility) {
        this.tabPanel.setVisible(visibility);
    }

    public boolean hasSettings() {
        return false;
    }

    public SettingsDialogComponent<Settings> getSettingsDialogComponent(Settings settings) {
        return null;
    }

    public void updateSettings(Settings newSettings) {
    }

    public Settings getSettings() {
        return null;
    }

    public String getId() {
        return "TabbedResultsPresenter";
    }

    public String getDependentCssClassName() {
        return "tabbedResultsPresenters";
    }

    private class CloseablePresenterTab
    extends FlowPanel {
        private final String id;
        private final Label headerLabel;
        private final ResultsPresenter<?> presenter;

        public CloseablePresenterTab(String id, ResultsPresenter<?> presenter) {
            this.id = id;
            this.presenter = presenter;
            this.addStyleName("resultsPresenterTabHeader");
            this.headerLabel = new Label(TabbedResultsPresenter.this.getDataMiningStringMessages().empty());
            this.add((Widget)this.headerLabel);
            Image closeImage = new Image(resources.closeIcon());
            closeImage.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (TabbedResultsPresenter.this.tabPanel.getWidgetCount() > 2) {
                        TabbedResultsPresenter.this.removeTab(CloseablePresenterTab.this);
                    }
                }
            });
            this.add((Widget)closeImage);
        }

        public String getId() {
            return this.id;
        }

        public ResultsPresenter<?> getPresenter() {
            return this.presenter;
        }

        public void setText(String text) {
            this.headerLabel.setText(text);
            TabbedResultsPresenter.this.tabPanel.checkIfScrollButtonsNecessary();
        }
    }

    public static class ResultsPresenterFactory<T extends ResultsPresenter<?>> {
        private final Class<T> presenterType;
        private final ResultsPresenterSupplier<T> presenterSupplier;

        public ResultsPresenterFactory(Class<T> presenterType, ResultsPresenterSupplier<T> presenterSupplier) {
            this.presenterType = presenterType;
            this.presenterSupplier = presenterSupplier;
        }

        public Class<T> getProducedType() {
            return this.presenterType;
        }

        public T createPresenter() {
            return this.presenterSupplier.create();
        }
    }

    @FunctionalInterface
    public static interface ResultsPresenterSupplier<T extends ResultsPresenter<?>> {
        public T create();
    }
}

