/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client;

import com.google.gwt.i18n.client.NumberFormat;
import com.sap.sse.gwt.client.Notification;
import com.sap.sse.gwt.shared.TextExporter;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.moxieapps.gwt.highcharts.client.Chart;
import org.moxieapps.gwt.highcharts.client.Point;
import org.moxieapps.gwt.highcharts.client.Series;

public class ChartToCsvExporter {
    private final String exportedMessage;

    public ChartToCsvExporter(String exportedMessage) {
        this.exportedMessage = exportedMessage;
    }

    public void exportChartAsCsvToClipboard(Chart chartToExport) {
        String csvContentExport = ChartToCsvExporter.createCsvExportContentForStatisticsCurve(chartToExport);
        TextExporter.exportToClipboard((String)csvContentExport);
        Notification.notify((String)this.exportedMessage, (Notification.NotificationType)Notification.NotificationType.INFO);
    }

    private static String createCsvExportContentForStatisticsCurve(Chart chartToExport) {
        if (chartToExport != null && chartToExport.getSeries().length > 0) {
            Point point;
            int n;
            int n2;
            Point[] pointArray;
            StringBuilder csvStr = new StringBuilder("Series name");
            HashMap<Number, Integer> columnIndexByXValue = new HashMap<Number, Integer>();
            TreeMap<Number, String> orderedColumnNames = new TreeMap<Number, String>((a, b) -> Double.compare(a.doubleValue(), b.doubleValue()));
            Series[] seriesArray = chartToExport.getSeries();
            int n3 = seriesArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Series series = seriesArray[n4];
                pointArray = series.getPoints();
                n2 = pointArray.length;
                n = 0;
                while (n < n2) {
                    point = pointArray[n];
                    String columnName = ChartToCsvExporter.getColumnName(point);
                    orderedColumnNames.put(point.getX(), columnName);
                    ++n;
                }
                ++n4;
            }
            for (String columnName : orderedColumnNames.values()) {
                csvStr.append(';');
                if (columnName == null || columnName.isEmpty()) continue;
                csvStr.append(columnName);
            }
            int columnIndex = 0;
            for (Map.Entry e : orderedColumnNames.entrySet()) {
                columnIndexByXValue.put((Number)e.getKey(), columnIndex++);
            }
            csvStr.append("\r\n");
            Series[] seriesArray2 = chartToExport.getSeries();
            int n5 = seriesArray2.length;
            int n6 = 0;
            while (n6 < n5) {
                Series series = seriesArray2[n6];
                csvStr.append(series.getName());
                int lastXIndex = -1;
                pointArray = series.getPoints();
                n2 = pointArray.length;
                n = 0;
                while (n < n2) {
                    point = pointArray[n];
                    while (lastXIndex < (Integer)columnIndexByXValue.get(point.getX())) {
                        csvStr.append(';');
                        ++lastXIndex;
                    }
                    csvStr.append(NumberFormat.getDecimalFormat().format(point.getY()));
                    ++n;
                }
                csvStr.append("\r\n");
                ++n6;
            }
            String csvContentExport = csvStr.toString();
            return csvContentExport;
        }
        return "Statistics are empty";
    }

    private static String getColumnName(Point point) {
        String pointName = point.getName();
        String columnName = pointName != null && !pointName.isEmpty() ? pointName : point.getX().toString();
        return columnName;
    }
}

