/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.mail;

import com.sap.sse.common.Named;
import com.sap.sse.common.impl.NamedImpl;
import com.sap.sse.mail.SerializableMimeBodyPartSupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMultipart;

public class SerializableMultipartSupplier
extends NamedImpl
implements Supplier<Multipart>,
Named {
    private static final long serialVersionUID = 4316486727705670702L;
    private final List<SerializableMimeBodyPartSupplier> bodyPartSuppliers = new ArrayList<SerializableMimeBodyPartSupplier>();

    public SerializableMultipartSupplier(String subtype) {
        super(subtype);
    }

    public void addBodyPart(SerializableMimeBodyPartSupplier bodyPartSupplier) {
        this.bodyPartSuppliers.add(bodyPartSupplier);
    }

    @Override
    public Multipart get() {
        MimeMultipart result = new MimeMultipart(this.getName());
        for (SerializableMimeBodyPartSupplier bodyPartSupplier : this.bodyPartSuppliers) {
            try {
                result.addBodyPart((BodyPart)bodyPartSupplier.get());
            }
            catch (MessagingException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }
}

