/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.mail;

import com.sap.sse.mail.SerializableMimeBodyPartSupplier;
import com.sap.sse.qrcode.QRCodeGenerationUtil;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.internet.MimeBodyPart;
import javax.mail.util.ByteArrayDataSource;

public class QRCodeMimeBodyPartSupplier
implements SerializableMimeBodyPartSupplier {
    private static final long serialVersionUID = 6073707813859319317L;
    private final String text;

    public QRCodeMimeBodyPartSupplier(String text) {
        this.text = text;
    }

    @Override
    public MimeBodyPart get() {
        MimeBodyPart messageImagePart = new MimeBodyPart();
        try {
            InputStream imageIs = QRCodeGenerationUtil.create((String)this.text, (int)250);
            ByteArrayDataSource imageDs = new ByteArrayDataSource(imageIs, "image/png");
            messageImagePart.setDataHandler(new DataHandler((DataSource)imageDs));
            messageImagePart.setHeader("Content-ID", "<image>");
            messageImagePart.setHeader("Content-Disposition", "inline;filename=\"qr.png\"");
            return messageImagePart;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

