/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.expeditionconnector;

import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sse.common.impl.NamedImpl;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.dto.AccessControlListDTO;
import com.sap.sse.security.shared.dto.OwnershipDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.dto.SecurityInformationDTO;
import java.util.UUID;

public class ExpeditionDeviceConfiguration
extends NamedImpl
implements SecuredDTO {
    private static final long serialVersionUID = -7819154195403387909L;
    private SecurityInformationDTO securityInformation = new SecurityInformationDTO();
    private final UUID deviceUuid;
    private final Integer expeditionBoatId;

    public ExpeditionDeviceConfiguration(String name, UUID deviceUuid, Integer expeditionBoatId) {
        super(name);
        this.deviceUuid = deviceUuid;
        this.expeditionBoatId = expeditionBoatId;
    }

    public UUID getDeviceUuid() {
        return this.deviceUuid;
    }

    public Integer getExpeditionBoatId() {
        return this.expeditionBoatId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.deviceUuid == null ? 0 : this.deviceUuid.hashCode());
        result = 31 * result + (this.expeditionBoatId == null ? 0 : this.expeditionBoatId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ExpeditionDeviceConfiguration other = (ExpeditionDeviceConfiguration)((Object)obj);
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        if (this.deviceUuid == null ? other.deviceUuid != null : !this.deviceUuid.equals(other.deviceUuid)) {
            return false;
        }
        return !(this.expeditionBoatId == null ? other.expeditionBoatId != null : !this.expeditionBoatId.equals(other.expeditionBoatId));
    }

    public String toString() {
        return "ExpeditionDeviceConfiguration [deviceUuid=" + this.deviceUuid + ", expeditionBoatId=" + this.expeditionBoatId + ", getName()=" + this.getName() + "]";
    }

    public HasPermissions getType() {
        return SecuredDomainType.EXPEDITION_DEVICE_CONFIGURATION;
    }

    public QualifiedObjectIdentifier getIdentifier() {
        return this.getPermissionType().getQualifiedObjectIdentifier(this.getTypeRelativeObjectIdentifier());
    }

    public HasPermissions getPermissionType() {
        return SecuredDomainType.EXPEDITION_DEVICE_CONFIGURATION;
    }

    public TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier() {
        return new TypeRelativeObjectIdentifier(new String[]{this.getDeviceUuid().toString()});
    }

    public final AccessControlListDTO getAccessControlList() {
        return this.securityInformation.getAccessControlList();
    }

    public final OwnershipDTO getOwnership() {
        return this.securityInformation.getOwnership();
    }

    public final void setAccessControlList(AccessControlListDTO accessControlList) {
        this.securityInformation.setAccessControlList(accessControlList);
    }

    public final void setOwnership(OwnershipDTO ownership) {
        this.securityInformation.setOwnership(ownership);
    }
}

