/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.simulator.windfield.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.simulator.Grid;
import com.sap.sailing.simulator.TimedPosition;
import com.sap.sailing.simulator.windfield.WindControlParameters;
import com.sap.sailing.simulator.windfield.WindFieldGenerator;
import com.sap.sailing.simulator.windfield.impl.BlastRandom;
import com.sap.sailing.simulator.windfield.impl.BlastRandomSeedManagerImpl;
import com.sap.sailing.simulator.windfield.impl.WindFieldGeneratorImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import java.util.logging.Logger;

public class WindFieldGeneratorBlastImpl
extends WindFieldGeneratorImpl
implements WindFieldGenerator {
    private static final long serialVersionUID = -188939912966537200L;
    private SpeedWithBearing[][] speedWithBearing;
    private double blastSizeProbability = 70.0;
    private double blastEdgeProbability = 30.0;
    private double blastBearingMean = 0.0;
    private double blastBearingVar = 6.0;
    private double defaultWindSpeed = 0.0;
    private double defaultWindBearing = 0.0;
    private SpeedWithBearing defaultSpeedWithBearing;
    public final int defaultTimeUnits = 20;
    private int timeUnits;
    private static Logger logger = Logger.getLogger(WindFieldGeneratorBlastImpl.class.getName());

    public WindFieldGeneratorBlastImpl(Grid boundary, WindControlParameters windParameters) {
        super(boundary, windParameters);
    }

    @Override
    public void generate(TimePoint start, TimePoint end, Duration step) {
        this.generate(start, end, step, this.windParameters.baseWindSpeed, this.windParameters.baseWindBearing);
    }

    protected void generate(TimePoint start, TimePoint end, Duration step, double defaultSpeed, double defaultBearing) {
        super.generate(start, end, step);
        this.setDefaultWindSpeed(defaultSpeed);
        this.setDefaultWindBearing(defaultBearing);
        this.defaultSpeedWithBearing = new KnotSpeedWithBearingImpl(this.defaultWindSpeed, (Bearing)new DegreeBearingImpl(this.defaultWindBearing));
        this.initializeSpeedWithBearing();
    }

    private void initializeSpeedWithBearing() {
        if (this.positions == null || this.positions.length < 1) {
            return;
        }
        int nrow = this.boundary.getResY() + 2 * this.boundary.getBorderY();
        int ncol = this.boundary.getResX() + 2 * this.boundary.getBorderX();
        this.timeUnits = nrow + 20;
        if (this.startTime != null && this.endTime != null) {
            this.timeUnits = (int)((this.endTime.asMillis() - this.startTime.asMillis()) / this.timeStep.asMillis()) + nrow;
            logger.info("Generating blasts for " + this.timeUnits + " rows & " + ncol + " columns");
        }
        this.speedWithBearing = new KnotSpeedWithBearingImpl[this.timeUnits][ncol];
        int i = 0;
        while (i < this.timeUnits) {
            int j = 0;
            while (j < ncol) {
                if (this.isBlastSeed()) {
                    logger.fine("[" + i + "][" + j + "] is  a blast seed");
                    double blastSpeed = this.getBlastSpeed();
                    double blastAngle = this.getBlastAngle();
                    KnotSpeedWithBearingImpl blastSpeedWithBearing = new KnotSpeedWithBearingImpl(blastSpeed, (Bearing)new DegreeBearingImpl(blastAngle + this.defaultWindBearing));
                    this.growBlast(i, j, (SpeedWithBearing)blastSpeedWithBearing);
                } else if (this.speedWithBearing[i][j] == null) {
                    this.speedWithBearing[i][j] = this.defaultSpeedWithBearing;
                }
                ++j;
            }
            ++i;
        }
    }

    private void growBlast(int rowIndex, int colIndex, SpeedWithBearing blastSpeedWithBearing) {
        if (this.speedWithBearing[rowIndex][colIndex] != null) {
            return;
        }
        int blastSize = (int)Math.min((double)this.getBlastSize(), this.windParameters.maxBlastSize);
        logger.fine("Blast Size:" + blastSize);
        int nrow = this.timeUnits;
        int ncol = this.boundary.getResX() + 2 * this.boundary.getBorderX();
        int hSpanStart = Math.max(0, colIndex - blastSize / 2);
        int hSpanEnd = Math.min(colIndex + blastSize - blastSize / 2, ncol - 1);
        int vSpan = Math.min(rowIndex + blastSize, nrow - 1);
        int i = rowIndex;
        while (i <= vSpan) {
            int j = hSpanStart;
            while (j <= hSpanEnd) {
                this.speedWithBearing[i][j] = blastSpeedWithBearing;
                ++j;
            }
            ++i;
        }
        if (hSpanEnd - hSpanStart > 1) {
            i = rowIndex;
            while (i <= vSpan) {
                this.speedWithBearing[i][hSpanStart] = this.isBlastCell() ? blastSpeedWithBearing : this.defaultSpeedWithBearing;
                this.speedWithBearing[i][hSpanEnd] = this.isBlastCell() ? blastSpeedWithBearing : this.defaultSpeedWithBearing;
                ++i;
            }
            int j = hSpanStart + 1;
            while (j <= hSpanEnd - 1) {
                this.speedWithBearing[rowIndex][j] = this.isBlastCell() ? blastSpeedWithBearing : this.defaultSpeedWithBearing;
                this.speedWithBearing[vSpan][j] = this.isBlastCell() ? blastSpeedWithBearing : this.defaultSpeedWithBearing;
                ++j;
            }
        }
    }

    private boolean isBlastSeed() {
        return this.windParameters.getBlastRandomStreamManager().getRandomStream(BlastRandomSeedManagerImpl.BlastStream.SEED.name()).nextDouble() < this.windParameters.blastProbability / 100.0;
    }

    private boolean isBlastCell() {
        return this.windParameters.getBlastRandomStreamManager().getRandomStream(BlastRandomSeedManagerImpl.BlastStream.CELL.name()).nextDouble() > this.blastEdgeProbability / 100.0;
    }

    private double getBlastSpeed() {
        double bSpeedMean = this.windParameters.baseWindSpeed * (this.windParameters.blastWindSpeed / 100.0 - (this.defaultWindSpeed == 0.0 ? 1.0 : 0.0));
        double bSpeedVar = this.windParameters.baseWindSpeed * this.windParameters.blastWindSpeed / 100.0 * this.windParameters.blastWindSpeedVar / 100.0;
        BlastRandom speedStream = this.windParameters.getBlastRandomStreamManager().getRandomStream(BlastRandomSeedManagerImpl.BlastStream.SPEED.name());
        return Math.max(0.5 * bSpeedMean, Math.min(1.5 * bSpeedMean, speedStream.nextGaussian(bSpeedMean, bSpeedVar)));
    }

    private int getBlastSize() {
        BlastRandom sizeStream = this.windParameters.getBlastRandomStreamManager().getRandomStream(BlastRandomSeedManagerImpl.BlastStream.SIZE.name());
        return 1 + sizeStream.nextGeometric(this.blastSizeProbability / 100.0);
    }

    private double getBlastAngle() {
        BlastRandom bearingStream = this.windParameters.getBlastRandomStreamManager().getRandomStream(BlastRandomSeedManagerImpl.BlastStream.BEARING.name());
        return Math.max(-1.5 * this.blastBearingVar, Math.min(1.5 * this.blastBearingVar, bearingStream.nextGaussian(this.blastBearingMean, this.blastBearingVar)));
    }

    private SpeedWithBearing getSpeedWithBearing(TimedPosition timedPosition) {
        Position p = timedPosition.getPosition();
        Util.Pair<Integer, Integer> positionIndex = this.getPositionIndex(p);
        if (positionIndex != null) {
            int rowIndex = (Integer)positionIndex.getA() + this.boundary.getBorderY();
            int colIndex = (Integer)positionIndex.getB() + this.boundary.getBorderX();
            int timeIndex = 0;
            if (timedPosition.getTimePoint() != null) {
                timeIndex = this.getTimeIndex(timedPosition.getTimePoint());
            }
            return this.speedWithBearing[(rowIndex + timeIndex) % this.timeUnits][colIndex];
        }
        logger.severe("Error finding position " + p);
        return null;
    }

    @Override
    public Wind getWind(TimedPosition timedPosition) {
        return new WindImpl(timedPosition.getPosition(), timedPosition.getTimePoint(), this.getSpeedWithBearing(timedPosition));
    }

    public void setDefaultWindSpeed(double speed) {
        this.defaultWindSpeed = speed;
    }

    public double getDefaultWindSpeed() {
        return this.defaultWindSpeed;
    }

    public void setDefaultWindBearing(double bearing) {
        this.defaultWindBearing = bearing;
    }

    public double getDefaultWindBearing() {
        return this.defaultWindBearing;
    }
}

