/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.impl;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.SharedDomainFactory;
import com.sap.sailing.domain.base.impl.DynamicBoat;
import com.sap.sailing.domain.base.impl.DynamicCompetitor;
import com.sap.sailing.domain.base.impl.DynamicCompetitorWithBoat;
import com.sap.sailing.server.gateway.deserialization.impl.BoatJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.CompetitorJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.Helpers;
import com.sap.sse.common.Util;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import org.json.simple.JSONObject;

public class CompetitorAndBoatJsonDeserializer
implements JsonDeserializer<Util.Pair<DynamicCompetitor, Boat>> {
    private final JsonDeserializer<DynamicCompetitor> competitorDeserializer;
    private final JsonDeserializer<DynamicBoat> boatDeserializer;

    public static CompetitorAndBoatJsonDeserializer create(SharedDomainFactory<?> baseDomainFactory) {
        return new CompetitorAndBoatJsonDeserializer(CompetitorJsonDeserializer.create(baseDomainFactory), BoatJsonDeserializer.create(baseDomainFactory));
    }

    public CompetitorAndBoatJsonDeserializer(JsonDeserializer<DynamicCompetitor> competitorDeserializer, JsonDeserializer<DynamicBoat> boatDeserializer) {
        this.competitorDeserializer = competitorDeserializer;
        this.boatDeserializer = boatDeserializer;
    }

    public Util.Pair<DynamicCompetitor, Boat> deserialize(JSONObject competitorAndBoatJsonObject) throws JsonDeserializationException {
        DynamicBoat boat;
        DynamicCompetitor competitor;
        if (competitorAndBoatJsonObject.containsKey((Object)"competitor")) {
            competitor = (DynamicCompetitor)this.competitorDeserializer.deserialize(Helpers.getNestedObjectSafe(competitorAndBoatJsonObject, "competitor"));
            boat = (Boat)this.boatDeserializer.deserialize(Helpers.getNestedObjectSafe(competitorAndBoatJsonObject, "boat"));
        } else {
            DynamicCompetitorWithBoat competitorWithBoat = (DynamicCompetitorWithBoat)this.competitorDeserializer.deserialize(competitorAndBoatJsonObject);
            competitor = competitorWithBoat;
            boat = competitorWithBoat.getBoat();
        }
        return new Util.Pair((Object)competitor, (Object)boat);
    }
}

