/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.race.state.racingprocedure.ess.impl;

import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.FinishingTimeFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogResolver;
import com.sap.sailing.domain.abstractlog.race.state.RaceStateEvent;
import com.sap.sailing.domain.abstractlog.race.state.impl.RaceStateEventImpl;
import com.sap.sailing.domain.abstractlog.race.state.impl.RaceStateEvents;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.FlagPoleState;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.RacingProcedureChangedListener;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.RacingProcedurePrerequisite;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.ess.ESSChangedListener;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.ess.ESSRacingProcedure;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.ess.impl.ESSChangedListeners;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.impl.BaseRacingProcedure;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.impl.NoMorePrerequisite;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.impl.RacingProcedureChangedListeners;
import com.sap.sailing.domain.base.configuration.procedures.ESSConfiguration;
import com.sap.sailing.domain.common.racelog.FlagPole;
import com.sap.sailing.domain.common.racelog.Flags;
import com.sap.sailing.domain.common.racelog.RacingProcedureType;
import com.sap.sse.common.TimePoint;
import java.util.Arrays;
import java.util.Collections;

public class ESSRacingProcedureImpl
extends BaseRacingProcedure
implements ESSRacingProcedure {
    private static final long startPhaseAPDownInterval = 240000L;
    private static final long startPhaseESSThreeUpInterval = 180000L;
    private static final long startPhaseESSTwoUpInterval = 120000L;
    private static final long startPhaseESSOneUpInterval = 60000L;
    private final ESSConfiguration configuration;

    public ESSRacingProcedureImpl(RaceLog raceLog, AbstractLogEventAuthor author, ESSConfiguration configuration, RaceLogResolver raceLogResolver) {
        super(raceLog, author, configuration, raceLogResolver);
        this.configuration = configuration;
        this.update();
    }

    @Override
    public RacingProcedureType getType() {
        return RacingProcedureType.ESS;
    }

    @Override
    public RacingProcedurePrerequisite checkPrerequisitesForStart(TimePoint now, TimePoint startTime, RacingProcedurePrerequisite.FulfillmentFunction function) {
        return new NoMorePrerequisite(function);
    }

    @Override
    public boolean isStartphaseActive(TimePoint startTime, TimePoint now) {
        if (now.before(startTime)) {
            long timeTillStart = startTime.minus(now.asMillis()).asMillis();
            return timeTillStart < 240000L;
        }
        return false;
    }

    @Override
    public Iterable<RaceStateEvent> createStartStateEvents(TimePoint startTime) {
        return Arrays.asList(new RaceStateEventImpl(startTime.minus(240000L), RaceStateEvents.ESS_AP_DOWN), new RaceStateEventImpl(startTime.minus(180000L), RaceStateEvents.ESS_THREE_UP), new RaceStateEventImpl(startTime.minus(120000L), RaceStateEvents.ESS_TWO_UP), new RaceStateEventImpl(startTime.minus(60000L), RaceStateEvents.ESS_ONE_UP), new RaceStateEventImpl(startTime, RaceStateEvents.START));
    }

    @Override
    public boolean processStateEvent(RaceStateEvent event) {
        switch (event.getEventName()) {
            case ESS_AP_DOWN: 
            case ESS_THREE_UP: 
            case ESS_TWO_UP: 
            case ESS_ONE_UP: {
                this.getChangedListeners().onActiveFlagsChanged(this);
                return true;
            }
        }
        return super.processStateEvent(event);
    }

    @Override
    public FlagPoleState getActiveFlags(TimePoint startTime, TimePoint now) {
        if (now.before(startTime.minus(240000L))) {
            return new FlagPoleState(Arrays.asList(new FlagPole(Flags.AP, true), new FlagPole(Flags.ESSTHREE, false)), null, Arrays.asList(new FlagPole(Flags.AP, false), new FlagPole(Flags.ESSTHREE, false)), startTime.minus(240000L));
        }
        if (now.before(startTime.minus(180000L))) {
            return new FlagPoleState(Arrays.asList(new FlagPole(Flags.AP, false), new FlagPole(Flags.ESSTHREE, false)), startTime.minus(240000L), Arrays.asList(new FlagPole(Flags.ESSTHREE, true), new FlagPole(Flags.ESSTWO, false)), startTime.minus(180000L));
        }
        if (now.before(startTime.minus(120000L))) {
            return new FlagPoleState(Arrays.asList(new FlagPole(Flags.ESSTHREE, true), new FlagPole(Flags.ESSTWO, false)), startTime.minus(180000L), Arrays.asList(new FlagPole(Flags.ESSTWO, true), new FlagPole(Flags.ESSONE, false)), startTime.minus(120000L));
        }
        if (now.before(startTime.minus(60000L))) {
            return new FlagPoleState(Arrays.asList(new FlagPole(Flags.ESSTWO, true), new FlagPole(Flags.ESSONE, false)), startTime.minus(120000L), Arrays.asList(new FlagPole(Flags.ESSONE, true)), startTime.minus(60000L));
        }
        if (now.before(startTime)) {
            return new FlagPoleState(Arrays.asList(new FlagPole(Flags.ESSONE, true)), startTime.minus(60000L), Arrays.asList(new FlagPole(Flags.ESSONE, false)), startTime);
        }
        if (this.isIndividualRecallDisplayed(now)) {
            return new FlagPoleState(Arrays.asList(new FlagPole(Flags.XRAY, true)), this.getIndividualRecallDisplayedTime(), Arrays.asList(new FlagPole(Flags.XRAY, false)), this.getIndividualRecallRemovalTime());
        }
        if (this.isFinished(now)) {
            return new FlagPoleState(Arrays.asList(new FlagPole(Flags.BLUE, false)), this.getFinishedTime());
        }
        if (this.isInFinishingPhase(now)) {
            return new FlagPoleState(Arrays.asList(new FlagPole(Flags.BLUE, true)), this.getFinishingTime(), Arrays.asList(new FlagPole(Flags.BLUE, false)), null);
        }
        TimePoint recallRemoved = this.getIndividualRecallRemovalTime();
        return new FlagPoleState(Collections.emptyList(), recallRemoved == null ? startTime : recallRemoved);
    }

    @Override
    protected RacingProcedureChangedListeners<? extends RacingProcedureChangedListener> createChangedListenerContainer() {
        return new ESSChangedListeners();
    }

    protected ESSChangedListeners getChangedListeners() {
        return (ESSChangedListeners)super.getChangedListeners();
    }

    @Override
    public void addChangedListener(ESSChangedListener listener) {
        this.getChangedListeners().add(listener);
    }

    @Override
    public TimePoint getTimeLimit(TimePoint startTime) {
        TimePoint firstBoatTime = (TimePoint)new FinishingTimeFinder(this.raceLog).analyze();
        if (firstBoatTime != null) {
            return firstBoatTime.plus((long)((double)(firstBoatTime.asMillis() - startTime.asMillis()) * 0.75));
        }
        return null;
    }

    @Override
    protected boolean hasIndividualRecallByDefault() {
        return true;
    }

    @Override
    protected Boolean isResultEntryEnabledByDefault() {
        return true;
    }

    @Override
    public ESSConfiguration getConfiguration() {
        return (ESSConfiguration)super.getConfiguration();
    }
}

