/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.race.impl;

import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.race.RaceLogEventVisitor;
import com.sap.sailing.domain.abstractlog.race.RaceLogTagEvent;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogEventImpl;
import com.sap.sse.common.TimePoint;
import java.io.Serializable;

public class RaceLogTagEventImpl
extends RaceLogEventImpl
implements RaceLogTagEvent {
    private static final long serialVersionUID = 7213518902555323432L;
    private final String tag;
    private final String comment;
    private final String username;
    private final String imageURL;
    private final String resizedImageURL;
    private final String hiddenInfo;
    private TimePoint revokedAt;

    public RaceLogTagEventImpl(String tag, String comment, String hiddenInfo, String imageURL, String resizedImageURL, TimePoint createdAt, TimePoint logicalTimePoint, AbstractLogEventAuthor author, Serializable id, int passId) {
        super(createdAt, logicalTimePoint, author, id, passId);
        this.tag = tag;
        this.comment = comment;
        this.hiddenInfo = hiddenInfo;
        this.imageURL = imageURL;
        this.resizedImageURL = resizedImageURL;
        this.username = author.getName();
        this.revokedAt = null;
    }

    public RaceLogTagEventImpl(String tag, String comment, String hiddenInfo, String imageURL, String resizedImageURL, TimePoint createdAt, TimePoint logicalTimePoint, AbstractLogEventAuthor author, int passId) {
        this(tag, comment, hiddenInfo, imageURL, resizedImageURL, createdAt, logicalTimePoint, author, RaceLogTagEventImpl.randId(), passId);
    }

    public RaceLogTagEventImpl(String tag, String comment, String hiddenInfo, String imageURL, String resizedImageURL, TimePoint logicalTimePoint, AbstractLogEventAuthor author, int passId) {
        this(tag, comment, hiddenInfo, imageURL, resizedImageURL, RaceLogTagEventImpl.now(), logicalTimePoint, author, RaceLogTagEventImpl.randId(), passId);
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public String getHiddenInfo() {
        return this.hiddenInfo;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void markAsRevoked(TimePoint revokedAt) {
        if (this.revokedAt == null && revokedAt != null) {
            this.revokedAt = revokedAt;
        }
    }

    @Override
    public TimePoint getRevokedAt() {
        return this.revokedAt;
    }

    @Override
    public void accept(RaceLogEventVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String getShortInfo() {
        return "tag=" + this.tag + ", comment=" + this.comment + ", hiddenInfo=" + this.hiddenInfo;
    }

    public int hashCode() {
        return 0x3FF ^ (this.comment == null ? 0 : this.comment.hashCode()) ^ (this.hiddenInfo == null ? 0 : this.hiddenInfo.hashCode()) ^ (this.imageURL == null ? 0 : this.imageURL.hashCode()) ^ (this.resizedImageURL == null ? 0 : this.resizedImageURL.hashCode()) ^ (this.tag == null ? 0 : this.tag.hashCode()) ^ (this.username == null ? 0 : this.username.hashCode()) ^ (this.getLogicalTimePoint() == null ? 0 : this.getLogicalTimePoint().hashCode()) ^ (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RaceLogTagEventImpl other = (RaceLogTagEventImpl)obj;
        if (this.comment == null ? other.comment != null : !this.comment.equals(other.comment)) {
            return false;
        }
        if (this.hiddenInfo == null ? other.hiddenInfo != null : !this.hiddenInfo.equals(other.hiddenInfo)) {
            return false;
        }
        if (this.imageURL == null ? other.imageURL != null : !this.imageURL.equals(other.imageURL)) {
            return false;
        }
        if (this.resizedImageURL == null ? other.resizedImageURL != null : !this.resizedImageURL.equals(other.resizedImageURL)) {
            return false;
        }
        if (this.tag == null ? other.tag != null : !this.tag.equals(other.tag)) {
            return false;
        }
        if (this.username == null ? other.username != null : !this.username.equals(other.username)) {
            return false;
        }
        return !(this.getLogicalTimePoint() == null ? other.getLogicalTimePoint() != null : !this.getLogicalTimePoint().equals(other.getLogicalTimePoint()));
    }

    @Override
    public String toString() {
        return "RaceLogTagEvent [tag=" + this.tag + ", comment=" + this.comment + ", hiddenInfo=" + this.hiddenInfo + ", imageURL=" + this.imageURL + ", resizedImageURL=" + this.resizedImageURL + ", username=" + this.username + ", revokedAt=" + this.revokedAt + "]";
    }

    @Override
    public String getImageURL() {
        return this.imageURL;
    }

    @Override
    public String getResizedImageURL() {
        return this.resizedImageURL;
    }
}

