/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.monitoring;

import com.sap.sailing.monitoring.Endpoint;
import java.net.InetSocketAddress;
import java.net.URL;

public class EndpointImpl
implements Endpoint {
    private InetSocketAddress address;
    private String name = "";
    private URL url;
    private boolean is_url = false;
    private long last_success = 0L;
    private long last_fail = 0L;
    private boolean already_checked = false;

    public EndpointImpl(InetSocketAddress address) {
        this.address = address;
        this.is_url = false;
        this.url = null;
    }

    public EndpointImpl(URL input) {
        this.address = null;
        this.is_url = true;
        this.url = input;
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Override
    public long lastSucceeded() {
        return this.last_success;
    }

    @Override
    public long lastFailed() {
        return this.last_fail;
    }

    @Override
    public boolean alreadyChecked() {
        return this.already_checked;
    }

    @Override
    public boolean hasFailed() {
        return this.last_fail > this.last_success;
    }

    @Override
    public void setSuccess(long millis) {
        this.last_success = millis;
        this.already_checked = true;
    }

    @Override
    public void setFailure(long millis) {
        this.last_fail = millis;
    }

    @Override
    public String toString() {
        return this.isURL() ? this.getURL().toString() : this.getAddress().toString();
    }

    @Override
    public String getBundleName() {
        return this.name;
    }

    @Override
    public void setBundleName(String name) {
        this.name = name;
    }

    @Override
    public boolean isURL() {
        return this.is_url;
    }

    @Override
    public URL getURL() {
        return this.url;
    }
}

