/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.news.impl;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.EventBase;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.leaderboard.SettableScoreCorrection;
import com.sap.sailing.news.EventNewsItem;
import com.sap.sailing.news.EventNewsProvider;
import com.sap.sailing.news.impl.LeaderboardUpdateNewsItem;
import com.sap.sse.common.TimePoint;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

public class LeaderboardUpdateEventNewsProvider
implements EventNewsProvider {
    private static final int LIMIT = 10;

    @Override
    public Collection<? extends EventNewsItem> getNews(Event event) {
        LinkedList<LeaderboardUpdateNewsItem> result = new LinkedList<LeaderboardUpdateNewsItem>();
        Iterable leaderboardGroups = event.getLeaderboardGroups();
        for (LeaderboardGroup leaderboardGroup : leaderboardGroups) {
            for (Leaderboard leaderboard : leaderboardGroup.getLeaderboards()) {
                BoatClass boatClass;
                TimePoint timePointOfLatestModification;
                SettableScoreCorrection scoreCorrection;
                if (!leaderboard.isPartOfEvent((EventBase)event) || (scoreCorrection = leaderboard.getScoreCorrection()) == null || (timePointOfLatestModification = scoreCorrection.getTimePointOfLastCorrectionsValidity()) == null) continue;
                String displayName = leaderboard.getDisplayName() != null ? leaderboard.getDisplayName() : leaderboard.getName();
                String boatClassName = null;
                if (leaderboard instanceof RegattaLeaderboard && (boatClass = ((RegattaLeaderboard)leaderboard).getRegatta().getBoatClass()) != null) {
                    boatClassName = boatClass.getName();
                }
                result.add(new LeaderboardUpdateNewsItem(event.getId(), timePointOfLatestModification.asDate(), leaderboard.getName(), displayName, boatClassName));
            }
        }
        Collections.sort(result);
        return result.subList(0, Math.min(10, result.size()));
    }
}

