/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.Leg;
import com.sap.sailing.domain.base.SpeedWithBearingWithConfidence;
import com.sap.sailing.domain.base.SpeedWithConfidence;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Tack;
import com.sap.sailing.domain.common.TargetTimeInfo;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.domain.common.impl.TargetTimeInfoImpl;
import com.sap.sailing.domain.common.polars.NotEnoughDataHasBeenAddedException;
import com.sap.sailing.domain.confidence.ConfidenceBasedWindAverager;
import com.sap.sailing.domain.confidence.ConfidenceFactory;
import com.sap.sailing.domain.leaderboard.caching.LeaderboardDTOCalculationReuseCache;
import com.sap.sailing.domain.polars.PolarDataService;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.MarkPositionAtTimePointCache;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sailing.domain.tracking.TrackedRaceStatus;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sailing.domain.tracking.WindPositionMode;
import com.sap.sailing.domain.tracking.WindWithConfidence;
import com.sap.sailing.domain.tracking.impl.AbstractRaceChangeListener;
import com.sap.sailing.domain.tracking.impl.DynamicTrackedRaceImpl;
import com.sap.sailing.domain.tracking.impl.MarkPositionAtTimePointCacheImpl;
import com.sap.sailing.domain.tracking.impl.NonCachingMarkPositionAtTimePointCache;
import com.sap.sailing.domain.tracking.impl.TrackedLegOfCompetitorImpl;
import com.sap.sailing.domain.tracking.impl.TrackedRaceImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Timed;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class TrackedLegImpl
implements TrackedLeg {
    private static final long serialVersionUID = -1944668527284130545L;
    private static final Logger logger = Logger.getLogger(TrackedLegImpl.class.getName());
    private final Leg leg;
    private final Map<Competitor, TrackedLegOfCompetitor> trackedLegsOfCompetitors;
    private TrackedRaceImpl trackedRace;
    private transient ConcurrentMap<TimePoint, List<TrackedLegOfCompetitor>> competitorTracksOrderedByRank;

    public TrackedLegImpl(DynamicTrackedRaceImpl trackedRace, Leg leg, Iterable<Competitor> competitors) {
        this.leg = leg;
        this.trackedRace = trackedRace;
        this.trackedLegsOfCompetitors = new HashMap<Competitor, TrackedLegOfCompetitor>();
        for (Competitor competitor : competitors) {
            this.trackedLegsOfCompetitors.put(competitor, new TrackedLegOfCompetitorImpl(this, competitor, trackedRace.getBoatOfCompetitor(competitor)));
        }
        trackedRace.addListener(new CacheClearingRaceChangeListener());
        this.competitorTracksOrderedByRank = new ConcurrentHashMap<TimePoint, List<TrackedLegOfCompetitor>>();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.competitorTracksOrderedByRank = new ConcurrentHashMap<TimePoint, List<TrackedLegOfCompetitor>>();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        Course course = this.trackedRace.getRace().getCourse();
        course.lockForRead();
        try {
            oos.defaultWriteObject();
        }
        finally {
            course.unlockAfterRead();
        }
    }

    @Override
    public Leg getLeg() {
        return this.leg;
    }

    @Override
    public TrackedRaceImpl getTrackedRace() {
        return this.trackedRace;
    }

    @Override
    public Iterable<TrackedLegOfCompetitor> getTrackedLegsOfCompetitors() {
        return this.trackedLegsOfCompetitors.values();
    }

    @Override
    public TrackedLegOfCompetitor getTrackedLeg(Competitor competitor) {
        return this.trackedLegsOfCompetitors.get(competitor);
    }

    @Override
    public Competitor getLeader(TimePoint timePoint) {
        List<TrackedLegOfCompetitor> byRank = this.getCompetitorTracksOrderedByRank(timePoint);
        return byRank.get(0).getCompetitor();
    }

    @Override
    public Competitor getLeader(TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        List<TrackedLegOfCompetitor> byRank = this.getCompetitorTracksOrderedByRank(timePoint, cache);
        return byRank.get(0).getCompetitor();
    }

    protected List<TrackedLegOfCompetitor> getCompetitorTracksOrderedByRank(TimePoint timePoint) {
        return this.getCompetitorTracksOrderedByRank(timePoint, new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    List<TrackedLegOfCompetitor> getCompetitorTracksOrderedByRank(TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        List rankedCompetitorList = (ArrayList<TrackedLegOfCompetitor>)this.competitorTracksOrderedByRank.get(timePoint);
        if (rankedCompetitorList != null) {
            rankedCompetitorList = new ArrayList<TrackedLegOfCompetitor>(rankedCompetitorList);
        }
        if (rankedCompetitorList == null) {
            rankedCompetitorList = new ArrayList();
            for (TrackedLegOfCompetitor competitorLeg : this.getTrackedLegsOfCompetitors()) {
                rankedCompetitorList.add(competitorLeg);
            }
            Collections.sort(rankedCompetitorList, this.getTrackedRace().getRankingMetric().getLegRankingComparator(this, timePoint, cache));
            rankedCompetitorList = Collections.unmodifiableList(rankedCompetitorList);
            this.competitorTracksOrderedByRank.put(timePoint, rankedCompetitorList);
            if (Util.size(this.getTrackedLegsOfCompetitors()) != rankedCompetitorList.size()) {
                logger.warning("Number of competitors in leg (" + Util.size(this.getTrackedLegsOfCompetitors()) + ") differs from number of competitors in race (" + Util.size(this.getTrackedRace().getRace().getCompetitors()) + ")");
            }
        }
        return rankedCompetitorList;
    }

    @Override
    public LinkedHashMap<Competitor, Integer> getRanks(TimePoint timePoint) {
        return this.getRanks(timePoint, new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    @Override
    public LinkedHashMap<Competitor, Integer> getRanks(TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        List<TrackedLegOfCompetitor> orderedTrackedLegsOfCompetitors = this.getCompetitorTracksOrderedByRank(timePoint, cache);
        LinkedHashMap<Competitor, Integer> result = new LinkedHashMap<Competitor, Integer>();
        int i = 1;
        for (TrackedLegOfCompetitor tloc : orderedTrackedLegsOfCompetitors) {
            result.put(tloc.getCompetitor(), i++);
        }
        return result;
    }

    @Override
    public Bearing getTWA(TimePoint at) throws NoWindException {
        Wind wind = this.getWindOnLeg(at);
        if (wind == null) {
            throw new NoWindException("Need to know wind direction in race " + this.getTrackedRace().getRace().getName() + " to determine whether leg " + this.getLeg() + " is an upwind or downwind leg");
        }
        Bearing legBearing = this.getLegBearing(at);
        Bearing result = legBearing != null ? legBearing.getDifferenceTo(wind.getFrom()) : null;
        return result;
    }

    @Override
    public LegType getLegType(TimePoint at) throws NoWindException {
        Bearing twa = this.getTWA(at);
        if (twa != null) {
            double deltaDeg = twa.getDegrees();
            if (Math.abs(deltaDeg) < LegType.UPWIND_DOWNWIND_TOLERANCE_IN_DEG) {
                return LegType.UPWIND;
            }
            double deltaDegOpposite = twa.getDifferenceTo((Bearing)new DegreeBearingImpl(180.0)).getDegrees();
            if (Math.abs(deltaDegOpposite) < LegType.UPWIND_DOWNWIND_TOLERANCE_IN_DEG) {
                return LegType.DOWNWIND;
            }
        }
        return LegType.REACHING;
    }

    @Override
    public Bearing getLegBearing(TimePoint at) {
        return this.getLegBearing(at, new MarkPositionAtTimePointCacheImpl(this.getTrackedRace(), at));
    }

    @Override
    public Bearing getLegBearing(TimePoint at, MarkPositionAtTimePointCache markPositionCache) {
        assert (markPositionCache.getTimePoint().equals(at));
        assert (markPositionCache.getTrackedRace() == this.getTrackedRace());
        Position startMarkPos = markPositionCache.getApproximatePosition(this.getLeg().getFrom());
        Position endMarkPos = markPositionCache.getApproximatePosition(this.getLeg().getTo());
        Bearing legBearing = startMarkPos != null && endMarkPos != null ? startMarkPos.getBearingGreatCircle(endMarkPos) : null;
        return legBearing;
    }

    @Override
    public boolean isUpOrDownwindLeg(TimePoint at) throws NoWindException {
        return this.getLegType(at) != LegType.REACHING;
    }

    private Wind getWindOnLeg(TimePoint at) {
        Wind wind;
        Position middleOfLeg = this.getMiddleOfLeg(at);
        if (middleOfLeg == null) {
            wind = null;
        } else {
            HashSet<WindSource> windSourcesToExclude = new HashSet<WindSource>(this.getTrackedRace().getWindSourcesToExclude());
            windSourcesToExclude.addAll(this.getTrackedRace().getWindSources(WindSourceType.TRACK_BASED_ESTIMATION));
            wind = this.getWind(middleOfLeg, at, windSourcesToExclude);
        }
        return wind;
    }

    @Override
    public Position getMiddleOfLeg(TimePoint at) {
        return this.getMiddleOfLeg(at, new MarkPositionAtTimePointCacheImpl(this.getTrackedRace(), at));
    }

    @Override
    public Position getMiddleOfLeg(TimePoint at, MarkPositionAtTimePointCache cache) {
        Position approximateLegStartPosition = this.getTrackedRace().getApproximatePosition(this.getLeg().getFrom(), at, cache);
        Position approximateLegEndPosition = this.getTrackedRace().getApproximatePosition(this.getLeg().getTo(), at, cache);
        Position middleOfLeg = approximateLegStartPosition == null || approximateLegEndPosition == null ? null : approximateLegStartPosition.translateGreatCircle(approximateLegStartPosition.getBearingGreatCircle(approximateLegEndPosition), approximateLegStartPosition.getDistance(approximateLegEndPosition).scale(0.5));
        return middleOfLeg;
    }

    @Override
    public Iterable<Position> getEquidistantSectionsOfLeg(TimePoint at, int numberOfPositions) {
        Optional<Position> approximateLegStartPosition = Optional.ofNullable(this.getTrackedRace().getApproximatePosition(this.getLeg().getFrom(), at));
        Optional<Position> approximateLegEndPosition = Optional.ofNullable(this.getTrackedRace().getApproximatePosition(this.getLeg().getTo(), at));
        List<Position> result = approximateLegStartPosition.map(legStart -> approximateLegEndPosition.map(legEnd -> {
            Bearing bearing = legStart.getBearingGreatCircle(legEnd);
            Distance segmentDistance = legStart.getDistance(legEnd).scale(1.0 / (double)(numberOfPositions - 1));
            ArrayList<Position> positions = new ArrayList<Position>();
            Position position2 = legStart;
            int i = 0;
            while (i < numberOfPositions) {
                positions.add(position2);
                position2 = position2.translateGreatCircle(bearing, segmentDistance);
                ++i;
            }
            return positions;
        }).orElse(Collections.emptyList())).orElse(Collections.emptyList());
        return result;
    }

    @Override
    public WindWithConfidence<Util.Pair<Position, TimePoint>> getAverageWind(int numParts) {
        ConfidenceBasedWindAverager<Object> timeWeigher = ConfidenceFactory.INSTANCE.createWindAverager(null);
        Iterable<TimePoint> referenceTimePoints = this.getEquidistantReferenceTimePoints(numParts);
        Iterable winds = Util.stream(referenceTimePoints).flatMap(timepoint -> Util.stream(this.getEquidistantSectionsOfLeg((TimePoint)timepoint, numParts)).map(p -> this.getTrackedRace().getWindWithConfidence((Position)p, (TimePoint)timepoint))).collect(Collectors.toList());
        return timeWeigher.getAverage(winds, null);
    }

    public Position getEffectiveWindPosition(Callable<Position> exactPositionProvider, TimePoint at, WindPositionMode mode) {
        Position effectivePosition;
        switch (mode) {
            case EXACT: {
                try {
                    effectivePosition = exactPositionProvider.call();
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            case LEG_MIDDLE: {
                effectivePosition = this.getMiddleOfLeg(at);
                break;
            }
            case GLOBAL_AVERAGE: {
                effectivePosition = null;
                break;
            }
            default: {
                effectivePosition = null;
                logger.info("Strange: don't know WindPositionMode literal " + mode.name());
            }
        }
        return effectivePosition;
    }

    private Wind getWind(Position p, TimePoint at, Set<WindSource> windSourcesToExclude) {
        return this.getTrackedRace().getWind(p, at, windSourcesToExclude);
    }

    private void clearCaches() {
        this.competitorTracksOrderedByRank.clear();
    }

    @Override
    public void waypointsMayHaveChanges() {
        this.clearCaches();
    }

    @Override
    public Distance getAbsoluteCrossTrackError(Position p, TimePoint timePoint) {
        Position approximateLegFromPosition = this.getTrackedRace().getApproximatePosition(this.getLeg().getFrom(), timePoint);
        Bearing legBearing = this.getLegBearing(timePoint);
        return approximateLegFromPosition == null || legBearing == null ? null : p.absoluteCrossTrackError(approximateLegFromPosition, legBearing);
    }

    @Override
    public Distance getSignedCrossTrackError(Position p, TimePoint timePoint) {
        Position approximateLegFromPosition = this.getTrackedRace().getApproximatePosition(this.getLeg().getFrom(), timePoint);
        Bearing legBearing = this.getLegBearing(timePoint);
        return approximateLegFromPosition == null || legBearing == null ? null : p.crossTrackError(approximateLegFromPosition, legBearing);
    }

    @Override
    public Distance getUnsignedCrossTrackErrorToWindAxis(Position p, TimePoint timePoint) {
        Position approximateLegToPosition = this.getTrackedRace().getApproximatePosition(this.getLeg().getTo(), timePoint);
        Bearing windAxis = this.getWind(p, timePoint, this.getTrackedRace().getWindSourcesToExclude()).getFrom();
        return approximateLegToPosition == null || windAxis == null ? null : p.absoluteCrossTrackError(approximateLegToPosition, windAxis);
    }

    @Override
    public Distance getSignedCrossTrackErrorToWindAxis(Position p, TimePoint timePoint) {
        Position approximateLegToPosition = this.getTrackedRace().getApproximatePosition(this.getLeg().getTo(), timePoint);
        Wind wind = this.getWind(p, timePoint, this.getTrackedRace().getWindSourcesToExclude());
        try {
            return approximateLegToPosition == null || wind == null ? null : p.crossTrackError(approximateLegToPosition, this.getTWA(timePoint).abs().compareTo((Object)new DegreeBearingImpl(90.0)) < 0 ? wind.getFrom() : wind.getBearing());
        }
        catch (NoWindException e) {
            throw new RuntimeException("This shouldn't have happened; we failed computing the leg's TWA although we successfully computed a wind direction", e);
        }
    }

    @Override
    public Distance getGreatCircleDistance(TimePoint timePoint, MarkPositionAtTimePointCache markPositionCache) {
        assert (markPositionCache.getTimePoint().equals(timePoint));
        assert (markPositionCache.getTrackedRace() == this.getTrackedRace());
        Position approximatePositionOfFrom = markPositionCache.getApproximatePosition(this.getLeg().getFrom());
        Position approximatePositionOfTo = markPositionCache.getApproximatePosition(this.getLeg().getTo());
        Distance result = approximatePositionOfFrom != null && approximatePositionOfTo != null ? approximatePositionOfFrom.getDistance(approximatePositionOfTo) : null;
        return result;
    }

    @Override
    public Distance getGreatCircleDistance(TimePoint timePoint) {
        return this.getGreatCircleDistance(timePoint, new NonCachingMarkPositionAtTimePointCache(this.getTrackedRace(), timePoint));
    }

    @Override
    public Distance getAbsoluteWindwardDistance(Position pos1, Position pos2, TimePoint at, WindPositionMode windPositionMode) {
        return this.getAbsoluteWindwardDistance(pos1, pos2, at, windPositionMode, new LeaderboardDTOCalculationReuseCache(at));
    }

    @Override
    public Distance getAbsoluteWindwardDistance(Position pos1, Position pos2, TimePoint at, WindPositionMode windPositionMode, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Distance preResult = this.getWindwardDistance(pos1, pos2, at, windPositionMode, cache);
        Object result = preResult == null || preResult.getMeters() >= 0.0 ? preResult : new MeterDistance(-preResult.getMeters());
        return result;
    }

    @Override
    public Distance getAbsoluteWindwardDistanceFromLegStart(Position pos) {
        TimePoint referenceTimePoint = this.getReferenceTimePoint();
        return this.getAbsoluteWindwardDistanceFromLegStart(pos, referenceTimePoint, new LeaderboardDTOCalculationReuseCache(referenceTimePoint));
    }

    @Override
    public Distance getWindwardDistanceFromLegStart(Position pos, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return this.getWindwardDistanceFromLegStart(null, pos, cache);
    }

    @Override
    public Distance getWindwardDistanceFromLegStart(LegType legType, Position pos, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        TimePoint referenceTimePoint = this.getReferenceTimePoint();
        return this.getWindwardDistanceFromLegStart(legType, pos, referenceTimePoint, cache);
    }

    private Distance getWindwardDistanceFromLegStart(LegType legType, Position pos, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return this.getWindwardDistance(legType, this.getTrackedRace().getApproximatePosition(this.getLeg().getFrom(), timePoint), pos, timePoint, WindPositionMode.LEG_MIDDLE, cache);
    }

    @Override
    public Distance getAbsoluteWindwardDistanceFromLegStart(Position pos, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        TimePoint referenceTimePoint = this.getReferenceTimePoint();
        return this.getAbsoluteWindwardDistanceFromLegStart(pos, referenceTimePoint, cache);
    }

    private Distance getAbsoluteWindwardDistanceFromLegStart(Position pos, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return this.getAbsoluteWindwardDistance(this.getTrackedRace().getApproximatePosition(this.getLeg().getFrom(), timePoint), pos, timePoint, WindPositionMode.LEG_MIDDLE, cache);
    }

    @Override
    public Distance getWindwardDistance(Position pos1, Position pos2, TimePoint at, WindPositionMode windPositionMode) {
        return this.getWindwardDistance(pos1, pos2, at, windPositionMode, new LeaderboardDTOCalculationReuseCache(at));
    }

    @Override
    public Distance getWindwardDistance() {
        return this.getWindwardDistance(this.getReferenceTimePoint());
    }

    private Distance getWindwardDistance(TimePoint timePoint) {
        return this.getWindwardDistance(timePoint, (WindLegTypeAndLegBearingAndORCPerformanceCurveCache)new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    @Override
    public Distance getWindwardDistance(WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return this.getWindwardDistance((LegType)null, cache);
    }

    @Override
    public Distance getWindwardDistance(LegType legType, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        TimePoint middle = this.getReferenceTimePoint();
        return this.getWindwardDistance(legType, middle, cache);
    }

    @Override
    public Distance getAbsoluteWindwardDistance(WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        TimePoint middle = this.getReferenceTimePoint();
        return this.getAbsoluteWindwardDistance(middle, cache);
    }

    @Override
    public TimePoint getReferenceTimePoint() {
        TimePoint lastLegFinishMarkPassingTimePoint;
        TimePoint firstLegStartMarkPassingTimePoint;
        Iterator i;
        Iterable legStartMarkPassings = this.getTrackedRace().getMarkPassingsInOrder(this.getLeg().getFrom());
        Iterable legFinishMarkPassings = this.getTrackedRace().getMarkPassingsInOrder(this.getLeg().getTo());
        this.getTrackedRace().lockForRead(legStartMarkPassings);
        try {
            i = legStartMarkPassings.iterator();
            firstLegStartMarkPassingTimePoint = i.hasNext() ? ((MarkPassing)i.next()).getTimePoint() : MillisecondsTimePoint.now();
        }
        finally {
            this.getTrackedRace().unlockAfterRead(legStartMarkPassings);
        }
        this.getTrackedRace().lockForRead(legFinishMarkPassings);
        try {
            i = legFinishMarkPassings.iterator();
            lastLegFinishMarkPassingTimePoint = i.hasNext() ? ((MarkPassing)i.next()).getTimePoint() : MillisecondsTimePoint.now();
        }
        finally {
            this.getTrackedRace().unlockAfterRead(legFinishMarkPassings);
        }
        TimePoint middle = firstLegStartMarkPassingTimePoint.plus(firstLegStartMarkPassingTimePoint.until(lastLegFinishMarkPassingTimePoint).divide(2L));
        return middle;
    }

    @Override
    public Iterable<TimePoint> getEquidistantReferenceTimePoints(int numberOfPoints) {
        Iterable legStartMarkPassings = this.getTrackedRace().getMarkPassingsInOrder(this.getLeg().getFrom());
        Iterable legFinishMarkPassings = this.getTrackedRace().getMarkPassingsInOrder(this.getLeg().getTo());
        this.getTrackedRace().lockForRead(legStartMarkPassings);
        this.getTrackedRace().lockForRead(legFinishMarkPassings);
        try {
            TimePoint firstLegStartMarkPassingTimePoint = this.convertMarkPassingIteratorToTimePoint(legStartMarkPassings, Util::first);
            TimePoint lastLegFinishMarkPassingTimePoint = this.convertMarkPassingIteratorToTimePoint(legFinishMarkPassings, Util::last);
            Duration equidistantTime = firstLegStartMarkPassingTimePoint.until(lastLegFinishMarkPassingTimePoint).divide((long)numberOfPoints);
            ArrayList<TimePoint> timePoints = new ArrayList<TimePoint>(numberOfPoints);
            TimePoint accum = firstLegStartMarkPassingTimePoint;
            int i = 0;
            while (i < numberOfPoints) {
                timePoints.add(accum);
                accum = accum.plus(equidistantTime);
                ++i;
            }
            ArrayList<TimePoint> arrayList = timePoints;
            return arrayList;
        }
        finally {
            this.getTrackedRace().unlockAfterRead(legFinishMarkPassings);
            this.getTrackedRace().unlockAfterRead(legStartMarkPassings);
        }
    }

    private TimePoint convertMarkPassingIteratorToTimePoint(Iterable<MarkPassing> markPassings, Function<Iterable<MarkPassing>, MarkPassing> firstOrLast) {
        return Optional.ofNullable(firstOrLast.apply(markPassings)).map(Timed::getTimePoint).orElse(MillisecondsTimePoint.now());
    }

    @Override
    public Distance getWindwardDistance(TimePoint middle, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return this.getWindwardDistance(null, middle, cache);
    }

    @Override
    public Distance getWindwardDistance(LegType legType, TimePoint middle, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Position fromPos = cache.getApproximatePosition(this.getTrackedRace(), this.getLeg().getFrom(), middle);
        Position toPos = cache.getApproximatePosition(this.getTrackedRace(), this.getLeg().getTo(), middle);
        return this.getWindwardDistance(legType, fromPos, toPos, middle, WindPositionMode.LEG_MIDDLE, cache);
    }

    @Override
    public Distance getAbsoluteWindwardDistance(TimePoint middle, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Position fromPos = cache.getApproximatePosition(this.getTrackedRace(), this.getLeg().getFrom(), middle);
        Position toPos = cache.getApproximatePosition(this.getTrackedRace(), this.getLeg().getTo(), middle);
        return this.getAbsoluteWindwardDistance(fromPos, toPos, middle, WindPositionMode.LEG_MIDDLE, cache);
    }

    @Override
    public Distance getWindwardDistance(Position pos1, Position pos2, TimePoint at, WindPositionMode windPositionMode, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return this.getWindwardDistance(null, pos1, pos2, at, windPositionMode, cache);
    }

    public Distance getWindwardDistance(LegType legType, Position pos1, Position pos2, TimePoint at, WindPositionMode windPositionMode, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Distance result;
        if (pos1 == null || pos2 == null) {
            result = null;
        } else {
            LegType effectiveLegType;
            if (legType == null) {
                try {
                    effectiveLegType = cache.getLegType(this, at);
                }
                catch (NoWindException e) {
                    effectiveLegType = LegType.REACHING;
                }
            } else {
                effectiveLegType = legType;
            }
            if (effectiveLegType != LegType.REACHING) {
                Position effectivePosition = this.getEffectiveWindPosition(() -> pos1.translateGreatCircle(pos1.getBearingGreatCircle(pos2), pos1.getDistance(pos2).scale(0.5)), at, windPositionMode);
                Wind wind = this.getTrackedRace().getWind(effectivePosition, at);
                if (wind == null) {
                    result = pos2.alongTrackDistance(pos1, cache.getLegBearing(this, at));
                } else {
                    Position projectionToLineThroughPos2 = pos1.projectToLineThrough(pos2, wind.getBearing());
                    result = pos2.alongTrackDistance(projectionToLineThroughPos2, effectiveLegType == LegType.UPWIND ? wind.getFrom() : wind.getBearing());
                }
            } else {
                result = pos2.alongTrackDistance(pos1, cache.getLegBearing(this, at));
            }
        }
        return result;
    }

    @Override
    public TargetTimeInfo.LegTargetTimeInfo getEstimatedTimeAndDistanceToComplete(PolarDataService polarDataService, TimePoint timepoint, MarkPositionAtTimePointCache markPositionCache) throws NotEnoughDataHasBeenAddedException, NoWindException {
        Distance resultDistance;
        Duration result;
        assert (timepoint.equals(markPositionCache.getTimePoint()));
        assert (this.getTrackedRace() == markPositionCache.getTrackedRace());
        Position centralPosition = this.getMiddleOfLeg(timepoint);
        Wind wind = this.trackedRace.getWind(centralPosition, timepoint);
        Position from = this.trackedRace.getApproximatePosition(this.leg.getFrom(), timepoint);
        Position to = this.trackedRace.getApproximatePosition(this.leg.getTo(), timepoint);
        LegType legType = this.getLegType(timepoint);
        BoatClass boatClass = this.trackedRace.getRace().getBoatClass();
        Bearing legBearing = from.getBearingGreatCircle(to);
        Distance distance = from.getDistance(to);
        Bearing trueWindAngleToLeg = legBearing.getDifferenceTo(wind.getBearing().reverse());
        if (legType == LegType.REACHING) {
            SpeedWithConfidence<Void> reachSpeed = polarDataService.getSpeed(boatClass, (Speed)wind, trueWindAngleToLeg);
            result = ((Speed)reachSpeed.getObject()).getDuration(distance);
            resultDistance = distance;
        } else {
            SpeedWithBearingWithConfidence<Void> portSpeedAndTrueWindAngle = polarDataService.getAverageSpeedWithTrueWindAngle(boatClass, (Speed)wind, legType, Tack.PORT);
            SpeedWithBearingWithConfidence<Void> starboardSpeedAndTrueWindAngle = polarDataService.getAverageSpeedWithTrueWindAngle(boatClass, (Speed)wind, legType, Tack.STARBOARD);
            Util.Pair<Distance, Duration> estimationPair = this.estimateTargetTimeTacking(from, to, portSpeedAndTrueWindAngle, starboardSpeedAndTrueWindAngle, wind);
            result = (Duration)estimationPair.getB();
            resultDistance = (Distance)estimationPair.getA();
        }
        return new TargetTimeInfoImpl.LegTargetTimeInfoImpl(distance, wind, legBearing, result, timepoint, legType, resultDistance);
    }

    private Util.Pair<Distance, Duration> estimateTargetTimeTacking(Position from, Position to, SpeedWithBearingWithConfidence<Void> portSpeedAndTrueWindAngle, SpeedWithBearingWithConfidence<Void> starboardSpeedAndTrueWindAngle, Wind wind) {
        Bearing portCourseOverGround = portSpeedAndTrueWindAngle.getObject().getBearing().add(wind.getFrom());
        Bearing starboardCourseOverGround = starboardSpeedAndTrueWindAngle.getObject().getBearing().add(wind.getFrom());
        Position intersection = from.getIntersection(portCourseOverGround, to, starboardCourseOverGround);
        Distance fromToIntersection = from.getDistance(intersection);
        SpeedWithBearing portSpeed = portSpeedAndTrueWindAngle.getObject();
        Duration duration1 = portSpeed.getDuration(fromToIntersection);
        Distance intersectionToTo = intersection.getDistance(to);
        SpeedWithBearing starboardSpeed = starboardSpeedAndTrueWindAngle.getObject();
        Duration duration2 = starboardSpeed.getDuration(intersectionToTo);
        return new Util.Pair((Object)fromToIntersection.add(intersectionToTo), (Object)duration1.plus(duration2));
    }

    @Override
    public WindWithConfidence<Util.Pair<Position, TimePoint>> getAverageTrueWindDirection() {
        TimePoint timePoint = this.getReferenceTimePoint();
        return this.getTrackedRace().getWindWithConfidence(this.getMiddleOfLeg(timePoint), timePoint);
    }

    public String toString() {
        return "TrackedLeg for " + this.getLeg();
    }

    private class CacheClearingRaceChangeListener
    extends AbstractRaceChangeListener
    implements Serializable {
        private static final long serialVersionUID = 4455608396760152359L;

        private CacheClearingRaceChangeListener() {
        }

        @Override
        protected void defaultAction() {
            TrackedLegImpl.this.clearCaches();
        }

        @Override
        public void statusChanged(TrackedRaceStatus newStatus, TrackedRaceStatus oldStatus) {
        }

        @Override
        public void delayToLiveChanged(long delayToLiveInMillis) {
        }
    }
}

