/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.tracking.TrackListener;
import com.sap.sse.common.Timed;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class TrackListenerCollection<ItemType, FixType extends Timed, ListenerType extends TrackListener>
implements Serializable {
    private static final long serialVersionUID = -7324146114278369375L;
    private Set<ListenerType> listeners = new HashSet<ListenerType>();

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        this.listeners = (Set)ois.readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream oos) throws IOException {
        HashSet<TrackListener> listenersToSerialize;
        Set<ListenerType> set = this.listeners;
        synchronized (set) {
            listenersToSerialize = new HashSet<TrackListener>();
            for (TrackListener listener : this.listeners) {
                if (listener.isTransient()) continue;
                listenersToSerialize.add(listener);
            }
        }
        oos.writeObject(listenersToSerialize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ListenerType listener) {
        Set<ListenerType> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ListenerType listener) {
        Set<ListenerType> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<ListenerType> getListeners() {
        Set<ListenerType> set = this.listeners;
        synchronized (set) {
            return new HashSet<ListenerType>(this.listeners);
        }
    }
}

