/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.NauticalSide;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Tack;
import com.sap.sailing.domain.common.tracking.impl.AbstractGPSFixImpl;
import com.sap.sailing.domain.tracking.Maneuver;
import com.sap.sailing.domain.tracking.ManeuverCurveBoundaries;
import com.sap.sailing.domain.tracking.ManeuverLoss;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;

public abstract class ManeuverImpl
extends AbstractGPSFixImpl
implements Maneuver {
    private static final long serialVersionUID = -5317959066507472580L;
    private final ManeuverType type;
    private final Tack newTack;
    private final Position position;
    private final TimePoint timePoint;
    private final double maxTurningRateInDegreesPerSecond;
    private final ManeuverCurveBoundaries mainCurveBoundaries;
    private final ManeuverCurveBoundaries maneuverCurveWithStableSpeedAndCourseBoundaries;
    private final MarkPassing markPassing;
    private final ManeuverLoss maneuverLoss;

    public ManeuverImpl(ManeuverType type, Tack newTack, Position position, TimePoint timePoint, ManeuverCurveBoundaries mainCurveBoundaries, ManeuverCurveBoundaries maneuverCurveWithStableSpeedAndCourseBoundaries, double maxTurningRateInDegreesPerSecond, MarkPassing markPassing, ManeuverLoss maneuverLoss) {
        this.type = type;
        this.newTack = newTack;
        this.position = position;
        this.timePoint = timePoint;
        this.mainCurveBoundaries = mainCurveBoundaries;
        this.maneuverCurveWithStableSpeedAndCourseBoundaries = maneuverCurveWithStableSpeedAndCourseBoundaries;
        this.maxTurningRateInDegreesPerSecond = maxTurningRateInDegreesPerSecond;
        this.markPassing = markPassing;
        this.maneuverLoss = maneuverLoss;
    }

    @Override
    public ManeuverType getType() {
        return this.type;
    }

    public Position getPosition() {
        return this.position;
    }

    @Override
    public TimePoint getTimePoint() {
        return this.timePoint;
    }

    @Override
    public ManeuverCurveBoundaries getMainCurveBoundaries() {
        return this.mainCurveBoundaries;
    }

    @Override
    public ManeuverCurveBoundaries getManeuverCurveWithStableSpeedAndCourseBoundaries() {
        return this.maneuverCurveWithStableSpeedAndCourseBoundaries;
    }

    @Override
    public Tack getNewTack() {
        return this.newTack;
    }

    @Override
    public double getDirectionChangeInDegrees() {
        return this.getManeuverBoundaries().getDirectionChangeInDegrees();
    }

    @Override
    public SpeedWithBearing getSpeedWithBearingBefore() {
        return this.getManeuverBoundaries().getSpeedWithBearingBefore();
    }

    @Override
    public SpeedWithBearing getSpeedWithBearingAfter() {
        return this.getManeuverBoundaries().getSpeedWithBearingAfter();
    }

    @Override
    public Speed getLowestSpeed() {
        return this.getManeuverBoundaries().getLowestSpeed();
    }

    public String toString() {
        return String.valueOf(super.toString()) + " " + this.type + " on new tack " + this.newTack + " on position " + this.position + " at time point " + this.timePoint + ", " + this.getManeuverBoundaries() + ", max. turning rate: " + this.maxTurningRateInDegreesPerSecond + (this.getManeuverLoss() == null ? "" : ", Lost approximately " + this.getManeuverLoss().getProjectedDistanceLost()) + ", Mark passing: " + this.markPassing;
    }

    @Override
    public double getMaxTurningRateInDegreesPerSecond() {
        return this.maxTurningRateInDegreesPerSecond;
    }

    @Override
    public Duration getDuration() {
        return this.getManeuverBoundaries().getDuration();
    }

    @Override
    public MarkPassing getMarkPassing() {
        return this.markPassing;
    }

    @Override
    public boolean isMarkPassing() {
        return this.markPassing != null;
    }

    @Override
    public NauticalSide getToSide() {
        return this.getMainCurveBoundaries().getDirectionChangeInDegrees() < 0.0 ? NauticalSide.PORT : NauticalSide.STARBOARD;
    }

    @Override
    public double getAvgTurningRateInDegreesPerSecond() {
        return Math.abs(this.getMainCurveBoundaries().getDirectionChangeInDegrees()) / this.getMainCurveBoundaries().getDuration().asSeconds();
    }

    @Override
    public ManeuverLoss getManeuverLoss() {
        return this.maneuverLoss;
    }
}

