/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking;

import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.base.Leg;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Sideline;
import com.sap.sailing.domain.base.SpeedWithConfidence;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Tack;
import com.sap.sailing.domain.common.TargetTimeInfo;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.abstractlog.TimePointSpecificationFoundInLog;
import com.sap.sailing.domain.common.polars.NotEnoughDataHasBeenAddedException;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.common.tracking.SensorFix;
import com.sap.sailing.domain.leaderboard.caching.LeaderboardDTOCalculationReuseCache;
import com.sap.sailing.domain.leaderboard.impl.CompetitorAndRankComparable;
import com.sap.sailing.domain.leaderboard.impl.RankAndRankComparable;
import com.sap.sailing.domain.polars.PolarDataService;
import com.sap.sailing.domain.racelog.RaceLogAndTrackedRaceResolver;
import com.sap.sailing.domain.ranking.RankingMetric;
import com.sap.sailing.domain.shared.tracking.LineDetails;
import com.sap.sailing.domain.shared.tracking.TrackingConnectorInfo;
import com.sap.sailing.domain.tracking.CourseDesignChangedListener;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.Maneuver;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.MarkPositionAtTimePointCache;
import com.sap.sailing.domain.tracking.RaceAbortedListener;
import com.sap.sailing.domain.tracking.RaceChangeListener;
import com.sap.sailing.domain.tracking.RaceExecutionOrderProvider;
import com.sap.sailing.domain.tracking.SensorFixTrack;
import com.sap.sailing.domain.tracking.StartTimeChangedListener;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sailing.domain.tracking.TrackedRaceStatus;
import com.sap.sailing.domain.tracking.TrackedRegatta;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sailing.domain.tracking.WindPositionMode;
import com.sap.sailing.domain.tracking.WindStore;
import com.sap.sailing.domain.tracking.WindSummary;
import com.sap.sailing.domain.tracking.WindTrack;
import com.sap.sailing.domain.tracking.WindWithConfidence;
import com.sap.sailing.domain.tracking.impl.NonCachingMarkPositionAtTimePointCache;
import com.sap.sailing.domain.windestimation.IncrementalWindEstimation;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.IsManagedByCache;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.UUID;
import java.util.function.BiFunction;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxIterationsExceededException;

public interface TrackedRace
extends Serializable,
IsManagedByCache<DomainFactory>,
WithQualifiedObjectIdentifier {
    public static final Duration START_TRACKING_THIS_MUCH_BEFORE_RACE_START = Duration.ONE_MINUTE.times(5L);
    public static final Duration STOP_TRACKING_THIS_MUCH_AFTER_RACE_FINISH = Duration.ONE_SECOND.times(30L);
    public static final long MAX_TIME_BETWEEN_START_AND_FIRST_MARK_PASSING_IN_MILLISECONDS = 30000L;
    public static final long DEFAULT_LIVE_DELAY_IN_MILLISECONDS = 5000L;

    public void initializeAfterDeserialization();

    public RaceDefinition getRace();

    public RegattaAndRaceIdentifier getRaceIdentifier();

    public RankingMetric getRankingMetric();

    public TimePoint getStartOfRace();

    public TimePoint getStartOfRace(boolean var1);

    public TimePoint getFinishingTime();

    public TimePoint getFinishedTime();

    public TimePoint getEndOfRace();

    public Iterable<Util.Pair<Waypoint, Util.Pair<TimePoint, TimePoint>>> getMarkPassingsTimes();

    public boolean hasStarted(TimePoint var1);

    public boolean isLive(TimePoint var1);

    public Iterable<TrackedLeg> getTrackedLegs();

    public TrackedLeg getTrackedLeg(Leg var1);

    public TrackedLegOfCompetitor getCurrentLeg(Competitor var1, TimePoint var2);

    public TrackedLeg getCurrentLeg(TimePoint var1);

    public int getLastLegStarted(TimePoint var1);

    public TrackedLeg getTrackedLegFinishingAt(Waypoint var1);

    public TrackedLeg getTrackedLegStartingAt(Waypoint var1);

    public GPSFixTrack<Competitor, GPSFixMoving> getTrack(Competitor var1);

    public <FixT extends SensorFix, TrackT extends SensorFixTrack<Competitor, FixT>> TrackT getSensorTrack(Competitor var1, String var2);

    public <FixT extends SensorFix, TrackT extends SensorFixTrack<Competitor, FixT>> Iterable<TrackT> getSensorTracks(String var1);

    public TrackedLegOfCompetitor getTrackedLeg(Competitor var1, TimePoint var2);

    public TrackedLegOfCompetitor getTrackedLeg(Competitor var1, Leg var2);

    public long getUpdateCount();

    public int getRankDifference(Competitor var1, Leg var2, TimePoint var3);

    public int getRank(Competitor var1) throws NoWindException;

    default public int getRank(Competitor competitor, TimePoint timePoint) {
        return this.getRank(competitor, timePoint, new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    public int getRank(Competitor var1, TimePoint var2, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var3);

    public Iterable<MarkPassing> getMarkPassingsInOrder(Waypoint var1);

    public MarkPassing getMarkPassing(Competitor var1, Waypoint var2);

    public GPSFixTrack<Mark, GPSFix> getOrCreateTrack(Mark var1);

    public GPSFixTrack<Mark, GPSFix> getTrack(Mark var1);

    public Iterable<Mark> getMarks();

    public Iterable<Sideline> getCourseSidelines();

    default public Position getApproximatePosition(Waypoint waypoint, TimePoint timePoint) {
        return this.getApproximatePosition(waypoint, timePoint, new NonCachingMarkPositionAtTimePointCache(this, timePoint));
    }

    public Position getApproximatePosition(Waypoint var1, TimePoint var2, MarkPositionAtTimePointCache var3);

    default public boolean takesWindFixWithTimePoint(TimePoint timePoint) {
        return true;
    }

    default public boolean takesWindFixWithTimePointRecursively(TimePoint windFixTimePoint, Set<TrackedRace> visited) {
        return true;
    }

    public Wind getWind(Position var1, TimePoint var2);

    public Wind getWind(Position var1, TimePoint var2, Set<WindSource> var3);

    public Set<WindSource> getWindSources(WindSourceType var1);

    public Set<WindSource> getWindSources();

    public WindTrack getOrCreateWindTrack(WindSource var1);

    public WindTrack getOrCreateWindTrack(WindSource var1, long var2);

    public void waitForNextUpdate(int var1) throws InterruptedException;

    public TimePoint getStartOfTracking();

    public TimePoint getEndOfTracking();

    public TimePoint getTimePointOfNewestEvent();

    public TimePoint getTimePointOfOldestEvent();

    public NavigableSet<MarkPassing> getMarkPassings(Competitor var1);

    public NavigableSet<MarkPassing> getMarkPassings(Competitor var1, boolean var2);

    default public Map<Competitor, Map<Waypoint, MarkPassing>> getMarkPassings(boolean waitForLatestUpdates) {
        HashMap<Competitor, Map<Waypoint, MarkPassing>> result = new HashMap<Competitor, Map<Waypoint, MarkPassing>>();
        for (Competitor competitor : this.getRace().getCompetitors()) {
            for (MarkPassing markPassing : this.getMarkPassings(competitor, waitForLatestUpdates)) {
                result.computeIfAbsent(competitor, k -> new HashMap()).put(markPassing.getWaypoint(), markPassing);
            }
        }
        return result;
    }

    public void lockForRead(Iterable<MarkPassing> var1);

    public void unlockAfterRead(Iterable<MarkPassing> var1);

    public TimePoint getTimePointOfLastEvent();

    public long getMillisecondsOverWhichToAverageSpeed();

    public long getMillisecondsOverWhichToAverageWind();

    public long getDelayToLiveInMillis();

    public Wind getEstimatedWindDirection(TimePoint var1);

    public Tack getTack(Competitor var1, TimePoint var2) throws NoWindException;

    public Tack getTack(Position var1, TimePoint var2, Bearing var3) throws NoWindException;

    public Tack getTack(SpeedWithBearing var1, Wind var2, TimePoint var3);

    public TrackedRegatta getTrackedRegatta();

    public Wind getDirectionFromStartToNextMark(TimePoint var1);

    public Iterable<GPSFixMoving> approximate(Competitor var1, Distance var2, TimePoint var3, TimePoint var4);

    public Iterable<Maneuver> getManeuvers(Competitor var1, TimePoint var2, TimePoint var3, boolean var4);

    public Iterable<Maneuver> getManeuvers(Competitor var1, boolean var2);

    public boolean raceIsKnownToStartUpwind();

    public boolean hasWindData();

    public boolean hasGPSData();

    public void addListener(RaceChangeListener var1);

    public void addListener(RaceChangeListener var1, boolean var2, boolean var3);

    public void removeListener(RaceChangeListener var1);

    public Distance getDistanceTraveled(Competitor var1, TimePoint var2);

    public Distance getDistanceTraveledIncludingGateStart(Competitor var1, TimePoint var2);

    public Distance getDistanceFoiled(Competitor var1, TimePoint var2);

    public Duration getDurationFoiled(Competitor var1, TimePoint var2);

    public Distance getWindwardDistanceToCompetitorFarthestAhead(Competitor var1, TimePoint var2, WindPositionMode var3);

    public Distance getWindwardDistanceToCompetitorFarthestAhead(Competitor var1, TimePoint var2, WindPositionMode var3, RankingMetric.RankingInfo var4, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var5);

    public WindWithConfidence<Util.Pair<Position, TimePoint>> getWindWithConfidence(Position var1, TimePoint var2);

    public Set<WindSource> getWindSourcesToExclude();

    public WindWithConfidence<Util.Pair<Position, TimePoint>> getWindWithConfidence(Position var1, TimePoint var2, Set<WindSource> var3);

    public WindWithConfidence<TimePoint> getEstimatedWindDirectionWithConfidence(TimePoint var1);

    public void setWindSourcesToExclude(Iterable<? extends WindSource> var1);

    public Distance getAverageAbsoluteCrossTrackError(Competitor var1, TimePoint var2, boolean var3);

    public Distance getAverageAbsoluteCrossTrackError(Competitor var1, TimePoint var2, boolean var3, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var4);

    public Distance getAverageAbsoluteCrossTrackError(Competitor var1, TimePoint var2, TimePoint var3, boolean var4, boolean var5);

    public Distance getAverageSignedCrossTrackError(Competitor var1, TimePoint var2, boolean var3);

    public Distance getAverageSignedCrossTrackError(Competitor var1, TimePoint var2, boolean var3, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var4);

    public Distance getAverageSignedCrossTrackError(Competitor var1, TimePoint var2, TimePoint var3, boolean var4, boolean var5);

    public Distance getAverageRideHeight(Competitor var1, TimePoint var2);

    public WindStore getWindStore();

    public Competitor getOverallLeader(TimePoint var1);

    public Competitor getOverallLeader(TimePoint var1, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var2);

    public Boat getBoatOfCompetitor(Competitor var1);

    public Competitor getCompetitorOfBoat(Boat var1);

    public LinkedHashMap<Competitor, RankAndRankComparable> getCompetitorsFromBestToWorstAndRankAndRankComparable(TimePoint var1);

    public LinkedHashMap<Competitor, RankAndRankComparable> getCompetitorsFromBestToWorstAndRankAndRankComparable(TimePoint var1, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var2);

    public List<CompetitorAndRankComparable> getCompetitorsFromBestToWorstAndRankComparable(TimePoint var1);

    public List<CompetitorAndRankComparable> getCompetitorsFromBestToWorstAndRankComparable(TimePoint var1, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var2);

    public Iterable<Competitor> getCompetitorsFromBestToWorst(TimePoint var1);

    public Iterable<Competitor> getCompetitorsFromBestToWorst(TimePoint var1, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var2);

    public void waitUntilLoadingFromWindStoreComplete() throws InterruptedException;

    public void waitForLoadingToFinish() throws InterruptedException;

    public TrackedRaceStatus getStatus();

    public void waitUntilNotLoading();

    public RaceLog detachRaceLog(Serializable var1);

    public void detachRaceExecutionOrderProvider(RaceExecutionOrderProvider var1);

    public void attachRaceLog(RaceLog var1);

    public void attachRegattaLog(RegattaLog var1);

    public Iterable<RegattaLog> getAttachedRegattaLogs();

    public void attachRaceExecutionProvider(RaceExecutionOrderProvider var1);

    public RaceLog getRaceLog(Serializable var1);

    public void addCourseDesignChangedListener(CourseDesignChangedListener var1);

    public void addStartTimeChangedListener(StartTimeChangedListener var1);

    public void removeStartTimeChangedListener(StartTimeChangedListener var1);

    public void addRaceAbortedListener(RaceAbortedListener var1);

    public Distance getDistanceToStartLine(Competitor var1, long var2);

    public Distance getDistanceToStartLine(Competitor var1, TimePoint var2);

    public Distance getWindwardDistanceToFavoredSideOfStartLine(Competitor var1, long var2);

    public Distance getWindwardDistanceToFavoredSideOfStartLine(Competitor var1, long var2, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var4);

    default public Distance getWindwardDistanceToFavoredSideOfStartLine(Competitor competitor, TimePoint timePoint) {
        return this.getWindwardDistanceToFavoredSideOfStartLine(competitor, timePoint, (WindLegTypeAndLegBearingAndORCPerformanceCurveCache)new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    public Distance getWindwardDistanceToFavoredSideOfStartLine(Competitor var1, TimePoint var2, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var3);

    public Distance getDistanceFromStarboardSideOfStartLineWhenPassingStart(Competitor var1);

    public Distance getDistanceFromStarboardSideOfStartLine(Competitor var1, TimePoint var2);

    public Distance getDistanceFromStarboardSideOfStartLineProjectedOntoLine(Competitor var1, TimePoint var2);

    public SortedMap<Competitor, Distance> getDistancesFromStarboardSideOfStartLineProjectedOntoLine(TimePoint var1, BiFunction<Competitor, TimePoint, MaxPointsReason> var2);

    public Competitor getNextCompetitorToPortOnStartLine(Competitor var1, TimePoint var2, BiFunction<Competitor, TimePoint, MaxPointsReason> var3);

    public Competitor getNextCompetitorToStarboardOnStartLine(Competitor var1, TimePoint var2, BiFunction<Competitor, TimePoint, MaxPointsReason> var3);

    public Speed getSpeed(Competitor var1, long var2);

    public Speed getSpeedWhenCrossingStartLine(Competitor var1);

    public TimePoint getStartTimeReceived();

    public LineDetails getStartLine(TimePoint var1);

    public LineDetails getFinishLine(TimePoint var1);

    public Distance getCourseLength();

    public SpeedWithConfidence<TimePoint> getAverageWindSpeedWithConfidence(long var1);

    public SpeedWithConfidence<TimePoint> getAverageWindSpeedWithConfidenceWithNumberOfSamples(int var1);

    public SpeedWithConfidence<TimePoint> getAverageWindSpeedWithConfidence(TimePoint var1, TimePoint var2, int var3);

    public Position getCenterOfCourse(TimePoint var1);

    public Boolean isGateStart();

    public long getGateStartGolfDownTime();

    public Distance getAdditionalGateStartDistance(Competitor var1, TimePoint var2);

    public boolean isUsingMarkPassingCalculator();

    public TargetTimeInfo getEstimatedTimeToComplete(TimePoint var1) throws NotEnoughDataHasBeenAddedException, NoWindException;

    default public Duration getTimeSailedSinceRaceStart(Competitor competitor, TimePoint timePoint) {
        return null;
    }

    public Distance getEstimatedDistanceToComplete(TimePoint var1) throws NotEnoughDataHasBeenAddedException, NoWindException;

    public void setPolarDataService(PolarDataService var1);

    default public RaceLogAndTrackedRaceResolver getRaceLogResolver() {
        return null;
    }

    default public Util.Pair<TimePointSpecificationFoundInLog, TimePointSpecificationFoundInLog> getTrackingTimesFromRaceLogs() {
        return null;
    }

    default public Util.Pair<TimePoint, TimePoint> getStartAndFinishedTimeFromRaceLogs() {
        return null;
    }

    default public Iterable<Mark> getMarksFromRegattaLogs() {
        return this.getMarks();
    }

    public void updateStartAndEndOfTracking(boolean var1);

    default public void lockForSerializationRead() {
    }

    default public void unlockAfterSerializationRead() {
    }

    public Iterable<RaceLog> getAttachedRaceLogs();

    public Speed getAverageSpeedOverGround(Competitor var1, TimePoint var2);

    default public SpeedWithBearing getVelocityMadeGood(Competitor competitor, TimePoint timePoint) {
        return this.getVelocityMadeGood(competitor, timePoint, new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    default public SpeedWithBearing getVelocityMadeGood(Competitor competitor, TimePoint timePoint, WindPositionMode windPositionMode) {
        return this.getVelocityMadeGood(competitor, timePoint, windPositionMode, new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    default public Bearing getTWA(Competitor competitor, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Bearing twa = null;
        GPSFixTrack<Competitor, GPSFixMoving> sogTrack = this.getTrack(competitor);
        if (sogTrack != null) {
            SpeedWithBearing speedOverGround = sogTrack.getEstimatedSpeed(timePoint);
            Wind wind = cache.getWind(this, competitor, timePoint);
            if (wind != null && speedOverGround != null) {
                Bearing projectToDirection = wind.getFrom();
                twa = speedOverGround.getBearing().getDifferenceTo(projectToDirection);
            }
        }
        return twa;
    }

    default public Bearing getTWA(Competitor competitor, TimePoint at) {
        return this.getTWA(competitor, at, new LeaderboardDTOCalculationReuseCache(at));
    }

    default public SpeedWithBearing getVelocityMadeGood(Competitor competitor, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return this.getVelocityMadeGood(competitor, timePoint, WindPositionMode.EXACT, cache);
    }

    public SpeedWithBearing getVelocityMadeGood(Competitor var1, TimePoint var2, WindPositionMode var3, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var4);

    public boolean recordWind(Wind var1, WindSource var2, boolean var3);

    public void removeWind(Wind var1, WindSource var2);

    public PolarDataService getPolarDataService();

    public void setWindEstimation(IncrementalWindEstimation var1);

    public WindSummary getWindSummary();

    default public QualifiedObjectIdentifier getIdentifier() {
        return TrackedRace.getIdentifier(this.getRaceIdentifier());
    }

    public static QualifiedObjectIdentifier getIdentifier(RegattaAndRaceIdentifier regattaAndRaceId) {
        return TrackedRace.getSecuredDomainType().getQualifiedObjectIdentifier(regattaAndRaceId.getTypeRelativeObjectIdentifier());
    }

    default public TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier() {
        return this.getRaceIdentifier().getTypeRelativeObjectIdentifier();
    }

    default public String getName() {
        return String.valueOf(this.getRaceIdentifier().getRaceName()) + "@" + this.getRaceIdentifier().getRegattaName();
    }

    default public HasPermissions getPermissionType() {
        return TrackedRace.getSecuredDomainType();
    }

    public static HasPermissions getSecuredDomainType() {
        return SecuredDomainType.TRACKED_RACE;
    }

    default public Speed getReferenceImpliedWind(TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return this.getRankingMetric().getReferenceImpliedWind(timePoint, cache);
    }

    public TrackingConnectorInfo getTrackingConnectorInfo();

    public void runWhenDoneLoading(Runnable var1);

    public void runSynchronizedOnStatus(Runnable var1);

    public boolean hasFinishedLoading();

    public Util.Pair<Bearing, Position> getStartLineBearingAndStarboardMarkPosition(TimePoint var1);

    public UUID getCourseAreaId();

    public Double getPercentTargetBoatSpeed(Competitor var1, TimePoint var2, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var3) throws NotEnoughDataHasBeenAddedException, MaxIterationsExceededException, FunctionEvaluationException;
}

