/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking;

import com.sap.sailing.domain.base.SpeedWithBearingWithConfidence;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.confidence.Weigher;
import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.shared.tracking.MappedTrack;
import com.sap.sailing.domain.tracking.GPSTrackListener;
import com.sap.sailing.domain.tracking.SpeedWithBearingStepsIterable;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Timed;
import com.sap.sse.common.Util;
import java.util.Iterator;

public interface GPSFixTrack<ItemType, FixType extends GPSFix>
extends MappedTrack<ItemType, FixType> {
    public static final long DEFAULT_MILLISECONDS_OVER_WHICH_TO_AVERAGE_SPEED = 10000L;
    public static final Speed DEFAULT_MAX_SPEED_FOR_SMOOTHING = new KnotSpeedImpl(40.0);

    public void addListener(GPSTrackListener<ItemType, FixType> var1);

    public void removeListener(GPSTrackListener<ItemType, FixType> var1);

    public Distance getDistanceTraveled(TimePoint var1, TimePoint var2);

    public Duration getLongestIntervalBetweenTwoFixes(TimePoint var1, TimePoint var2);

    public Distance getRawDistanceTraveled(TimePoint var1, TimePoint var2);

    public Position getEstimatedPosition(TimePoint var1, boolean var2);

    public Position getEstimatedRawPosition(TimePoint var1, boolean var2);

    public Util.Pair<FixType, Speed> getMaximumSpeedOverGround(TimePoint var1, TimePoint var2);

    public SpeedWithBearing getEstimatedSpeed(TimePoint var1);

    public SpeedWithBearingWithConfidence<TimePoint> getEstimatedSpeed(TimePoint var1, Weigher<TimePoint> var2);

    public SpeedWithBearingWithConfidence<TimePoint> getRawEstimatedSpeed(TimePoint var1, Weigher<TimePoint> var2);

    public long getMillisecondsOverWhichToAverageSpeed();

    public boolean hasDirectionChange(TimePoint var1, double var2);

    public SpeedWithBearing getRawEstimatedSpeed(TimePoint var1);

    public TimeRange getEstimatedPositionTimePeriodAffectedBy(GPSFix var1);

    public Iterator<Position> getEstimatedPositions(Iterable<Timed> var1, boolean var2);

    public void suspendValidityAndMaxSpeedCaching();

    public void resumeValidityAndMaxSpeedCaching();

    public SpeedWithBearingStepsIterable getSpeedWithBearingSteps(TimePoint var1, TimePoint var2);

    public boolean isValid(FixType var1);
}

