/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.sharding;

import com.sap.sailing.domain.common.sharding.ShardingType;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ShardingContext {
    private static final Logger logger = Logger.getLogger(ShardingContext.class.getName());
    private static final ConcurrentMap<ShardingType, ThreadLocal<String>> shardingMap = new ConcurrentHashMap<ShardingType, ThreadLocal<String>>();

    public static ShardingType identifyAndSetShardingConstraint(String shardingInfo) {
        if (shardingInfo == null || shardingInfo.isEmpty()) {
            return null;
        }
        ThreadLocal identifiedShardingHolder = null;
        ShardingType[] shardingTypeArray = ShardingType.values();
        int n = shardingTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ShardingType shardingType = shardingTypeArray[n2];
            if (shardingInfo.startsWith(shardingType.getPrefix())) {
                identifiedShardingHolder = shardingMap.computeIfAbsent(shardingType, t -> new ThreadLocal());
                ShardingContext.checkAndSetShardingInfo(shardingType, shardingInfo, identifiedShardingHolder);
                return shardingType;
            }
            ++n2;
        }
        if (identifiedShardingHolder == null) {
            logger.warning("Could not identify sharding type for: " + shardingInfo);
        }
        return null;
    }

    public static void setShardingConstraint(ShardingType shardingType, String shardingInfo) {
        String encodedShardingInfo = shardingType.encodeShardingInfo(shardingInfo);
        ThreadLocal shardingHolder = shardingMap.computeIfAbsent(shardingType, t -> new ThreadLocal());
        ShardingContext.checkAndSetShardingInfo(shardingType, encodedShardingInfo, shardingHolder);
    }

    public static void checkConstraint(ShardingType type, String shardingInfo) {
        if (shardingInfo == null || shardingInfo.isEmpty()) {
            logger.warning("Empty sharding constraint");
            return;
        }
        ThreadLocal shardingHolder = (ThreadLocal)shardingMap.get(type);
        if (shardingHolder == null) {
            logger.log(Level.WARNING, "No current sharding context set for " + type.name(), new RuntimeException());
            return;
        }
        String currentShardingInfo = (String)shardingHolder.get();
        if (currentShardingInfo == null || currentShardingInfo.isEmpty()) {
            logger.warning("No current sharding constraint for " + type.name());
            return;
        }
        String encodedShardingInfo = type.encodeShardingInfo(shardingInfo);
        if (!encodedShardingInfo.equals(currentShardingInfo)) {
            logger.log(Level.SEVERE, "Current sharding constraint vialation for " + type.name() + ". Got " + shardingInfo + ", shard requires " + currentShardingInfo, new RuntimeException());
            return;
        }
    }

    public static void clearShardingConstraint(ShardingType type) {
        ThreadLocal shardingHolder = (ThreadLocal)shardingMap.get(type);
        if (shardingHolder != null) {
            shardingHolder.remove();
        }
    }

    private static void checkAndSetShardingInfo(ShardingType shardingType, String encodedShardingInfo, ThreadLocal<String> shardingHolder) {
        String currentShardingInfo;
        if (encodedShardingInfo == null || encodedShardingInfo.isEmpty()) {
            logger.log(Level.SEVERE, "Cannot set empty sharding information for " + shardingType.name(), new RuntimeException());
        }
        if ((currentShardingInfo = shardingHolder.get()) == null) {
            shardingHolder.set(encodedShardingInfo);
        } else if (!encodedShardingInfo.equals(currentShardingInfo)) {
            logger.log(Level.SEVERE, "Switching shard constraint for " + shardingType.name() + ". Got <<" + encodedShardingInfo + ">>, expeted <<" + currentShardingInfo + ">>", new RuntimeException());
        }
    }
}

