/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.markpassingcalculation.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.Bounds;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.BoundsImpl;
import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.markpassingcalculation.Candidate;
import com.sap.sailing.domain.markpassingcalculation.impl.CandidateImpl;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class StationarySequence {
    public static final Distance CANDIDATE_FILTER_DISTANCE = new MeterDistance(30.0);
    private final Util.ValueCollectionConstructor<Candidate, NavigableSet<Candidate>> valueSetConstructorForCandidatesByTime;
    private final Util.ValueCollectionConstructor<Candidate, NavigableSet<Candidate>> valueSetConstructorForCandidatesByAscendingProbability;
    private final NavigableSet<Candidate> candidates;
    private final Map<Waypoint, NavigableSet<Candidate>> candidatesByWaypoint;
    private final Map<Waypoint, NavigableSet<Candidate>> candidatesByWaypointSortedByAscendingProbability;
    private final GPSFixTrack<Competitor, GPSFixMoving> track;
    private Bounds boundingBoxOfTrackSpanningCandidates;
    private final Comparator<Candidate> candidateComparator;

    public StationarySequence(Candidate seed, Comparator<Candidate> candidateComparator, GPSFixTrack<Competitor, GPSFixMoving> track) {
        this.candidates = new TreeSet<Candidate>(candidateComparator);
        this.candidatesByWaypoint = new HashMap<Waypoint, NavigableSet<Candidate>>();
        this.candidatesByWaypointSortedByAscendingProbability = new HashMap<Waypoint, NavigableSet<Candidate>>();
        this.candidateComparator = candidateComparator;
        this.valueSetConstructorForCandidatesByTime = () -> new TreeSet(candidateComparator);
        this.valueSetConstructorForCandidatesByAscendingProbability = () -> new TreeSet((c1, c2) -> {
            int resultBasedOnProbability = Double.compare(c1.getProbability(), c2.getProbability());
            int result = resultBasedOnProbability == 0 ? candidateComparator.compare((Candidate)c1, (Candidate)c2) : resultBasedOnProbability;
            return result;
        });
        this.track = track;
        this.candidates.add(seed);
        Util.addToValueSet(this.candidatesByWaypoint, (Object)seed.getWaypoint(), (Object)seed, this.valueSetConstructorForCandidatesByTime);
        Util.addToValueSet(this.candidatesByWaypointSortedByAscendingProbability, (Object)seed.getWaypoint(), (Object)seed, this.valueSetConstructorForCandidatesByAscendingProbability);
        this.boundingBoxOfTrackSpanningCandidates = this.createNewBounds(seed);
        assert (this.isCandidatesConsistent(seed));
    }

    public boolean tryToExtendAfterLast(Candidate candidateAfterSequence, Set<Candidate> candidatesEffectivelyAdded, Set<Candidate> candidatesEffectivelyRemoved) {
        Bounds bounds = this.computeExtendedBoundsForFixesBetweenCandidates(this.getLast(), candidateAfterSequence, this.boundingBoxOfTrackSpanningCandidates, false);
        if (bounds != null) {
            this.boundingBoxOfTrackSpanningCandidates = bounds;
            this.addCandidateAndUpdateFilterResultDelta(candidateAfterSequence, candidatesEffectivelyAdded, candidatesEffectivelyRemoved);
        }
        return bounds != null;
    }

    private Bounds computeExtendedBoundsForFixesBetweenCandidates(Candidate start, Candidate end, Bounds boundingBoxToStartWith, boolean tolerateTemporaryBoundingBoxExcess) {
        Bounds bounds = boundingBoxToStartWith;
        if (bounds != null) {
            this.track.lockForRead();
            try {
                Iterator iter = this.track.getRawFixesIterator(start.getTimePoint(), true, end.getTimePoint(), true);
                while (iter.hasNext()) {
                    GPSFixMoving fix = (GPSFixMoving)iter.next();
                    bounds = bounds.extend(fix.getPosition());
                    if (tolerateTemporaryBoundingBoxExcess || bounds.getDiameter().compareTo((Object)CANDIDATE_FILTER_DISTANCE) <= 0) continue;
                    bounds = null;
                    break;
                }
            }
            finally {
                this.track.unlockAfterRead();
            }
        }
        return bounds;
    }

    public boolean tryToExtendBeforeFirst(Candidate candidateBeforeSequence, Set<Candidate> candidatesEffectivelyAdded, Set<Candidate> candidatesEffectivelyRemoved, NavigableSet<StationarySequence> stationarySequenceSetToUpdate) {
        Bounds bounds = this.computeExtendedBoundsForFixesBetweenCandidates(candidateBeforeSequence, this.getFirst(), this.boundingBoxOfTrackSpanningCandidates, false);
        if (bounds != null) {
            this.boundingBoxOfTrackSpanningCandidates = bounds;
            this.addCandidateAndUpdateFilterResultDelta(candidateBeforeSequence, candidatesEffectivelyAdded, candidatesEffectivelyRemoved);
        }
        return bounds != null;
    }

    public Iterable<Candidate> getValidCandidates() {
        TreeSet<Candidate> result = new TreeSet<Candidate>(this.candidateComparator);
        for (NavigableSet<Candidate> candidateForWaypoint : this.candidatesByWaypoint.values()) {
            result.add((Candidate)candidateForWaypoint.first());
            result.add((Candidate)candidateForWaypoint.last());
        }
        for (NavigableSet<Candidate> candidateForWaypoint : this.candidatesByWaypointSortedByAscendingProbability.values()) {
            result.add((Candidate)candidateForWaypoint.last());
        }
        return result;
    }

    private boolean isValidCandidate(Candidate c) {
        NavigableSet<Candidate> candidatesForSameWaypointSortedByAscendingProbability;
        NavigableSet<Candidate> candidatesForSameWaypoint;
        return c.isFixed() || (candidatesForSameWaypoint = this.candidatesByWaypoint.get(c.getWaypoint())) != null && !candidatesForSameWaypoint.isEmpty() && (candidatesForSameWaypoint.first() == c || candidatesForSameWaypoint.last() == c) || (candidatesForSameWaypointSortedByAscendingProbability = this.candidatesByWaypointSortedByAscendingProbability.get(c.getWaypoint())) != null && !candidatesForSameWaypointSortedByAscendingProbability.isEmpty() && candidatesForSameWaypointSortedByAscendingProbability.last() == c;
    }

    public int size() {
        return this.candidates.size();
    }

    public boolean isEmpty() {
        return this.candidates.isEmpty();
    }

    void addWithin(Candidate candidate, Set<Candidate> candidatesEffectivelyAdded, Set<Candidate> candidatesEffectivelyRemoved) {
        assert (!(this.candidates.contains(candidate) || this.getFirst().getTimePoint().after(candidate.getTimePoint()) || this.getLast().getTimePoint().before(candidate.getTimePoint())));
        this.addCandidateAndUpdateFilterResultDelta(candidate, candidatesEffectivelyAdded, candidatesEffectivelyRemoved);
    }

    private void addCandidateAndUpdateFilterResultDelta(Candidate candidate, Set<Candidate> candidatesEffectivelyAdded, Set<Candidate> candidatesEffectivelyRemoved) {
        assert (this.isCandidatesConsistent(candidate));
        this.candidates.add(candidate);
        NavigableSet<Candidate> candidatesForSameWaypointSortedByAscendingProbability = this.candidatesByWaypointSortedByAscendingProbability.get(candidate.getWaypoint());
        assert (candidatesForSameWaypointSortedByAscendingProbability == null || !candidatesForSameWaypointSortedByAscendingProbability.contains(candidate));
        Candidate mostProbableCandidateForWaypointSoFar = candidatesForSameWaypointSortedByAscendingProbability != null && !candidatesForSameWaypointSortedByAscendingProbability.isEmpty() ? (Candidate)candidatesForSameWaypointSortedByAscendingProbability.last() : null;
        Util.addToValueSet(this.candidatesByWaypoint, (Object)candidate.getWaypoint(), (Object)candidate, this.valueSetConstructorForCandidatesByTime);
        Util.addToValueSet(this.candidatesByWaypointSortedByAscendingProbability, (Object)candidate.getWaypoint(), (Object)candidate, this.valueSetConstructorForCandidatesByAscendingProbability);
        assert (this.isCandidatesConsistent(candidate));
        if (this.isValidCandidate(candidate)) {
            Iterator<Candidate> iterator;
            candidatesEffectivelyAdded.add(candidate);
            candidatesEffectivelyRemoved.remove(candidate);
            NavigableSet<Candidate> candidatesForWaypoint = this.candidatesByWaypoint.get(candidate.getWaypoint());
            if (candidatesForWaypoint.size() > 2 && (iterator = candidatesForWaypoint.first() == candidate ? candidatesForWaypoint.iterator() : (candidatesForWaypoint.last() == candidate ? candidatesForWaypoint.descendingIterator() : null)) != null) {
                Candidate borderCandidate = iterator.next();
                assert (borderCandidate == candidate);
                Candidate candidateShadowed = iterator.next();
                if (!candidateShadowed.isFixed() && !this.isValidCandidate(candidateShadowed)) {
                    candidatesEffectivelyAdded.remove(candidateShadowed);
                    candidatesEffectivelyRemoved.add(candidateShadowed);
                }
            }
            if (mostProbableCandidateForWaypointSoFar != null && !this.isValidCandidate(mostProbableCandidateForWaypointSoFar)) {
                candidatesEffectivelyAdded.remove(mostProbableCandidateForWaypointSoFar);
                candidatesEffectivelyRemoved.add(mostProbableCandidateForWaypointSoFar);
            }
        }
    }

    void remove(Candidate candidate, Set<Candidate> candidatesEffectivelyAdded, Set<Candidate> candidatesEffectivelyRemoved, NavigableSet<StationarySequence> stationarySequenceSetToUpdate) {
        boolean secondMostProbableOfItsWaypointWasValid;
        assert (this.candidates.contains(candidate));
        assert (this.isCandidatesConsistent(candidate));
        NavigableSet<Candidate> candidatesWithSameWaypoint = this.candidatesByWaypoint.get(candidate.getWaypoint());
        assert (candidatesWithSameWaypoint.contains(candidate));
        NavigableSet<Candidate> candidatesWithSameWaypointSortedByAscendingProbability = this.candidatesByWaypointSortedByAscendingProbability.get(candidate.getWaypoint());
        assert (candidatesWithSameWaypointSortedByAscendingProbability.contains(candidate));
        boolean wasValidCandidate = this.isValidCandidate(candidate);
        boolean wasFirst = candidate == this.getFirst();
        boolean wasLast = candidate == this.getLast();
        boolean wasFirstOfItsWaypoint = candidatesWithSameWaypoint.first() == candidate;
        boolean wasLastOfItsWaypoint = candidatesWithSameWaypoint.last() == candidate;
        boolean secondOfItsWaypointWasValid = candidatesWithSameWaypoint.size() > 1 && this.isValidCandidate(candidatesWithSameWaypoint.higher((Candidate)candidatesWithSameWaypoint.first()));
        boolean secondToLastOfItsWaypointWasValid = candidatesWithSameWaypoint.size() > 1 && this.isValidCandidate(candidatesWithSameWaypoint.lower((Candidate)candidatesWithSameWaypoint.last()));
        boolean wasMostProbableOfItsWaypoint = candidatesWithSameWaypointSortedByAscendingProbability.last() == candidate;
        boolean bl = secondMostProbableOfItsWaypointWasValid = candidatesWithSameWaypointSortedByAscendingProbability.size() > 1 && this.isValidCandidate(candidatesWithSameWaypointSortedByAscendingProbability.lower((Candidate)candidatesWithSameWaypointSortedByAscendingProbability.last()));
        if (wasFirst || this.size() == 2) {
            stationarySequenceSetToUpdate.remove(this);
        }
        this.candidates.remove(candidate);
        Util.removeFromValueSet(this.candidatesByWaypoint, (Object)candidate.getWaypoint(), (Object)candidate);
        Util.removeFromValueSet(this.candidatesByWaypointSortedByAscendingProbability, (Object)candidate.getWaypoint(), (Object)candidate);
        assert (!candidatesWithSameWaypointSortedByAscendingProbability.contains(candidate));
        assert (this.isCandidatesConsistent(candidate));
        if (wasFirst && this.candidates.size() > 1) {
            stationarySequenceSetToUpdate.add(this);
        }
        if (wasFirst && candidate.getTimePoint().until(this.getFirst().getTimePoint()).compareTo((Object)Duration.NULL) > 0 || wasLast && this.getLast().getTimePoint().until(candidate.getTimePoint()).compareTo((Object)Duration.NULL) > 0) {
            this.refreshBoundingBox();
        }
        if (wasValidCandidate) {
            candidatesEffectivelyRemoved.add(candidate);
            candidatesEffectivelyAdded.remove(candidate);
            if (wasFirstOfItsWaypoint) {
                if (!secondOfItsWaypointWasValid && !candidatesWithSameWaypoint.isEmpty()) {
                    candidatesEffectivelyAdded.add((Candidate)candidatesWithSameWaypoint.first());
                    candidatesEffectivelyRemoved.remove(candidatesWithSameWaypoint.first());
                }
            } else if (wasLastOfItsWaypoint && !secondToLastOfItsWaypointWasValid && !candidatesWithSameWaypoint.isEmpty()) {
                candidatesEffectivelyAdded.add((Candidate)candidatesWithSameWaypoint.last());
                candidatesEffectivelyRemoved.remove(candidatesWithSameWaypoint.last());
            }
            if (wasMostProbableOfItsWaypoint && !secondMostProbableOfItsWaypointWasValid && !candidatesWithSameWaypointSortedByAscendingProbability.isEmpty()) {
                candidatesEffectivelyAdded.add((Candidate)candidatesWithSameWaypointSortedByAscendingProbability.last());
                candidatesEffectivelyRemoved.remove(candidatesWithSameWaypointSortedByAscendingProbability.last());
            }
        }
    }

    private boolean isCandidatesConsistent(Candidate candidate) {
        boolean inCandidatesByWaypointSortedByAscendingProbability;
        boolean inCandidates = this.candidates.contains(candidate);
        boolean inCandidatesByWaypoint = this.candidatesByWaypoint.get(candidate.getWaypoint()) != null && this.candidatesByWaypoint.get(candidate.getWaypoint()).contains(candidate);
        boolean bl = inCandidatesByWaypointSortedByAscendingProbability = this.candidatesByWaypointSortedByAscendingProbability.get(candidate.getWaypoint()) != null && this.candidatesByWaypointSortedByAscendingProbability.get(candidate.getWaypoint()).contains(candidate);
        return inCandidates == inCandidatesByWaypoint && inCandidates == inCandidatesByWaypointSortedByAscendingProbability;
    }

    private void refreshBoundingBox() {
        Bounds newBounds = this.recomputeBounds(true);
        assert (this.isEmpty() || newBounds != null);
        this.boundingBoxOfTrackSpanningCandidates = newBounds;
    }

    private Bounds recomputeBounds(boolean tolerateTemporaryBoundingBoxExcess) {
        Bounds newBounds;
        if (this.isEmpty()) {
            newBounds = null;
        } else {
            newBounds = this.createNewBounds(this.getFirst());
            newBounds = this.computeExtendedBoundsForFixesBetweenCandidates(this.getFirst(), this.getLast(), newBounds, tolerateTemporaryBoundingBoxExcess);
        }
        return newBounds;
    }

    private Bounds createNewBounds(Candidate candidate) {
        Position estimatedPosition = this.track.getEstimatedPosition(candidate.getTimePoint(), true);
        return estimatedPosition == null ? null : new BoundsImpl(estimatedPosition);
    }

    Candidate getFirst() {
        return (Candidate)this.candidates.first();
    }

    Candidate getLast() {
        return (Candidate)this.candidates.last();
    }

    public StationarySequence tryToAddFix(GPSFixMoving newFix, Set<Candidate> candidatesEffectivelyAdded, Set<Candidate> candidatesEffectivelyRemoved, NavigableSet<StationarySequence> stationarySequenceSetToUpdate, boolean isReplacement) {
        StationarySequence result;
        StationarySequence tailSequence;
        assert (!newFix.getTimePoint().before(this.getFirst().getTimePoint()));
        assert (!newFix.getTimePoint().after(this.getLast().getTimePoint()));
        Bounds newBounds = isReplacement ? this.recomputeBounds(false) : this.boundingBoxOfTrackSpanningCandidates.extend(newFix.getPosition());
        if (newBounds != null && newBounds.getDiameter().compareTo((Object)CANDIDATE_FILTER_DISTANCE) < 0) {
            this.boundingBoxOfTrackSpanningCandidates = newBounds;
            tailSequence = null;
        } else {
            ArrayList<Candidate> fullTailSet;
            TreeSet<Candidate> oldValidCandidates = new TreeSet<Candidate>(this.candidateComparator);
            Util.addAll(this.getValidCandidates(), oldValidCandidates);
            Candidate candidateForFixTimePoint = this.getCandidateMatchingTimePointOrCreateDummy(newFix.getTimePoint());
            SortedSet<Candidate> tailSet = this.candidates.tailSet(candidateForFixTimePoint);
            boolean tryToAddCandidateAtFixLater = false;
            if (!tailSet.isEmpty() && tailSet.first().getTimePoint().equals(candidateForFixTimePoint.getTimePoint())) {
                tryToAddCandidateAtFixLater = true;
                tailSet = this.candidates.tailSet(candidateForFixTimePoint, false);
                assert (!tailSet.contains(candidateForFixTimePoint));
            }
            StationarySequence stationarySequence = tailSequence = tailSet.isEmpty() ? null : this.createStationarySequence(tailSet);
            if (tailSequence != null && tryToAddCandidateAtFixLater) {
                tailSequence.tryToExtendBeforeFirst(this.candidates.floor(candidateForFixTimePoint), new TreeSet<Candidate>(this.candidateComparator), new TreeSet<Candidate>(this.candidateComparator), stationarySequenceSetToUpdate);
            }
            if (!(fullTailSet = new ArrayList<Candidate>(this.candidates.tailSet(candidateForFixTimePoint))).isEmpty() && fullTailSet.get(0) == this.getFirst()) {
                stationarySequenceSetToUpdate.remove(this);
            }
            this.candidates.removeAll(fullTailSet);
            for (Candidate candidateFromFullTailSet : fullTailSet) {
                Util.removeFromValueSet(this.candidatesByWaypoint, (Object)candidateFromFullTailSet.getWaypoint(), (Object)candidateFromFullTailSet);
                Util.removeFromValueSet(this.candidatesByWaypointSortedByAscendingProbability, (Object)candidateFromFullTailSet.getWaypoint(), (Object)candidateFromFullTailSet);
                assert (this.isCandidatesConsistent(candidateFromFullTailSet));
            }
            if (this.size() == 1) {
                stationarySequenceSetToUpdate.remove(this);
            }
            this.refreshBoundingBox();
            TreeSet<Candidate> newValidCandidates = new TreeSet<Candidate>(this.candidateComparator);
            Util.addAll(this.getValidCandidates(), newValidCandidates);
            if (tailSequence != null) {
                Util.addAll(tailSequence.getValidCandidates(), newValidCandidates);
            }
            TreeSet<Candidate> candidatesAdded = new TreeSet<Candidate>(this.candidateComparator);
            candidatesAdded.addAll(newValidCandidates);
            candidatesAdded.removeAll(oldValidCandidates);
            TreeSet<Candidate> candidatesRemoved = new TreeSet<Candidate>(this.candidateComparator);
            candidatesRemoved.addAll(oldValidCandidates);
            candidatesRemoved.removeAll(newValidCandidates);
            candidatesEffectivelyAdded.addAll(candidatesAdded);
            candidatesEffectivelyRemoved.removeAll(candidatesAdded);
            candidatesEffectivelyRemoved.addAll(candidatesRemoved);
            candidatesEffectivelyAdded.removeAll(candidatesRemoved);
        }
        StationarySequence stationarySequence = result = tailSequence != null && tailSequence.size() >= 2 ? tailSequence : null;
        assert (result == null || !this.getLast().getTimePoint().equals(result.getFirst().getTimePoint()));
        return result;
    }

    private StationarySequence createStationarySequence(SortedSet<Candidate> candidates) {
        TreeSet<Candidate> candidatesEffectivelyAdded = new TreeSet<Candidate>(this.candidateComparator);
        TreeSet<Candidate> candidatesEffectivelyRemoved = new TreeSet<Candidate>(this.candidateComparator);
        Iterator candidateIterator = candidates.iterator();
        assert (candidateIterator.hasNext());
        StationarySequence result = new StationarySequence((Candidate)candidateIterator.next(), this.candidateComparator, this.track);
        while (candidateIterator.hasNext()) {
            Candidate nextCandidate = (Candidate)candidateIterator.next();
            boolean extensionOk = result.tryToExtendAfterLast(nextCandidate, candidatesEffectivelyAdded, candidatesEffectivelyRemoved);
            assert (extensionOk);
            assert (this.isCandidatesConsistent(nextCandidate));
        }
        return result;
    }

    private Candidate getCandidateMatchingTimePointOrCreateDummy(TimePoint timePoint) {
        CandidateImpl dummy = new CandidateImpl(1, timePoint, 0.0, null);
        Candidate floorCandidate = this.candidates.floor(dummy);
        Candidate ceilingCandidate = this.candidates.ceiling(dummy);
        Candidate result = floorCandidate != null && floorCandidate.getTimePoint().equals(timePoint) ? floorCandidate : (ceilingCandidate != null && ceilingCandidate.getTimePoint().equals(timePoint) ? ceilingCandidate : dummy);
        return result;
    }

    public String toString() {
        return "Stationary Sequence " + this.candidates + ", bounds diameter " + this.boundingBoxOfTrackSpanningCandidates.getDiameter();
    }

    static Candidate createDummyCandidate(TimePoint timePoint) {
        return new CandidateImpl(1, timePoint, 0.0, null);
    }

    public Iterable<Candidate> getAllCandidates() {
        return Collections.unmodifiableCollection(this.candidates);
    }

    public boolean contains(Candidate candidate) {
        return this.candidates.contains(candidate);
    }
}

